/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fenixedu.academic.util.report.ReportPrinter;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FenixReport
implements Serializable,
ReportPrinter.ReportDescription {
    private static final Logger logger = LoggerFactory.getLogger(FenixReport.class);
    private final Collection dataSource;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Locale locale;
    private final Locale language;
    protected static final String EMPTY_STR = "";
    protected static final String SINGLE_SPACE = " ";
    protected static final String DD_MMMM_YYYY = "dd MMMM yyyy";
    protected static final String DD_SLASH_MM_SLASH_YYYY = "dd/MM/yyyy";
    protected static final String YYYYMMMDD = "yyyyMMdd";
    protected static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    protected FenixReport() {
        this(null, I18N.getLocale());
    }

    protected FenixReport(Locale locale) {
        this(null, locale);
    }

    private FenixReport(Collection<?> dataSource, Locale locale) {
        this.dataSource = dataSource == null ? new ArrayList() : dataSource;
        this.locale = locale;
        this.language = locale;
    }

    @Override
    public final Collection<?> getDataSource() {
        return this.dataSource;
    }

    @Override
    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getLanguage() {
        return this.language;
    }

    @Override
    public String getKey() {
        return this.getReportTemplateKey();
    }

    public String getReportTemplateKey() {
        return this.getClass().getName();
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void addDataSourceElement(Object object) {
        this.dataSource.add(object);
    }

    public void addDataSourceElements(Collection<?> objects) {
        this.dataSource.addAll(objects);
    }

    public abstract String getReportFileName();

    protected abstract void fillReport();

    protected void printParameters() {
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            logger.info(String.format("%s - %s", entry.getKey(), entry.getValue()));
        }
    }
}

