/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.resourceAllocationManager;

import java.io.Serializable;
import org.fenixedu.academic.dto.resourceAllocationManager.OccupationType;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SpaceOccupationEventBean
implements Serializable {
    private static final String TIME_FORMAT = "HH:mm";
    private static final String DATE_FORMAT = "dd/MM/yyyy";
    private Space space;
    private Interval interval;
    private String description;
    private OccupationType type;

    public SpaceOccupationEventBean(Space space, Interval interval, String description, OccupationType type) {
        this.space = space;
        this.interval = interval;
        this.description = description;
        this.type = type;
    }

    public String getPresentationInterval() {
        DateTime start = this.interval.getStart();
        DateTime end = this.interval.getEnd();
        DateMidnight dateMidnight = start.toDateMidnight();
        if (dateMidnight.equals((Object)end.toDateMidnight())) {
            return String.format("%s : %s as %s", dateMidnight.toString(DATE_FORMAT), this.getTime(start), this.getTime(end));
        }
        return this.interval.toString();
    }

    public boolean isIntervalInSameDay() {
        return this.getDateDay() != null;
    }

    public DateMidnight getDateDay() {
        DateTime start = this.interval.getStart();
        DateTime end = this.interval.getEnd();
        DateMidnight dateMidnight = start.toDateMidnight();
        if (dateMidnight.equals((Object)end.toDateMidnight())) {
            return dateMidnight;
        }
        return null;
    }

    private String getTime(DateTime time) {
        return time.toString(TIME_FORMAT);
    }

    public String getStartTime() {
        return this.getTime(this.interval.getStart());
    }

    public String getEndTime() {
        return this.getTime(this.interval.getEnd());
    }

    public String getDay() {
        DateMidnight dateDay = this.getDateDay();
        if (dateDay == null) {
            return String.format("%s - %s", this.interval.getStart().toString(DATE_FORMAT), this.interval.getEnd().toString(DATE_FORMAT));
        }
        return dateDay.toString(DATE_FORMAT);
    }

    public String getSpaceName() {
        return this.space.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public Space getSpace() {
        return this.space;
    }

    public OccupationType getOccupationType() {
        return this.type;
    }

    public void setOccupationType(OccupationType type) {
        this.type = type;
    }
}

