/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.MarkSheetState;

public class MarkSheetSearchResultBean {
    private boolean showStatistics;
    private int totalNumberOfStudents;
    private List<MarkSheet> markSheets = new ArrayList<MarkSheet>();

    public List<MarkSheet> getMarkSheets() {
        return this.markSheets;
    }

    public Collection<MarkSheet> getMarkSheetsSortedByEvaluationDate() {
        Collections.sort(this.getMarkSheets(), MarkSheet.COMPARATOR_BY_EVALUATION_DATE_AND_CREATION_DATE_AND_ID);
        return this.getMarkSheets();
    }

    public void setMarkSheets(List<MarkSheet> markSheets) {
        this.markSheets = markSheets;
    }

    public void addMarkSheet(MarkSheet markSheet) {
        this.getMarkSheets().add(markSheet);
    }

    public int getNumberOfEnroledStudents() {
        int numberOfEnroledStudents = 0;
        for (MarkSheet markSheet : this.getMarkSheets()) {
            if (this.isRectificationMarkSheet(markSheet.getMarkSheetState())) continue;
            numberOfEnroledStudents += markSheet.getEnrolmentEvaluationsSet().size();
        }
        return numberOfEnroledStudents;
    }

    private boolean isRectificationMarkSheet(MarkSheetState markSheetState) {
        return markSheetState == MarkSheetState.RECTIFICATION || markSheetState == MarkSheetState.RECTIFICATION_NOT_CONFIRMED;
    }

    public int getTotalNumberOfStudents() {
        return this.totalNumberOfStudents;
    }

    public void setTotalNumberOfStudents(int totalNumberStudents) {
        this.totalNumberOfStudents = totalNumberStudents;
    }

    public boolean isShowStatistics() {
        return this.showStatistics;
    }

    public void setShowStatistics(boolean showStatistics) {
        this.showStatistics = showStatistics;
    }
}

