/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.administrativeOffice.dismissal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.dto.student.IStudentCurricularPlanBean;

public class DismissalBean
implements Serializable,
IStudentCurricularPlanBean {
    private static final long serialVersionUID = 1L;
    private StudentCurricularPlan studentCurricularPlan;
    private ExecutionSemester executionSemester;
    private Collection<SelectedCurricularCourse> dismissals;
    private Collection<SelectedOptionalCurricularCourse> optionalDismissals;
    private CourseGroup courseGroup;
    private CurriculumGroup curriculumGroup;
    private Collection<SelectedEnrolment> enrolments;
    private Collection<SelectedExternalEnrolment> externalEnrolments;
    private DismissalType dismissalType;
    private Double credits;
    private Grade grade;

    public Collection<SelectedCurricularCourse> getDismissals() {
        return this.dismissals;
    }

    public void setDismissals(Collection<SelectedCurricularCourse> dismissals) {
        this.dismissals = dismissals;
    }

    public boolean hasAnyDismissals() {
        return this.getDismissals() != null && !this.getDismissals().isEmpty();
    }

    public boolean containsDismissal(CurricularCourse curricularCourse) {
        if (this.getDismissals() != null) {
            for (SelectedCurricularCourse selectedCurricularCourse : this.getDismissals()) {
                if (!selectedCurricularCourse.getCurricularCourse().equals((Object)curricularCourse)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<SelectedOptionalCurricularCourse> getOptionalDismissals() {
        return this.optionalDismissals;
    }

    public void setOptionalDismissals(Collection<SelectedOptionalCurricularCourse> optionalDismissals) {
        this.optionalDismissals = optionalDismissals;
    }

    public boolean hasAnyOptionalDismissals() {
        return this.getOptionalDismissals() != null && !this.getOptionalDismissals().isEmpty();
    }

    public boolean containsOptionalDismissal(CurricularCourse curricularCourse) {
        if (this.getOptionalDismissals() != null) {
            for (SelectedOptionalCurricularCourse selectedCurricularCourse : this.getOptionalDismissals()) {
                if (!selectedCurricularCourse.getCurricularCourse().equals((Object)curricularCourse)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsDismissalOrOptionalDismissal(CurricularCourse curricularCourse) {
        return this.containsDismissal(curricularCourse) || this.containsOptionalDismissal(curricularCourse);
    }

    public Collection<SelectedCurricularCourse> getAllDismissals() {
        ArrayList<SelectedCurricularCourse> result = new ArrayList<SelectedCurricularCourse>();
        if (this.getDismissals() != null) {
            result.addAll(this.getDismissals());
        }
        if (this.getOptionalDismissals() != null) {
            result.addAll(this.getOptionalDismissals());
        }
        return result;
    }

    public Collection<SelectedEnrolment> getEnrolments() {
        return this.enrolments;
    }

    public void setEnrolments(Collection<SelectedEnrolment> enrolments) {
        this.enrolments = enrolments;
    }

    public CourseGroup getCourseGroup() {
        return this.courseGroup;
    }

    public void setCourseGroup(CourseGroup courseGroup) {
        this.courseGroup = courseGroup;
    }

    public CurriculumGroup getCurriculumGroup() {
        return this.curriculumGroup;
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        this.curriculumGroup = curriculumGroup;
    }

    @Override
    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public DismissalType getDismissalType() {
        return this.dismissalType;
    }

    public void setDismissalType(DismissalType dismissalType) {
        this.dismissalType = dismissalType;
    }

    public Grade getGrade() {
        return this.grade;
    }

    public void setGrade(Grade grade) {
        this.grade = grade;
    }

    public Double getCredits() {
        return this.credits;
    }

    public void setCredits(Double credits) {
        this.credits = credits;
    }

    public Collection<SelectedExternalEnrolment> getExternalEnrolments() {
        return this.externalEnrolments;
    }

    public void setExternalEnrolments(Collection<SelectedExternalEnrolment> externalEnrolments) {
        this.externalEnrolments = externalEnrolments;
    }

    public Collection<IEnrolment> getSelectedEnrolments() {
        ArrayList<IEnrolment> result = new ArrayList<IEnrolment>();
        if (this.getEnrolments() != null) {
            for (SelectedEnrolment selectedEnrolment : this.getEnrolments()) {
                if (!selectedEnrolment.getSelected().booleanValue()) continue;
                result.add(selectedEnrolment.getEnrolment());
            }
        }
        if (this.getExternalEnrolments() != null) {
            for (SelectedExternalEnrolment selectedExternalEnrolment : this.getExternalEnrolments()) {
                if (!selectedExternalEnrolment.getSelected().booleanValue()) continue;
                result.add(selectedExternalEnrolment.getExternalEnrolment());
            }
        }
        return result;
    }

    public boolean hasAnySelectedIEnrolments() {
        return !this.getSelectedEnrolments().isEmpty();
    }

    public Student getStudent() {
        return this.getStudentCurricularPlan().getRegistration().getStudent();
    }

    public Collection<? extends CurricularCourse> getAllCurricularCoursesToDismissal() {
        return this.studentCurricularPlan.getAllCurricularCoursesToDismissal(this.executionSemester);
    }

    public static enum DismissalType {
        CURRICULAR_COURSE_CREDITS,
        CURRICULUM_GROUP_CREDITS,
        NO_COURSE_GROUP_CURRICULUM_GROUP_CREDITS;


        public String getName() {
            return this.name();
        }
    }

    public static class SelectedExternalEnrolment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean selected = Boolean.FALSE;
        private ExternalEnrolment externalEnrolment;

        public SelectedExternalEnrolment(ExternalEnrolment externalEnrolment) {
            this.setExternalEnrolment(externalEnrolment);
        }

        public ExternalEnrolment getExternalEnrolment() {
            return this.externalEnrolment;
        }

        public void setExternalEnrolment(ExternalEnrolment externalEnrolment) {
            this.externalEnrolment = externalEnrolment;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SelectedExternalEnrolment)) {
                return false;
            }
            return this.equals((SelectedExternalEnrolment)obj);
        }

        public boolean equals(SelectedExternalEnrolment other) {
            return this.getExternalEnrolment() == other.getExternalEnrolment();
        }

        public int hashCode() {
            return this.getExternalEnrolment().hashCode();
        }
    }

    public static class SelectedEnrolment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean selected = Boolean.FALSE;
        private Enrolment enrolment;

        public SelectedEnrolment(Enrolment enrolment) {
            this.setEnrolment(enrolment);
        }

        public Enrolment getEnrolment() {
            return this.enrolment;
        }

        public void setEnrolment(Enrolment enrolment) {
            this.enrolment = enrolment;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SelectedEnrolment)) {
                return false;
            }
            return this.equals((SelectedEnrolment)obj);
        }

        public boolean equals(SelectedEnrolment other) {
            return this.getEnrolment() == other.getEnrolment();
        }

        public int hashCode() {
            return this.getEnrolment().hashCode();
        }
    }

    public static class SelectedOptionalCurricularCourse
    extends SelectedCurricularCourse {
        private static final long serialVersionUID = 1L;
        private Double credits;

        public SelectedOptionalCurricularCourse(OptionalCurricularCourse curricularCourse, StudentCurricularPlan studentCurricularPlan) {
            super((CurricularCourse)((Object)curricularCourse), studentCurricularPlan);
        }

        public OptionalCurricularCourse getCurricularCourse() {
            return (OptionalCurricularCourse)((Object)super.getCurricularCourse());
        }

        public Double getCredits() {
            return this.credits;
        }

        public void setCredits(Double credits) {
            this.credits = credits;
        }

        @Override
        public boolean isOptional() {
            return true;
        }
    }

    public static class SelectedCurricularCourse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean selected = Boolean.FALSE;
        private CurricularCourse curricularCourse;
        private CurriculumGroup curriculumGroup;
        private StudentCurricularPlan studentCurricularPlan;

        public SelectedCurricularCourse(CurricularCourse curricularCourse, StudentCurricularPlan studentCurricularPlan) {
            this.setCurricularCourse(curricularCourse);
            this.setStudentCurricularPlan(studentCurricularPlan);
        }

        public CurricularCourse getCurricularCourse() {
            return this.curricularCourse;
        }

        public void setCurricularCourse(CurricularCourse curricularCourse) {
            this.curricularCourse = curricularCourse;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        public CurriculumGroup getCurriculumGroup() {
            return this.curriculumGroup;
        }

        public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
            this.curriculumGroup = curriculumGroup;
        }

        public StudentCurricularPlan getStudentCurricularPlan() {
            return this.studentCurricularPlan;
        }

        public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
            this.studentCurricularPlan = studentCurricularPlan;
        }

        public String getKey() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getCurricularCourse() != null) {
                stringBuilder.append(((Object)((Object)this.getCurricularCourse())).getClass().getName()).append(":").append(this.getCurricularCourse().getExternalId());
            }
            stringBuilder.append(",");
            if (this.getCurriculumGroup() != null) {
                stringBuilder.append(((Object)((Object)this.getCurriculumGroup())).getClass().getName()).append(":").append(this.getCurriculumGroup().getExternalId());
            }
            stringBuilder.append(",");
            if (this.getStudentCurricularPlan() != null) {
                stringBuilder.append(((Object)((Object)this.getStudentCurricularPlan())).getClass().getName()).append(":").append(this.getStudentCurricularPlan().getExternalId());
            }
            return stringBuilder.toString();
        }

        public boolean isOptional() {
            return false;
        }
    }
}

