/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.dto.InfoRoomOccupation;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class InfoLessonInstance
extends InfoShowOccupation {
    private final LessonInstance lessonInstanceReference;

    public InfoLessonInstance(LessonInstance lessonInstance) {
        this.lessonInstanceReference = lessonInstance;
    }

    public LessonInstance getLessonInstance() {
        return this.lessonInstanceReference;
    }

    @Override
    public DiaSemana getDiaSemana() {
        return this.getLessonInstance().getDayOfweek();
    }

    @Override
    public InfoRoomOccupation getInfoRoomOccupation() {
        return this.getLessonInstance().getLessonInstanceSpaceOccupation() != null ? InfoRoomOccupation.newInfoFromDomain((EventSpaceOccupation)((Object)this.getLessonInstance().getLessonInstanceSpaceOccupation())) : null;
    }

    @Override
    public String getExternalId() {
        return this.getLessonInstance().getExternalId();
    }

    @Override
    public Calendar getInicio() {
        return this.getLessonInstance().getBeginDateTime().toCalendar(I18N.getLocale());
    }

    @Override
    public Calendar getFim() {
        return this.getLessonInstance().getEndDateTime().toCalendar(I18N.getLocale());
    }

    @Override
    public InfoShift getInfoShift() {
        return this.getLessonInstance().getLesson().getShift() != null ? InfoShift.newInfoFromDomain(this.getLesson().getShift()) : null;
    }

    @Override
    public ShiftType getTipo() {
        return null;
    }

    public String getShiftTypeCodesPrettyPrint() {
        if (this.getLessonInstance().getCourseLoad() != null) {
            return this.getLessonInstance().getCourseLoad().getType().getSiglaTipoAula();
        }
        return this.getLessonInstance().getLesson().getShift().getShiftTypesCodePrettyPrint();
    }

    public String getShiftTypesPrettyPrint() {
        if (this.getLessonInstance().getCourseLoad() != null) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getLessonInstance().getCourseLoad().getType().getName(), (String[])new String[0]);
        }
        return this.getLessonInstance().getLesson().getShift().getShiftTypesPrettyPrint();
    }

    private Lesson getLesson() {
        return this.getLessonInstance().getLesson();
    }
}

