/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.treasury;

import java.math.BigDecimal;
import java.util.List;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEventPayment;
import org.joda.time.LocalDate;

public interface IImprovementTreasuryEvent
extends IAcademicTreasuryEvent {
    public boolean isWithDebitEntry(EnrolmentEvaluation var1);

    public boolean isExempted(EnrolmentEvaluation var1);

    default public boolean isPayed(EnrolmentEvaluation enrolmentEvaluation) {
        return this.getRemainingAmountToPay(enrolmentEvaluation).compareTo(BigDecimal.ZERO) <= 0;
    }

    default public boolean isInDebt(EnrolmentEvaluation enrolmentEvaluation) {
        return this.getRemainingAmountToPay(enrolmentEvaluation).compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isDueDateExpired(EnrolmentEvaluation var1, LocalDate var2);

    public boolean isBlockingAcademicalActs(EnrolmentEvaluation var1, LocalDate var2);

    public BigDecimal getAmountToPay(EnrolmentEvaluation var1);

    public BigDecimal getRemainingAmountToPay(EnrolmentEvaluation var1);

    public BigDecimal getExemptedAmount(EnrolmentEvaluation var1);

    public LocalDate getDueDate(EnrolmentEvaluation var1);

    public String getExemptionReason(EnrolmentEvaluation var1);

    public List<IAcademicTreasuryEventPayment> getPaymentsList(EnrolmentEvaluation var1);
}

