/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ProgramCertificateRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class ProgramCertificateRequest
extends ProgramCertificateRequest_Base {
    protected ProgramCertificateRequest() {
        this.setNumberOfPages(0);
    }

    public ProgramCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.getEnrolmentsSet().addAll(bean.getEnrolments());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getEnrolments().isEmpty()) {
            throw new DomainException("error.CourseLoadRequest.invalid.number.of.enrolments", new String[0]);
        }
        for (Enrolment enrolment : bean.getEnrolments()) {
            if (!enrolment.isApproved()) {
                throw new DomainException("error.ProgramCertificateRequest.cannot.add.not.approved.enrolments", new String[0]);
            }
            if (this.getStudent().hasEnrolments(enrolment)) continue;
            throw new DomainException("error.ProgramCertificateRequest.enrolment.doesnot.belong.to.student", new String[0]);
        }
    }

    public Integer getNumberOfUnits() {
        return this.getEnrolmentsSet().size();
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.PROGRAM_CERTIFICATE;
    }

    public String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public EventType getEventType() {
        return EventType.PROGRAM_CERTIFICATE_REQUEST;
    }

    protected void disconnect() {
        this.getEnrolmentsSet().clear();
        super.disconnect();
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToCancelOrReject()) {
            while (!this.getEnrolmentsSet().isEmpty()) {
                this.removeEnrolments((Enrolment)this.getEnrolmentsSet().iterator().next());
            }
        }
    }

    public boolean isFree() {
        return this.getRegistration().getRegistrationProtocol().isMilitaryAgreement() || super.isFree();
    }
}

