/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.util.Arrays;
import java.util.List;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.ReingressionPeriod;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.StudentReingressionRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.joda.time.DateTime;

public class StudentReingressionRequest
extends StudentReingressionRequest_Base {
    public static final List<RegistrationStateType> ALLOWED_TYPES = Arrays.asList(RegistrationStateType.FLUNKED, RegistrationStateType.INTERRUPTED, RegistrationStateType.EXTERNAL_ABANDON);

    protected StudentReingressionRequest() {
    }

    public StudentReingressionRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        this.checkParameters(bean);
        this.checkRulesToCreate(bean);
        super.init(bean);
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        if (bean.getExecutionYear() == null) {
            throw new DomainException("error.StudentReingressionRequest.executionYear.cannot.be.null", new String[0]);
        }
    }

    private void checkRulesToCreate(RegistrationAcademicServiceRequestCreateBean bean) {
        Registration registration = bean.getRegistration();
        ExecutionYear executionYear = bean.getExecutionYear();
        DateTime requestDate = bean.getRequestDate();
        if (!this.hasValidState(registration)) {
            throw new DomainException("error.StudentReingressionRequest.registration.with.invalid.state", new String[0]);
        }
        if (registration.isRegistrationConclusionProcessed()) {
            throw new DomainException("error.StudentReingressionRequest.registration.has.conclusion.processed", new String[0]);
        }
        if (!this.isEnrolmentPeriodOpen(registration, executionYear, requestDate)) {
            throw new DomainException("error.StudentReingressionRequest.out.of.enrolment.period", new String[0]);
        }
        if (this.alreadyHasRequest(registration, executionYear)) {
            throw new DomainException("error.StudentReingressionRequest.already.has.request.to.same.executionYear", new String[0]);
        }
        if (registration.getStudent().isAnyGratuityOrAdministrativeOfficeFeeAndInsuranceInDebt(executionYear)) {
            throw new DomainException("error.StudentReingressionRequest.student.has.debts", new String[0]);
        }
    }

    private boolean alreadyHasRequest(Registration registration, ExecutionYear executionYear) {
        for (AcademicServiceRequest academicServiceRequest : registration.getAcademicServiceRequests(((Object)((Object)this)).getClass(), executionYear)) {
            if (academicServiceRequest.finishedUnsuccessfully()) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidState(Registration registration) {
        return registration.hasAnyState(ALLOWED_TYPES);
    }

    private boolean isEnrolmentPeriodOpen(Registration registration, ExecutionYear executionYear, DateTime requestDate) {
        DegreeCurricularPlan degreeCurricularPlan = registration.getLastDegreeCurricularPlan();
        return this.hasOpenEnrolmentPeriod(degreeCurricularPlan, executionYear, requestDate);
    }

    private boolean hasOpenEnrolmentPeriod(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, DateTime requestDate) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            ReingressionPeriod period = degreeCurricularPlan.getReingressionPeriod(executionSemester);
            if (period == null || !period.containsDate(requestDate)) continue;
            return true;
        }
        return false;
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.REINGRESSION;
    }

    public EventType getEventType() {
        return EventType.STUDENT_REINGRESSION_REQUEST;
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        super.createAcademicServiceRequestSituations(academicServiceRequestBean);
        if (!academicServiceRequestBean.isNew() && academicServiceRequestBean.isToConclude()) {
            AcademicServiceRequestSituation.create((AcademicServiceRequest)((Object)this), new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, academicServiceRequestBean.getResponsible()));
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToProcess()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        } else if (academicServiceRequestBean.isToConclude() && this.hasExecutionDegree()) {
            RegistrationState state = RegistrationState.createRegistrationState(this.getRegistration(), academicServiceRequestBean.getResponsible(), academicServiceRequestBean.getFinalSituationDate(), RegistrationStateType.REGISTERED);
            if (this.getRegistration().getActiveState() != state) {
                throw new DomainException("StudentReingressionRequest.reingression.must.be.active.state.after.request.conclusion", new String[0]);
            }
        }
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getRegistration().getLastDegreeCurricularPlan();
    }

    private boolean hasExecutionDegree() {
        return this.getDegreeCurricularPlan().hasExecutionDegreeFor(this.getExecutionYear());
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

