/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration.common;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.phd.migration.common.NationalityTranslator;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.IncorrectDateFormatException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.InvalidGenderValueException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;

public class ConversionUtilities {
    private static String[] CORRECT_DATE_PATTERNS = new String[]{"ddMMyyyy", "MMyyyy"};

    public static LocalDate parseDate(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if (value.length() < 2) {
            return null;
        }
        LocalDate result = null;
        String normalizedValue = value;
        if (value.length() == "dMMyyyy".length()) {
            normalizedValue = "0".concat(value);
        }
        for (String pattern : CORRECT_DATE_PATTERNS) {
            try {
                result = DateTimeFormat.forPattern((String)pattern).parseDateTime(normalizedValue).toLocalDate();
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!result.isAfter((ReadablePartial)DateTimeFormat.forPattern((String)"yyyy").parseDateTime("1920").toLocalDate()) || !result.isBefore((ReadablePartial)DateTimeFormat.forPattern((String)"yyy").parseDateTime("2020").toLocalDate())) continue;
            return result;
        }
        throw new IncorrectDateFormatException(value);
    }

    public static Gender parseGender(String value) {
        if ("M".equals(value)) {
            return Gender.MALE;
        }
        if ("F".equals(value)) {
            return Gender.FEMALE;
        }
        throw new InvalidGenderValueException();
    }

    public static Country translateNationality(String value) {
        return NationalityTranslator.translate(value);
    }
}

