/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration;

import java.util.Map;
import java.util.NoSuchElementException;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationGuiding_Base;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.IncompleteFieldsException;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PhdMigrationGuidingNotFoundException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;

public class PhdMigrationGuiding
extends PhdMigrationGuiding_Base {
    public static final String IST_INSTITUTION_CODE = "1518";

    protected PhdMigrationGuiding() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected PhdMigrationGuiding(String data) {
        this.setData(data);
    }

    public PhdMigrationGuidingBean getGuidingBean() {
        return new PhdMigrationGuidingBean(this.getData());
    }

    public void parseAndSetNumber(Map<String, String> INSTITUTION_MAP) {
        PhdMigrationGuidingBean guidingBean = this.getGuidingBean();
        this.setTeacherId(guidingBean.getTeacherId());
        this.setInstitution(INSTITUTION_MAP.get(guidingBean.getInstitutionCode()));
    }

    public boolean isExternal() {
        return !this.getGuidingBean().getInstitutionCode().equals(IST_INSTITUTION_CODE);
    }

    public PhdParticipantBean getPhdParticipantBean(PhdIndividualProgramProcess individualProcess) {
        if (this.isExternal()) {
            return this.getExternalPhdParticipantBean(individualProcess);
        }
        return this.getInternalPhdParticipantBean(individualProcess);
    }

    private PhdParticipantBean getExternalPhdParticipantBean(PhdIndividualProgramProcess individualProcess) {
        PhdParticipantBean participantBean = new PhdParticipantBean();
        participantBean.setParticipantType(PhdParticipantBean.PhdParticipantType.EXTERNAL);
        participantBean.setParticipantSelectType(PhdParticipantBean.PhdParticipantSelectType.NEW);
        participantBean.setIndividualProgramProcess(individualProcess);
        participantBean.setName(this.getGuidingBean().getName());
        participantBean.setWorkLocation(this.getInstitution());
        participantBean.setInstitution(this.getInstitution());
        return participantBean;
    }

    private PhdParticipantBean getInternalPhdParticipantBean(PhdIndividualProgramProcess individualProcess) {
        PhdParticipantBean participantBean = new PhdParticipantBean();
        participantBean.setIndividualProgramProcess(individualProcess);
        Teacher teacher = User.findByUsername((String)this.getGuidingBean().getTeacherId()).getPerson().getTeacher();
        if (teacher == null) {
            throw new PhdMigrationGuidingNotFoundException("The guiding is not present in the system as a teacher");
        }
        for (PhdParticipant existingParticipant : individualProcess.getParticipantsSet()) {
            if (!existingParticipant.isInternal()) continue;
            InternalPhdParticipant existingInternalParticipant = (InternalPhdParticipant)((Object)existingParticipant);
            Person existingInternalPerson = existingInternalParticipant.getPerson();
            if (teacher.getPerson() != existingInternalPerson) continue;
            participantBean.setInternalParticipant(teacher.getPerson());
            participantBean.setParticipant(existingParticipant);
            participantBean.setParticipantSelectType(PhdParticipantBean.PhdParticipantSelectType.EXISTING);
            return participantBean;
        }
        participantBean.setParticipantSelectType(PhdParticipantBean.PhdParticipantSelectType.NEW);
        participantBean.setInternalParticipant(teacher.getPerson());
        participantBean.setInstitution(this.getInstitution());
        participantBean.setWorkLocation(this.getInstitution());
        return participantBean;
    }

    public static class PhdMigrationGuidingBean {
        private transient String data;
        private transient Integer phdStudentNumber;
        private transient String institutionCode;
        private transient String name;
        private transient String teacherId;

        public PhdMigrationGuidingBean(String data) {
            this.setData(data);
            this.parse();
        }

        public void parse() {
            try {
                String[] compounds = this.getData().split("\\t");
                this.phdStudentNumber = Integer.parseInt(compounds[0].trim());
                this.teacherId = compounds[2].trim();
                this.institutionCode = compounds[3].trim();
                this.name = compounds[4].trim();
            }
            catch (NoSuchElementException e) {
                throw new IncompleteFieldsException();
            }
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public Integer getPhdStudentNumber() {
            return this.phdStudentNumber;
        }

        public void setPhdStudentNumber(Integer phdStudentNumber) {
            this.phdStudentNumber = phdStudentNumber;
        }

        public String getInstitutionCode() {
            return this.institutionCode;
        }

        public void setInstitutionCode(String institutionCode) {
            this.institutionCode = institutionCode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTeacherId() {
            return this.teacherId;
        }

        public void setTeacherId(String teacherId) {
            this.teacherId = teacherId;
        }
    }
}

