/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.InlinePredicate;

public class SearchPhdIndividualProgramProcessBean
implements Serializable {
    private static final long serialVersionUID = -5653277152319382139L;
    private SearchCriterion searchCriterion = SearchCriterion.PROCESS_NUMBER;
    private String searchValue;
    private ExecutionYear executionYear;
    private PhdIndividualProgramProcessState processState;
    private String processNumber;
    private Integer studentNumber;
    private Integer phdStudentNumber;
    private List<PhdProgram> phdPrograms;
    private Boolean filterPhdPrograms = Boolean.TRUE;
    private List<PhdIndividualProgramProcess> processes;
    private Boolean filterPhdProcesses = Boolean.TRUE;
    private String name;
    private PhdProgramCandidacyProcessState candidacyProcessState;
    private PhdThesisProcessStateType thesisProcessState;
    private PhdProgram phdProgram;
    private OnlineApplicationFilter onlineApplicationFilter;
    private PhdCandidacyPeriod phdCandidacyPeriod;
    private PhdIndividualProgramCollaborationType phdCollaborationType;

    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public void setSearchCriterion(SearchCriterion searchCriterion) {
        this.searchCriterion = searchCriterion;
    }

    public SearchCriterion getSearchCriterion() {
        return this.searchCriterion;
    }

    public PhdProgramCandidacyProcessState getCandidacyProcessState() {
        return this.candidacyProcessState;
    }

    public void setCandidacyProcessState(PhdProgramCandidacyProcessState candidacyProcessState) {
        this.candidacyProcessState = candidacyProcessState;
    }

    public Boolean getFilterPhdPrograms() {
        return this.filterPhdPrograms;
    }

    public void setFilterPhdPrograms(Boolean filterPhdPrograms) {
        this.filterPhdPrograms = filterPhdPrograms;
    }

    public Boolean getFilterPhdProcesses() {
        return this.filterPhdProcesses;
    }

    public void setFilterPhdProcesses(Boolean filterPhdProcesses) {
        this.filterPhdProcesses = filterPhdProcesses;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PhdProgram> getPhdPrograms() {
        ArrayList<PhdProgram> result = new ArrayList<PhdProgram>();
        for (PhdProgram each : this.phdPrograms) {
            result.add(each);
        }
        return result;
    }

    public void setPhdPrograms(List<PhdProgram> phdPrograms) {
        this.setPhdPrograms((Collection<PhdProgram>)phdPrograms);
    }

    public void setPhdPrograms(Collection<PhdProgram> phdPrograms) {
        ArrayList<PhdProgram> result = new ArrayList<PhdProgram>();
        for (PhdProgram each : phdPrograms) {
            result.add(each);
        }
        this.phdPrograms = result;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public PhdIndividualProgramProcessState getProcessState() {
        return this.processState;
    }

    public void setProcessState(PhdIndividualProgramProcessState processState) {
        this.processState = processState;
    }

    public String getProcessNumber() {
        return this.processNumber;
    }

    public void setProcessNumber(String processNumber) {
        this.processNumber = processNumber;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public PhdThesisProcessStateType getThesisProcessState() {
        return this.thesisProcessState;
    }

    public void setThesisProcessState(PhdThesisProcessStateType thesisProcessStateType) {
        this.thesisProcessState = thesisProcessStateType;
    }

    public PhdCandidacyPeriod getPhdCandidacyPeriod() {
        return this.phdCandidacyPeriod;
    }

    public void setPhdCandidacyPeriod(PhdCandidacyPeriod phdCandidacyPeriod) {
        this.phdCandidacyPeriod = phdCandidacyPeriod;
    }

    public List<PhdIndividualProgramProcess> getProcesses() {
        ArrayList<PhdIndividualProgramProcess> result = new ArrayList<PhdIndividualProgramProcess>();
        for (PhdIndividualProgramProcess each : this.processes) {
            result.add(each);
        }
        return result;
    }

    public void setProcesses(List<PhdIndividualProgramProcess> processes) {
        ArrayList<PhdIndividualProgramProcess> result = new ArrayList<PhdIndividualProgramProcess>();
        for (PhdIndividualProgramProcess each : processes) {
            result.add(each);
        }
        this.processes = result;
    }

    public AndPredicate<PhdIndividualProgramProcess> getPredicates() {
        if (this.getSearchValue() != null && !this.getSearchValue().isEmpty()) {
            String searchValue = this.getSearchValue().trim();
            this.setProcessNumber(this.getSearchCriterion() == SearchCriterion.PROCESS_NUMBER ? searchValue : null);
            this.setStudentNumber(this.getSearchCriterion() == SearchCriterion.STUDENT_NUMBER ? Integer.valueOf(searchValue) : null);
            this.setPhdStudentNumber(this.getSearchCriterion() == SearchCriterion.PHD_STUDENT_NUMBER ? Integer.valueOf(searchValue) : null);
            this.setName(this.getSearchCriterion() == SearchCriterion.NAME ? searchValue : null);
        }
        AndPredicate<PhdIndividualProgramProcess> result = new AndPredicate<PhdIndividualProgramProcess>();
        result.add(this.getManagedPhdProgramsAndProcessesPredicate());
        if (this.getStudentNumber() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, Integer>(this.getStudentNumber()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return toEval.getStudent() != null && toEval.getStudent().getNumber().compareTo((Integer)this.getValue()) == 0;
                }
            });
            return result;
        }
        if (!StringUtils.isEmpty((String)this.getProcessNumber())) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, String>(this.getProcessNumber()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return toEval.getProcessNumber().equals(this.getValue());
                }
            });
            return result;
        }
        if (this.getPhdStudentNumber() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, Integer>(this.getPhdStudentNumber()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return toEval.getPhdStudentNumber() != null && toEval.getPhdStudentNumber().compareTo((Integer)this.getValue()) == 0;
                }
            });
            return result;
        }
        if (!StringUtils.isEmpty((String)this.getName())) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, String>(this.getName()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return Person.findPerson((String)this.getValue()).contains((Object)toEval.getPerson());
                }
            });
            return result;
        }
        result.add(this.getAndPredicate());
        return result;
    }

    public AndPredicate<PhdIndividualProgramProcess> getAndPredicate() {
        AndPredicate<PhdIndividualProgramProcess> result = new AndPredicate<PhdIndividualProgramProcess>();
        result.add(this.getManagedPhdProgramsAndProcessesPredicate());
        if (this.getExecutionYear() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, ExecutionYear>(this.getExecutionYear()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return toEval.getExecutionYear() == this.getValue();
                }
            });
        }
        if (this.getPhdProgram() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdProgram>(this.getPhdProgram()){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return process2.getPhdProgram() == this.getValue();
                }
            });
        }
        if (this.getProcessState() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdIndividualProgramProcessState>(this.getProcessState()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return toEval.getActiveState() == this.getValue();
                }
            });
        }
        if (PhdIndividualProgramProcessState.CANDIDACY.equals(this.getProcessState()) && this.getCandidacyProcessState() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdProgramCandidacyProcessState>(this.getCandidacyProcessState()){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return ((PhdProgramCandidacyProcessState)this.getValue()).equals(process2.getCandidacyProcess().getActiveState());
                }
            });
        }
        if (PhdIndividualProgramProcessState.THESIS_DISCUSSION.equals(this.getProcessState()) && this.getThesisProcessState() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdThesisProcessStateType>(this.getThesisProcessState()){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return process2.getThesisProcess() != null && ((PhdThesisProcessStateType)this.getValue()).equals(process2.getThesisProcess().getActiveState());
                }
            });
        }
        if (OnlineApplicationFilter.EXCLUDE_ONLINE.equals((Object)this.getOnlineApplicationFilter())) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, String>(null){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return !process2.getCandidacyProcess().isPublicCandidacy();
                }
            });
        }
        if (OnlineApplicationFilter.ONLY_ONLINE.equals((Object)this.getOnlineApplicationFilter())) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, String>(null){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return process2.getCandidacyProcess().isPublicCandidacy();
                }
            });
            if (this.getPhdCandidacyPeriod() != null) {
                result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdCandidacyPeriod>(this.getPhdCandidacyPeriod()){

                    @Override
                    public boolean test(PhdIndividualProgramProcess process2) {
                        return process2.getCandidacyProcess().getPublicPhdCandidacyPeriod() == this.getValue();
                    }
                });
            }
        }
        if (this.getPhdCollaborationType() != null) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, PhdIndividualProgramCollaborationType>(this.getPhdCollaborationType()){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return process2.getCollaborationType() == this.getValue();
                }
            });
        }
        return result;
    }

    private AndPredicate<PhdIndividualProgramProcess> getManagedPhdProgramsAndProcessesPredicate() {
        AndPredicate<PhdIndividualProgramProcess> result = new AndPredicate<PhdIndividualProgramProcess>();
        if (this.getFilterPhdPrograms() != null && this.getFilterPhdPrograms().booleanValue()) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, List<PhdProgram>>(this.getPhdPrograms()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    if (toEval.getPhdProgram() != null) {
                        return ((List)this.getValue()).contains((Object)toEval.getPhdProgram());
                    }
                    if (toEval.getPhdProgramFocusArea() != null) {
                        return !CollectionUtils.intersection((Collection)((Collection)this.getValue()), (Collection)toEval.getPhdProgramFocusArea().getPhdProgramsSet()).isEmpty();
                    }
                    return false;
                }
            });
        }
        if (this.getFilterPhdProcesses() != null && this.getFilterPhdProcesses().booleanValue()) {
            result.add(new InlinePredicate<PhdIndividualProgramProcess, List<PhdIndividualProgramProcess>>(this.getProcesses()){

                @Override
                public boolean test(PhdIndividualProgramProcess toEval) {
                    return ((List)this.getValue()).contains((Object)toEval);
                }
            });
        }
        return result;
    }

    public Integer getPhdStudentNumber() {
        return this.phdStudentNumber;
    }

    public void setPhdStudentNumber(Integer phdStudentNumber) {
        this.phdStudentNumber = phdStudentNumber;
    }

    public PhdProgram getPhdProgram() {
        return this.phdProgram;
    }

    public void setPhdProgram(PhdProgram phdProgram) {
        this.phdProgram = phdProgram;
    }

    public OnlineApplicationFilter getOnlineApplicationFilter() {
        return this.onlineApplicationFilter;
    }

    public void setOnlineApplicationFilter(OnlineApplicationFilter onlineApplicationFilter) {
        this.onlineApplicationFilter = onlineApplicationFilter;
    }

    public PhdIndividualProgramCollaborationType getPhdCollaborationType() {
        return this.phdCollaborationType;
    }

    public void setPhdCollaborationType(PhdIndividualProgramCollaborationType phdCollaborationType) {
        this.phdCollaborationType = phdCollaborationType;
    }

    public static enum OnlineApplicationFilter {
        ONLY_ONLINE,
        EXCLUDE_ONLINE;

    }

    public static enum SearchCriterion {
        PROCESS_NUMBER,
        STUDENT_NUMBER,
        NAME,
        PHD_STUDENT_NUMBER;

    }
}

