/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.AdmittedCandidacySituation;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.NotAdmittedCandidacySituation;
import org.fenixedu.academic.domain.candidacy.PreCandidacySituation;
import org.fenixedu.academic.domain.candidacy.StandByCandidacySituation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdCandidacyProcessState_Base;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.candidacy.PHDProgramCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.joda.time.DateTime;

public class PhdCandidacyProcessState
extends PhdCandidacyProcessState_Base {
    private PhdCandidacyProcessState() {
    }

    protected PhdCandidacyProcessState(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type, Person person, String remarks, DateTime stateDate) {
        this();
        this.init(process2, type, person, remarks, stateDate);
        this.updateSituationOnPHDCandidacy();
    }

    public void updateSituationOnPHDCandidacy() {
        PhdProgramCandidacyProcess process2 = this.getProcess();
        if (this.getStateDate() == null) {
            throw new DomainException("state.date.null", new String[0]);
        }
        PHDProgramCandidacy candidacy = process2.getCandidacy();
        Object situation = null;
        switch (this.getType()) {
            case PRE_CANDIDATE: {
                situation = new PreCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
            case STAND_BY_WITH_MISSING_INFORMATION: 
            case STAND_BY_WITH_COMPLETE_INFORMATION: {
                situation = new StandByCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
            case CONCLUDED: {
                situation = new AdmittedCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
            case REJECTED: {
                situation = new NotAdmittedCandidacySituation((Candidacy)((Object)candidacy));
                break;
            }
        }
        if (situation != null) {
            situation.setSituationDate(this.getStateDate());
        }
    }

    protected void init(Person person, String remarks, DateTime stateDate) {
        throw new RuntimeException("invoke other init");
    }

    protected void init(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type, Person person, String remarks, DateTime stateDate) {
        this.check(process2, type);
        this.setProcess(process2);
        super.init(person, remarks, stateDate, (PhdProcessStateType)type);
        this.setType(type);
    }

    private void check(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdCandidacyProcessState.invalid.process", args);
        }
        String[] args1 = new String[]{};
        if (type == null) {
            throw new DomainException("error.PhdCandidacyProcessState.invalid.type", args1);
        }
        this.checkType(process2, type);
    }

    private void checkType(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type) {
        PhdProgramCandidacyProcessState currentType = process2.getActiveState();
        if (currentType != null && currentType.equals(type)) {
            throw new DomainException("error.PhdCandidacyProcessState.equals.previous.state", type.getLocalizedName());
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    public static PhdCandidacyProcessState create(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type) {
        AccessControl.check(RolePredicates.MANAGER_PREDICATE);
        PhdCandidacyProcessState result = new PhdCandidacyProcessState();
        result.check(process2, type);
        result.setProcess(process2);
        result.setType(type);
        return result;
    }

    public boolean isLast() {
        return this.getProcess().getMostRecentState() == this;
    }

    public static PhdCandidacyProcessState createStateWithInferredStateDate(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type, Person person, String remarks) {
        DateTime stateDate = null;
        PhdCandidacyProcessState mostRecentState = process2.getMostRecentState();
        switch (type) {
            case PRE_CANDIDATE: 
            case STAND_BY_WITH_MISSING_INFORMATION: 
            case STAND_BY_WITH_COMPLETE_INFORMATION: 
            case PENDING_FOR_COORDINATOR_OPINION: 
            case WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION: {
                if (mostRecentState != null) {
                    stateDate = mostRecentState.getStateDate().plusMinutes(1);
                    break;
                }
                if (process2.getCandidacyDate() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdCandidacyProcessState.candidacyDate.required", new String[0]);
                }
                stateDate = process2.getCandidacyDate().toDateTimeAtStartOfDay();
                break;
            }
            case RATIFIED_BY_SCIENTIFIC_COUNCIL: {
                if (process2.getWhenRatified() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdCandidacyProcessState.whenRatified.required", new String[0]);
                }
                stateDate = process2.getWhenRatified().toDateTimeAtStartOfDay();
                break;
            }
            case CONCLUDED: {
                if (process2.getWhenStartedStudies() == null) {
                    throw new PhdDomainOperationException("error.phd.PhdCandidacyProcessState.whenStartedStudies.required", new String[0]);
                }
                stateDate = process2.getWhenStartedStudies().toDateTimeAtStartOfDay();
                break;
            }
            case REJECTED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            default: {
                throw new DomainException("I cant handle this", new String[0]);
            }
        }
        return PhdCandidacyProcessState.createStateWithGivenStateDate(process2, type, person, remarks, stateDate);
    }

    public static PhdCandidacyProcessState createStateWithGivenStateDate(PhdProgramCandidacyProcess process2, PhdProgramCandidacyProcessState type, Person person, String remarks, DateTime stateDate) {
        List<PhdProgramCandidacyProcessState> nextPossibleStates = PhdProgramCandidacyProcessState.getPossibleNextStates(process2);
        if (!nextPossibleStates.contains(type)) {
            String description = PhdCandidacyProcessState.buildExpectedStatesDescription(nextPossibleStates);
            throw new PhdDomainOperationException("error.phd.candidacy.PhdProgramCandidacyProcess.invalid.state", type.getLocalizedName(), description);
        }
        return new PhdCandidacyProcessState(process2, type, person, remarks, stateDate);
    }
}

