/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.period;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod$callable$editEmailTemplates;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MobilityApplicationPeriod
extends MobilityApplicationPeriod_Base {
    public static final Advice advice$editEmailTemplates = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MobilityApplicationPeriod() {
    }

    public MobilityApplicationPeriod(MobilityApplicationProcess applicationProcess, ExecutionYear executionInterval, DateTime start, DateTime end) {
        this();
        this.init(applicationProcess, (ExecutionInterval)((Object)executionInterval), start, end);
    }

    public void delete() {
        if (this.getMobilityQuotasSet().size() > 0) {
            throw new DomainException("error.mobility.application.period.cant.be.deleted.it.has.defined.quotas", new String[0]);
        }
        if (this.getCandidacyProcessesSet().size() > 0) {
            throw new DomainException("error.mobility.application.period.cant.be.deleted.it.has.attached.process", new String[0]);
        }
        if (this.getEmailTemplatesSet().size() > 0) {
            throw new DomainException("error.mobility.application.period.cant.be.deleted.it.has.attached.email.templates", new String[0]);
        }
        if (this.getErasmusVacancySet().size() > 0) {
            throw new DomainException("error.mobility.application.period.cant.be.deleted.it.has.attached.erasmus.vacancies", new String[0]);
        }
        if (this.getExecutionInterval() != null) {
            throw new DomainException("error.mobility.application.period.cant.be.deleted.it.has.attached.execution.year", new String[0]);
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    private void init(MobilityApplicationProcess applicationProcess, ExecutionInterval executionInterval, DateTime start, DateTime end) {
        this.checkParameters(applicationProcess);
        this.checkIfCanCreate(executionInterval, start, end);
        super.init(executionInterval, start, end);
        this.addCandidacyProcesses((CandidacyProcess)((Object)applicationProcess));
    }

    private void checkParameters(MobilityApplicationProcess applicationProcess) {
        if (applicationProcess == null) {
            throw new DomainException("error.ErasmusCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    private void checkIfCanCreate(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        for (MobilityApplicationPeriod mobilityApplicationPeriod : executionInterval.getMobilityApplicationPeriods()) {
            if (!mobilityApplicationPeriod.intercept(start, end)) continue;
            throw new DomainException("error.ErasmusCandidacyPeriod.interception", executionInterval.getName(), start.toString("dd/MM/yyyy HH:mm"), end.toString("dd/MM/yyyy HH:mm"));
        }
    }

    public MobilityApplicationProcess getMobilityApplicationProcess() {
        return (MobilityApplicationProcess)((Object)(!this.getCandidacyProcessesSet().isEmpty() ? (CandidacyProcess)((Object)this.getCandidacyProcessesSet().iterator().next()) : null));
    }

    public ExecutionYear getExecutionInterval() {
        return (ExecutionYear)((Object)super.getExecutionInterval());
    }

    public String getPresentationName() {
        return this.getStart().toString("dd/MM/yyyy") + " - " + this.getEnd().toString("dd/MM/yyyy");
    }

    public void edit(DateTime start, DateTime end) {
        this.checkDates(start, end);
        this.checkIfCanEdit(start, end);
        super.setStart(start);
        super.setEnd(end);
    }

    private void checkIfCanEdit(DateTime start, DateTime end) {
        for (MobilityApplicationPeriod mobilityApplicationPeriod : this.getExecutionInterval().getMobilityApplicationPeriods()) {
            if (mobilityApplicationPeriod == this || !mobilityApplicationPeriod.intercept(start, end)) continue;
            throw new DomainException("error.ErasmusCandidacyPeriod.interception", this.getExecutionInterval().getName(), start.toString("dd/MM/yyyy HH:mm"), end.toString("dd/MM/yyyy HH:mm"));
        }
    }

    public List<Country> getAssociatedCountries() {
        HashSet<Country> countries = new HashSet<Country>();
        for (MobilityQuota mobilityQuota : this.getMobilityQuotasSet()) {
            countries.add(mobilityQuota.getMobilityAgreement().getUniversityUnit().getCountry());
        }
        return new ArrayList<Country>(countries);
    }

    public List<MobilityQuota> getOpeningsForCountry(Country country) {
        ArrayList<MobilityQuota> openingsList = new ArrayList<MobilityQuota>();
        for (MobilityQuota quota : this.getMobilityQuotasSet()) {
            if (quota.getMobilityAgreement().getUniversityUnit().getCountry() != country) continue;
            openingsList.add(quota);
        }
        return openingsList;
    }

    public List<UniversityUnit> getUniversityUnitsAssociatedToCountry(Country country) {
        HashSet<UniversityUnit> universityUnits = new HashSet<UniversityUnit>();
        for (MobilityQuota quota : this.getOpeningsForCountry(country)) {
            universityUnits.add(quota.getMobilityAgreement().getUniversityUnit());
        }
        return new ArrayList<UniversityUnit>(universityUnits);
    }

    public MobilityQuota getAssociatedOpening(Degree degree, MobilityAgreement agreement) {
        if (degree == null || agreement == null) {
            return null;
        }
        for (MobilityQuota quota : agreement.getMobilityQuotasSet()) {
            if (quota.getDegree() != degree || quota.getApplicationPeriod() != this) continue;
            return quota;
        }
        return null;
    }

    public List<Degree> getPossibleDegreesAssociatedToUniversity(UniversityUnit university) {
        HashSet<Degree> degreeSet = new HashSet<Degree>();
        for (MobilityQuota quota : this.getMobilityQuotasSet()) {
            if (quota.getMobilityAgreement().getUniversityUnit() != university) continue;
            degreeSet.add(quota.getDegree());
        }
        return new ArrayList<Degree>(degreeSet);
    }

    public List<Degree> getPossibleDegreesAssociatedToAgreement(MobilityAgreement agreement) {
        HashSet<Degree> degreeSet = new HashSet<Degree>();
        for (MobilityQuota quota : this.getMobilityQuotasSet()) {
            if (quota.getMobilityAgreement() != agreement) continue;
            degreeSet.add(quota.getDegree());
        }
        return new ArrayList<Degree>(degreeSet);
    }

    public boolean existsFor(MobilityAgreement agreement, Degree degree) {
        return this.getAssociatedOpening(degree, agreement) != null;
    }

    public Set<MobilityProgram> getMobilityPrograms() {
        HashSet<MobilityProgram> programs = new HashSet<MobilityProgram>();
        Set mobilityQuotas = this.getMobilityQuotasSet();
        for (MobilityQuota mobilityQuota : mobilityQuotas) {
            programs.add(mobilityQuota.getMobilityAgreement().getMobilityProgram());
        }
        return programs;
    }

    public void editEmailTemplates(MobilityEmailTemplateBean mobilityEmailTemplateBean) {
        Object object = advice$editEmailTemplates.perform((Callable)new MobilityApplicationPeriod$callable$editEmailTemplates(this, mobilityEmailTemplateBean));
    }

    static /* synthetic */ void advised$editEmailTemplates(MobilityApplicationPeriod this_, MobilityEmailTemplateBean bean) {
        MobilityEmailTemplateType type = bean.getType();
        String subject = bean.getSubject();
        String body = bean.getBody();
        MobilityProgram program = bean.getMobilityProgram();
        if (!this_.hasEmailTemplateFor(program, type)) {
            MobilityEmailTemplate.create(this_, program, type, subject, body);
        } else {
            this_.getEmailTemplateFor(program, type).update(subject, body);
        }
    }

    public List<MobilityQuota> getMobilityQuotasByProgram(MobilityProgram program) {
        ArrayList<MobilityQuota> result = new ArrayList<MobilityQuota>();
        Set mobilityQuotas = this.getMobilityQuotasSet();
        for (MobilityQuota mobilityQuota : mobilityQuotas) {
            if (!mobilityQuota.isFor(program)) continue;
            result.add(mobilityQuota);
        }
        return result;
    }

    public MobilityEmailTemplate getEmailTemplateFor(MobilityProgram program, MobilityEmailTemplateType type) {
        for (MobilityEmailTemplate template : this.getEmailTemplatesSet()) {
            if (!template.isFor(program, type)) continue;
            return template;
        }
        return null;
    }

    public boolean hasEmailTemplateFor(MobilityProgram program, MobilityEmailTemplateType type) {
        return this.getEmailTemplateFor(program, type) != null;
    }

    @Deprecated
    public MobilityEmailTemplate getEmailTemplateFor(MobilityEmailTemplateType type) {
        MobilityProgram mobilityProgram = this.getMobilityPrograms().iterator().next();
        return this.getEmailTemplateFor(mobilityProgram, type);
    }

    @Deprecated
    public boolean hasEmailTemplateFor(MobilityEmailTemplateType type) {
        MobilityProgram mobilityProgram = this.getMobilityPrograms().iterator().next();
        return this.hasEmailTemplateFor(mobilityProgram, type);
    }
}

