/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.mobility.outbound;

import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.Interval;

public enum CandidacyGroupContestState {
    GATHER_CANDIDATES{

        @Override
        public CandidacyGroupContestStateStage getStage(OutboundMobilityCandidacyContestGroup group, OutboundMobilityCandidacyPeriod period) {
            Interval i = period.getInterval();
            return i == null || i.isAfterNow() ? CandidacyGroupContestStateStage.NOT_STARTED : (i.isBeforeNow() ? CandidacyGroupContestStateStage.COMPLETED : CandidacyGroupContestStateStage.UNDER_WAY);
        }
    }
    ,
    GRADE_CANDIDATES{

        @Override
        public CandidacyGroupContestStateStage getStage(OutboundMobilityCandidacyContestGroup group, OutboundMobilityCandidacyPeriod period) {
            Interval i = period.getInterval();
            return i == null || !i.isBeforeNow() ? CandidacyGroupContestStateStage.NOT_STARTED : (group.areAllStudentsGraded(period) ? CandidacyGroupContestStateStage.COMPLETED : CandidacyGroupContestStateStage.UNDER_WAY);
        }
    }
    ,
    SELECT_CANDIDACIES{

        @Override
        public CandidacyGroupContestStateStage getStage(OutboundMobilityCandidacyContestGroup group, OutboundMobilityCandidacyPeriod period) {
            Interval i = period.getInterval();
            return i == null || !i.isBeforeNow() || !group.areAllStudentsGraded(period) ? CandidacyGroupContestStateStage.NOT_STARTED : (group.isCandidacySelectionConcluded(period) ? CandidacyGroupContestStateStage.COMPLETED : CandidacyGroupContestStateStage.UNDER_WAY);
        }
    }
    ,
    NOTIFY_CANDIDATES{

        @Override
        public CandidacyGroupContestStateStage getStage(OutboundMobilityCandidacyContestGroup group, OutboundMobilityCandidacyPeriod period) {
            Interval i = period.getInterval();
            return i == null || !i.isBeforeNow() || !group.isCandidacySelectionConcluded(period) ? CandidacyGroupContestStateStage.NOT_STARTED : (group.areCandidatesNotofiedOfSelectionResults(period) ? CandidacyGroupContestStateStage.COMPLETED : CandidacyGroupContestStateStage.UNDER_WAY);
        }
    }
    ,
    CONCLUDED_CANDIDATE_CONFIRMATION{

        @Override
        public CandidacyGroupContestStateStage getStage(OutboundMobilityCandidacyContestGroup group, OutboundMobilityCandidacyPeriod period) {
            Interval i = period.getInterval();
            return i == null || !i.isBeforeNow() || !group.areCandidatesNotofiedOfSelectionResults(period) ? CandidacyGroupContestStateStage.NOT_STARTED : (group.haveAllCandidatesConfirmed(period) ? CandidacyGroupContestStateStage.COMPLETED : CandidacyGroupContestStateStage.UNDER_WAY);
        }
    };


    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)("label." + this.name()), (String[])new String[0]);
    }

    public abstract CandidacyGroupContestStateStage getStage(OutboundMobilityCandidacyContestGroup var1, OutboundMobilityCandidacyPeriod var2);

    public static enum CandidacyGroupContestStateStage {
        NOT_STARTED,
        UNDER_WAY,
        COMPLETED;


        public String getLocalizedName() {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)("label." + this.name()), (String[])new String[0]);
        }
    }
}

