/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;

public class ExternalCurricularCourseToEnrol
extends DegreeModuleToEnrol {
    private CurricularCourse curricularCourse;

    public ExternalCurricularCourseToEnrol(CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        super(curriculumGroup, null, executionSemester);
        this.curricularCourse = curricularCourse;
    }

    @Override
    public boolean canCollectRules() {
        return false;
    }

    @Override
    public double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        return this.getStudentCurricularPlan().getAccumulatedEctsCredits(executionSemester, this.getDegreeModule());
    }

    @Override
    public Context getContext() {
        throw new DomainException("error.ExternalCurricularCourseToEnrol.doesnot.have.context", new String[0]);
    }

    @Override
    public Set<ICurricularRule> getCurricularRulesFromCurriculumGroup(ExecutionSemester executionSemester) {
        return Collections.emptySet();
    }

    @Override
    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    public CurricularCourse getDegreeModule() {
        return this.curricularCourse;
    }

    @Override
    public Double getEctsCredits(ExecutionSemester executionSemester) {
        return this.getDegreeModule().getEctsCredits(executionSemester);
    }

    @Override
    public String getKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Object)((Object)this.getCurriculumGroup())).getClass().getName()).append(":").append(this.getCurriculumGroup().getExternalId()).append(",").append(((Object)((Object)this.getDegreeModule())).getClass().getName()).append(":").append(this.getName()).append(",").append(this.getExecutionPeriod().getClass().getName()).append(":").append(this.getExecutionPeriod().getExternalId());
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return this.getDegreeModule().getName(this.getExecutionPeriod());
    }

    @Override
    public String getYearFullLabel() {
        throw new DomainException("error.ExternalCurricularCourseToEnrol.doesnot.have.context", new String[0]);
    }

    @Override
    public boolean isAnnualCurricularCourse(ExecutionYear executionYear) {
        return this.getDegreeModule().isAnual(executionYear);
    }

    @Override
    public boolean isOptionalCurricularCourse() {
        return this.getDegreeModule().isOptionalCurricularCourse();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExternalCurricularCourseToEnrol) {
            ExternalCurricularCourseToEnrol degreeModuleToEnrol = (ExternalCurricularCourseToEnrol)obj;
            return this.getDegreeModule().equals((Object)degreeModuleToEnrol.getDegreeModule()) && this.getCurriculumGroup().equals((Object)degreeModuleToEnrol.getCurriculumGroup());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDegreeModule().hashCode() + this.getCurriculumGroup().hashCode();
    }
}

