/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation_Base;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoadBean;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.domain.Bennu;

public class CompetenceCourseInformation
extends CompetenceCourseInformation_Base {
    public static final Comparator<CompetenceCourseInformation> COMPARATORY_BY_EXECUTION_PERIOD = new Comparator<CompetenceCourseInformation>(){

        @Override
        public int compare(CompetenceCourseInformation o1, CompetenceCourseInformation o2) {
            return o1.getExecutionPeriod().compareTo(o2.getExecutionPeriod());
        }
    };

    public CompetenceCourseInformation() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CompetenceCourseInformation(CompetenceCourseInformation existingInformation) {
        this(existingInformation.getName(), existingInformation.getNameEn(), existingInformation.getBasic(), existingInformation.getRegime(), existingInformation.getCompetenceCourseLevel(), existingInformation.getExecutionPeriod(), existingInformation.getCompetenceCourseGroupUnit());
        this.setCompetenceCourse(existingInformation.getCompetenceCourse());
        for (CompetenceCourseLoad load : existingInformation.getCompetenceCourseLoadsSet()) {
            CompetenceCourseLoad newLoad = new CompetenceCourseLoad(load);
            this.addCompetenceCourseLoads(newLoad);
        }
        this.setAcronym(existingInformation.getAcronym());
        this.setBibliographicReferences(existingInformation.getBibliographicReferences());
        this.setEvaluationMethod(existingInformation.getEvaluationMethod());
        this.setEvaluationMethodEn(existingInformation.getEvaluationMethodEn());
        this.setObjectives(existingInformation.getObjectives());
        this.setObjectivesEn(existingInformation.getObjectivesEn());
        this.setProgram(existingInformation.getProgram());
        this.setProgramEn(existingInformation.getProgramEn());
    }

    public CompetenceCourseInformation(String name, String nameEn, Boolean basic, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel, ExecutionSemester period, CompetenceCourseGroupUnit unit) {
        this();
        this.checkParameters(name, nameEn, basic, regimeType, competenceCourseLevel, unit);
        this.setName(StringFormatter.prettyPrint(name));
        this.setNameEn(StringFormatter.prettyPrint(nameEn));
        this.setBasic(basic);
        this.setRegime(regimeType);
        this.setCompetenceCourseLevel(competenceCourseLevel);
        this.setBibliographicReferences(new BibliographicReferences());
        this.setExecutionPeriod(period);
        this.setCompetenceCourseGroupUnit(unit);
    }

    public ScientificAreaUnit getScientificAreaUnit() {
        return this.getCompetenceCourseGroupUnit().getScientificAreaUnit();
    }

    public DepartmentUnit getDepartmentUnit() {
        return this.getCompetenceCourseGroupUnit().getDepartmentUnit();
    }

    private void checkParameters(String name, String nameEn, Boolean basic, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel) {
        if (name == null || nameEn == null || basic == null || regimeType == null) {
            throw new DomainException("competence.course.information.invalid.parameters", new String[0]);
        }
        if (competenceCourseLevel == null) {
            competenceCourseLevel = CompetenceCourseLevel.UNKNOWN;
        }
    }

    private void checkParameters(String name, String nameEn, Boolean basic, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseGroupUnit unit) {
        this.checkParameters(name, nameEn, basic, regimeType, competenceCourseLevel);
        if (unit == null || !unit.isCompetenceCourseGroupUnit()) {
            throw new DomainException("competence.course.information.invalid.group.unit", new String[0]);
        }
    }

    public void edit(String name, String nameEn, Boolean basic, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseGroupUnit unit) {
        this.checkParameters(name, nameEn, basic, this.getRegime(), competenceCourseLevel, unit);
        this.setName(StringFormatter.prettyPrint(name));
        this.setNameEn(StringFormatter.prettyPrint(nameEn));
        this.setBasic(basic);
        this.setCompetenceCourseLevel(competenceCourseLevel);
        this.setCompetenceCourseGroupUnit(unit);
    }

    public void edit(String name, String nameEn, Boolean basic, CompetenceCourseLevel competenceCourseLevel) {
        this.checkParameters(name, nameEn, basic, this.getRegime(), competenceCourseLevel);
        this.setName(StringFormatter.prettyPrint(name));
        this.setNameEn(StringFormatter.prettyPrint(nameEn));
        this.setBasic(basic);
        this.setCompetenceCourseLevel(competenceCourseLevel);
    }

    public void edit(String objectives, String program, String evaluationMethod, String objectivesEn, String programEn, String evaluationMethodEn) {
        this.setObjectives(objectives);
        this.setProgram(program);
        this.setEvaluationMethod(evaluationMethod);
        this.setObjectivesEn(objectivesEn);
        this.setProgramEn(programEn);
        this.setEvaluationMethodEn(evaluationMethodEn);
    }

    public void delete() {
        this.setExecutionPeriod(null);
        this.setCompetenceCourse(null);
        this.setCompetenceCourseGroupUnit(null);
        while (!this.getCompetenceCourseLoadsSet().isEmpty()) {
            ((CompetenceCourseLoad)this.getCompetenceCourseLoadsSet().iterator().next()).delete();
        }
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public BibliographicReferences.BibliographicReference getBibliographicReference(Integer oid) {
        return this.getBibliographicReferences().getBibliographicReference(oid);
    }

    public Double getTheoreticalHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getTheoreticalHours().doubleValue();
        }
        return result;
    }

    public Double getProblemsHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getProblemsHours().doubleValue();
        }
        return result;
    }

    public Double getLaboratorialHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getLaboratorialHours().doubleValue();
        }
        return result;
    }

    public Double getSeminaryHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getSeminaryHours().doubleValue();
        }
        return result;
    }

    public Double getFieldWorkHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getFieldWorkHours().doubleValue();
        }
        return result;
    }

    public Double getTrainingPeriodHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getTrainingPeriodHours().doubleValue();
        }
        return result;
    }

    public Double getTutorialOrientationHours(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getTutorialOrientationHours().doubleValue();
        }
        return result;
    }

    public Double getAutonomousWorkHours(Integer order) {
        BigDecimal result = new BigDecimal(0.0);
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result = result.add(new BigDecimal(competenceCourseLoad.getAutonomousWorkHours()));
        }
        result = result.setScale(1, RoundingMode.HALF_EVEN);
        return result.doubleValue();
    }

    public Double getContactLoad(Integer order) {
        BigDecimal result = new BigDecimal(0.0);
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result = result.add(new BigDecimal(competenceCourseLoad.getContactLoad()));
        }
        result = result.setScale(1, RoundingMode.HALF_EVEN);
        return result.doubleValue();
    }

    public Double getTotalLoad(Integer order) {
        BigDecimal result = new BigDecimal(0.0);
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result = result.add(new BigDecimal(competenceCourseLoad.getTotalLoad()));
        }
        result = result.setScale(1, RoundingMode.HALF_EVEN);
        return result.doubleValue();
    }

    public double getEctsCredits(Integer order) {
        double result = 0.0;
        for (CompetenceCourseLoadBean competenceCourseLoad : this.getCompetenceCourseLoadBeans(order)) {
            result += competenceCourseLoad.getEctsCredits().doubleValue();
        }
        return result;
    }

    private List<CompetenceCourseLoadBean> getCompetenceCourseLoadBeans(Integer order) {
        if (this.isSemestrial()) {
            return Collections.singletonList(new CompetenceCourseLoadBean((CompetenceCourseLoad)this.getCompetenceCourseLoadsSet().iterator().next()));
        }
        if (this.isAnual()) {
            CompetenceCourseLoadBean courseLoadBean;
            ArrayList<CompetenceCourseLoadBean> result = new ArrayList<CompetenceCourseLoadBean>();
            for (CompetenceCourseLoad competenceCourseLoad : this.getCompetenceCourseLoadsSet()) {
                result.add(new CompetenceCourseLoadBean(competenceCourseLoad));
            }
            if (this.getCompetenceCourseLoadsSet().size() == 1) {
                CompetenceCourseLoad courseLoad = (CompetenceCourseLoad)this.getCompetenceCourseLoadsSet().iterator().next();
                courseLoadBean = new CompetenceCourseLoadBean(courseLoad);
                courseLoadBean.setLoadOrder(courseLoad.getLoadOrder() + 1);
                result.add(courseLoadBean);
            }
            Iterator loads = result.iterator();
            while (loads.hasNext()) {
                courseLoadBean = (CompetenceCourseLoadBean)loads.next();
                if (order == null || courseLoadBean.getLoadOrder().equals(order)) continue;
                loads.remove();
            }
            return result;
        }
        return Collections.emptyList();
    }

    public boolean isAnual() {
        return this.getRegime() == RegimeType.ANUAL;
    }

    public boolean isSemestrial() {
        return this.getRegime() == RegimeType.SEMESTRIAL;
    }

    public List<CompetenceCourseInformationChangeRequest> getCompetenceCourseInformationChangeRequest() {
        ArrayList<CompetenceCourseInformationChangeRequest> requests = new ArrayList<CompetenceCourseInformationChangeRequest>();
        for (CompetenceCourseInformationChangeRequest request : this.getCompetenceCourse().getCompetenceCourseInformationChangeRequestsSet()) {
            if (!request.getExecutionPeriod().equals(this.getExecutionPeriod())) continue;
            requests.add(request);
        }
        return requests;
    }

    public boolean isCompetenceCourseInformationChangeRequestDraftAvailable() {
        for (CompetenceCourseInformationChangeRequest request : this.getCompetenceCourseInformationChangeRequest()) {
            if (request.getApproved() != null) continue;
            return true;
        }
        return false;
    }

    public boolean isLoggedPersonAllowedToEdit() {
        Person person = AccessControl.getPerson();
        if (this.isCompetenceCourseInformationChangeRequestDraftAvailable()) {
            return false;
        }
        if (RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser())) {
            return true;
        }
        if (!RoleType.BOLONHA_MANAGER.isMember(person.getUser())) {
            return false;
        }
        return this.getDepartmentUnit().getDepartment().isUserMemberOfCompetenceCourseMembersGroup(person);
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }

    public ExecutionInterval getExecutionInterval() {
        return this.getExecutionPeriod();
    }

    public AcademicPeriod getAcademicPeriod() {
        AcademicPeriod result = null;
        RegimeType regime = this.getRegime();
        if (regime.equals((Object)RegimeType.SEMESTRIAL)) {
            result = AcademicPeriod.SEMESTER;
        } else if (regime.equals((Object)RegimeType.ANUAL)) {
            result = AcademicPeriod.YEAR;
        } else {
            throw new DomainException("error.CompetenceCourseInformation.unsupported.AcademicPeriod", new String[0]);
        }
        return result;
    }
}

