/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;

public abstract class VerifyRuleExecutor {
    public static final VerifyRuleExecutor NULL_VERIFY_EXECUTOR = new NullVerifyExecutor();

    public final RuleResult verify(ICurricularRule curricularRule, VerifyRuleLevel verifyRuleLevel, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup rootOrCycleCurriculumGroup) {
        if (!rootOrCycleCurriculumGroup.isCycleCourseGroup() && !rootOrCycleCurriculumGroup.isRoot()) {
            throw new DomainException("error.org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor.parent.course.group.should.be.root.or.cycle.course.group", new String[0]);
        }
        if (verifyRuleLevel == VerifyRuleLevel.ENROLMENT_WITH_RULES) {
            return this.verifyEnrolmentWithRules(curricularRule, enrolmentContext, degreeModuleToVerify, rootOrCycleCurriculumGroup);
        }
        if (verifyRuleLevel == VerifyRuleLevel.ENROLMENT_WITH_RULES_AND_TEMPORARY) {
            return this.verifyEnrolmentWithTemporaryEnrolment(curricularRule, enrolmentContext, degreeModuleToVerify, rootOrCycleCurriculumGroup);
        }
        if (verifyRuleLevel == VerifyRuleLevel.DEGREE_CONCLUSION_WITH_RULES) {
            return this.verifyDegreeConclusionWithRules(curricularRule, enrolmentContext, degreeModuleToVerify, rootOrCycleCurriculumGroup);
        }
        throw new DomainException("error.org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor.invalid.verify.level", new String[0]);
    }

    protected boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, CourseGroup parentCourseGroup) {
        CurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(parentCourseGroup);
        return curriculumGroup != null ? curriculumGroup.isApproved(curricularCourse) : false;
    }

    protected boolean isEnrolledIn(EnrolmentContext enrolmentContext, CourseGroup courseGroup) {
        return enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(courseGroup) != null;
    }

    protected boolean hasEnrolmentWithEnroledState(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return enrolmentContext.getStudentCurricularPlan().getRoot().hasEnrolmentWithEnroledState(curricularCourse, executionSemester);
    }

    protected RuleResult verifyDegreeConclusionWithRules(ICurricularRule curricularRule, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup rootOrCycleCourseGroup) {
        return RuleResult.createNA(degreeModuleToVerify);
    }

    protected abstract RuleResult verifyEnrolmentWithRules(ICurricularRule var1, EnrolmentContext var2, DegreeModule var3, CourseGroup var4);

    protected abstract RuleResult verifyEnrolmentWithTemporaryEnrolment(ICurricularRule var1, EnrolmentContext var2, DegreeModule var3, CourseGroup var4);

    private static class NullVerifyExecutor
    extends VerifyRuleExecutor {
        private NullVerifyExecutor() {
        }

        @Override
        protected RuleResult verifyEnrolmentWithRules(ICurricularRule curricularRule, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup parentCourseGroup) {
            return RuleResult.createNA(degreeModuleToVerify);
        }

        @Override
        protected RuleResult verifyEnrolmentWithTemporaryEnrolment(ICurricularRule curricularRule, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup parentCourseGroup) {
            return RuleResult.createNA(degreeModuleToVerify);
        }
    }
}

