/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CompositeRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleNotPersistent;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.dto.GenericPair;

public class CreditsLimitInExternalCycle
extends CurricularRuleNotPersistent {
    private static final double MIN_CREDITS_IN_PREVIOUS_CYCLE = 120.0;
    private ExternalCurriculumGroup externalCurriculumGroup;
    private CycleCurriculumGroup previousCycleCurriculumGroup;

    public CreditsLimitInExternalCycle(CycleCurriculumGroup previousCycleCurriculumGroup, ExternalCurriculumGroup toApply) {
        if (toApply == null || previousCycleCurriculumGroup == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        this.previousCycleCurriculumGroup = previousCycleCurriculumGroup;
        this.externalCurriculumGroup = toApply;
    }

    @Override
    public List<GenericPair<Object, Boolean>> getLabel() {
        return Collections.singletonList(new GenericPair<String, Boolean>("label.creditsLimitInExternalCycle", true));
    }

    @Override
    public DegreeModule getDegreeModuleToApplyRule() {
        return this.externalCurriculumGroup.getDegreeModule();
    }

    @Override
    public CourseGroup getContextCourseGroup() {
        return null;
    }

    @Override
    public CompositeRule getParentCompositeRule() {
        return null;
    }

    public boolean creditsExceedMaximumInExternalCycle(Double numberOfCreditsInExternalCycle, Double numberOfCreditsInPreviousCycle) {
        return numberOfCreditsInExternalCycle.compareTo(this.getMaxCreditsInExternalCycle(numberOfCreditsInPreviousCycle)) > 0;
    }

    public boolean creditsInPreviousCycleSufficient(Double previousCycleCredits) {
        return previousCycleCredits.compareTo(120.0) > 0;
    }

    @Override
    public CurricularRuleType getCurricularRuleType() {
        return CurricularRuleType.CREDITS_LIMIT_IN_EXTERNAL_CYCLE;
    }

    @Override
    public ExecutionSemester getBegin() {
        return ExecutionSemester.readActualExecutionSemester();
    }

    @Override
    public ExecutionSemester getEnd() {
        return null;
    }

    public ExternalCurriculumGroup getExternalCurriculumGroup() {
        return this.externalCurriculumGroup;
    }

    public CycleCurriculumGroup getPreviousCycleCurriculumGroup() {
        return this.previousCycleCurriculumGroup;
    }

    public Double getMinCreditsInPreviousCycle() {
        return 120.0;
    }

    @Override
    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    public Double getMaxCreditsInExternalCycle(Double numberOfCreditsInPreviousCycle) {
        BigDecimal previous = new BigDecimal(numberOfCreditsInPreviousCycle);
        return previous.multiply(new BigDecimal("1.4")).subtract(new BigDecimal("168")).doubleValue();
    }
}

