/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram_Base;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;

public class MobilityProgram
extends MobilityProgram_Base
implements Comparable<MobilityProgram> {
    public static final Comparator<MobilityProgram> COMPARATOR_BY_REGISTRATION_AGREEMENT = new Comparator<MobilityProgram>(){

        @Override
        public int compare(MobilityProgram o1, MobilityProgram o2) {
            return o1.getRegistrationProtocol().compareTo(o2.getRegistrationProtocol());
        }
    };

    private MobilityProgram() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public MobilityProgram(RegistrationProtocol protocol) {
        this();
        this.setRegistrationProtocol(protocol);
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.getMobilityAgreementsSet().clear();
        this.setRegistrationProtocol(null);
        this.deleteDomainObject();
    }

    public static List<MobilityProgram> getAllMobilityPrograms() {
        return new ArrayList<MobilityProgram>(Bennu.getInstance().getProgramsSet());
    }

    public LocalizedString getName() {
        return this.getRegistrationProtocol().getDescription();
    }

    public MobilityAgreement getMobilityAgreementByUniversityUnit(UniversityUnit unit) {
        Set mobilityAgreements = this.getMobilityAgreementsSet();
        for (MobilityAgreement mobilityAgreement : mobilityAgreements) {
            if (mobilityAgreement.getUniversityUnit() != unit) continue;
            return mobilityAgreement;
        }
        return null;
    }

    public static MobilityProgram getByRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        Set programs = Bennu.getInstance().getProgramsSet();
        return programs.stream().filter(mp -> mp.getRegistrationProtocol() == registrationProtocol).findAny().get();
    }

    @Override
    public int compareTo(MobilityProgram o) {
        int rac = this.getRegistrationProtocol().compareTo(o.getRegistrationProtocol());
        return rac == 0 ? this.getExternalId().compareTo(o.getExternalId()) : rac;
    }

    public void setRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        super.setRegistrationProtocol(registrationProtocol);
    }
}

