/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.graduatedPerson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessSelectDegreesBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonIndividualProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonProcess_Base;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyProcessCandidacyPeriod;
import org.fenixedu.academic.domain.period.DegreeCandidacyForGraduatedPersonCandidacyPeriod;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class DegreeCandidacyForGraduatedPersonProcess
extends DegreeCandidacyForGraduatedPersonProcess_Base {
    private static List<Activity> activities;
    private static final Predicate<DegreeType> ALLOWED_DEGREE_TYPES;

    private DegreeCandidacyForGraduatedPersonProcess() {
    }

    private DegreeCandidacyForGraduatedPersonProcess(ExecutionYear executionYear, DateTime start, DateTime end) {
        this();
        this.checkParameters((ExecutionInterval)((Object)executionYear), start, end);
        this.setState(CandidacyProcessState.STAND_BY);
        new DegreeCandidacyForGraduatedPersonCandidacyPeriod(this, executionYear, start, end);
    }

    private void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        if (executionInterval == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPersonProcess.invalid.executionInterval", new String[0]);
        }
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPersonProcess.invalid.interval", new String[0]);
        }
    }

    private void edit(DateTime start, DateTime end) {
        this.checkParameters(this.getCandidacyPeriod().getExecutionInterval(), start, end);
        this.getCandidacyPeriod().edit(start, end);
    }

    public boolean canExecuteActivity(User userView) {
        return DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView) || RoleType.SCIENTIFIC_COUNCIL.isMember(userView.getPerson().getUser());
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public Map<Degree, SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess>> getValidDegreeCandidaciesForGraduatedPersonsByDegree() {
        TreeMap<Degree, SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess>> result = new TreeMap<Degree, SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess>>(Degree.COMPARATOR_BY_NAME_AND_ID);
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            DegreeCandidacyForGraduatedPersonIndividualProcess process2 = (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)child);
            if (!process2.isCandidacyValid() || !process2.canExecuteActivity(Authenticate.getUser())) continue;
            this.addCandidacy(result, process2);
        }
        return result;
    }

    private void addCandidacy(Map<Degree, SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess>> result, DegreeCandidacyForGraduatedPersonIndividualProcess process2) {
        SortedSet<DegreeCandidacyForGraduatedPersonIndividualProcess> values = result.get(process2.getCandidacySelectedDegree());
        if (values == null) {
            values = new TreeSet<DegreeCandidacyForGraduatedPersonIndividualProcess>(DegreeCandidacyForGraduatedPersonIndividualProcess.COMPARATOR_BY_CANDIDACY_PERSON);
            result.put(process2.getCandidacySelectedDegree(), values);
        }
        values.add(process2);
    }

    public List<DegreeCandidacyForGraduatedPersonIndividualProcess> getAcceptedDegreeCandidacyForGraduatedPersonIndividualCandidacies() {
        ArrayList<DegreeCandidacyForGraduatedPersonIndividualProcess> result = new ArrayList<DegreeCandidacyForGraduatedPersonIndividualProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!child.isCandidacyValid() || !child.isCandidacyAccepted()) continue;
            result.add((DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)child));
        }
        return result;
    }

    public List<DegreeCandidacyForGraduatedPersonIndividualProcess> getValidDegreeCandidaciesForGraduatedPersons(Degree degree) {
        if (degree == null) {
            return Collections.emptyList();
        }
        ArrayList<DegreeCandidacyForGraduatedPersonIndividualProcess> result = new ArrayList<DegreeCandidacyForGraduatedPersonIndividualProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            DegreeCandidacyForGraduatedPersonIndividualProcess process2 = (DegreeCandidacyForGraduatedPersonIndividualProcess)((Object)child);
            if (!process2.isCandidacyValid() || !process2.hasCandidacyForSelectedDegree(degree)) continue;
            result.add(process2);
        }
        return result;
    }

    private static boolean isAllowedToManageProcess(User userView) {
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet())) {
            if (!ALLOWED_DEGREE_TYPES.test(program.getDegreeType())) continue;
            return true;
        }
        return false;
    }

    public List<Degree> getAvailableDegrees() {
        Set degrees = this.getDegreeSet();
        return degrees.isEmpty() ? Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree)) : new ArrayList<Degree>(degrees);
    }

    static {
        DegreeCandidacyForGraduatedPersonProcess.getRelationCandidacyPeriodCandidacyProcess().addListener((RelationListener)new RelationAdapter<CandidacyProcess, CandidacyProcessCandidacyPeriod>(){

            public void beforeAdd(CandidacyProcess candidacyProcess, CandidacyProcessCandidacyPeriod candidacyPeriod) {
                super.beforeAdd((DomainObject)candidacyProcess, (DomainObject)candidacyPeriod);
                if (candidacyProcess != null && candidacyPeriod != null && candidacyPeriod instanceof DegreeCandidacyForGraduatedPersonCandidacyPeriod && !candidacyPeriod.getCandidacyProcessesSet().isEmpty()) {
                    throw new DomainException("error.DegreeCandidacyForGraduatedPersonProcess.candidacy.period.already.has.process", new String[0]);
                }
            }
        });
        activities = new ArrayList<Activity>();
        activities.add(new EditCandidacyPeriod());
        activities.add(new SendToCoordinator());
        activities.add(new SendToScientificCouncil());
        activities.add(new PrintCandidacies());
        activities.add(new ExportCandidacies());
        activities.add(new SelectAvailableDegrees());
        ALLOWED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree);
    }

    private static class SelectAvailableDegrees
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        private SelectAvailableDegrees() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            CandidacyProcessSelectDegreesBean bean = (CandidacyProcessSelectDegreesBean)object;
            List<Degree> degrees = bean.getDegrees();
            process2.getDegreeSet().addAll(degrees);
            process2.getDegreeSet().retainAll(degrees);
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ExportCandidacies
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        private ExportCandidacies() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class PrintCandidacies
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        private PrintCandidacies() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class SendToScientificCouncil
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        private SendToScientificCouncil() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() && !process2.isSentToCoordinator()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_SCIENTIFIC_COUNCIL);
            return process2;
        }
    }

    private static class SendToCoordinator
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        private SendToCoordinator() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_COORDINATOR);
            return process2;
        }
    }

    private static class EditCandidacyPeriod
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        private EditCandidacyPeriod() {
        }

        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            process2.edit(bean.getStart(), bean.getEnd());
            return process2;
        }
    }

    @StartActivity
    public static class CreateCandidacyPeriod
    extends Activity<DegreeCandidacyForGraduatedPersonProcess> {
        @Override
        public void checkPreConditions(DegreeCandidacyForGraduatedPersonProcess process2, User userView) {
            if (!DegreeCandidacyForGraduatedPersonProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected DegreeCandidacyForGraduatedPersonProcess executeActivity(DegreeCandidacyForGraduatedPersonProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            return new DegreeCandidacyForGraduatedPersonProcess((ExecutionYear)((Object)bean.getExecutionInterval()), bean.getStart(), bean.getEnd());
        }
    }
}

