/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.bennu.core.domain.Bennu;

public class SendReceptionEmailBean
implements Serializable {
    private boolean includeOnlyProcessWithNoReceptionEmail;
    private MobilityProgram mobilityProgram;
    private List<MobilityIndividualApplicationProcess> subjectProcesses;
    private MobilityApplicationProcess mobilityApplicationProcess;
    private String emailSubject;
    private String emailBody;
    private static final long serialVersionUID = 1L;

    public SendReceptionEmailBean(MobilityApplicationProcess mobilityApplicationProcess) {
        this.mobilityApplicationProcess = mobilityApplicationProcess;
        this.includeOnlyProcessWithNoReceptionEmail = true;
        this.setMobilityProgram(this.findSomeDefaultMobilityProgram());
    }

    private MobilityProgram findSomeDefaultMobilityProgram() {
        for (MobilityProgram mobilityProgram : Bennu.getInstance().getProgramsSet()) {
            RegistrationProtocol protocol = mobilityProgram.getRegistrationProtocol();
            if (protocol.isEnrolmentByStudentAllowed() || protocol.isToPayGratuity() || !protocol.allowsIDCard() || protocol.isOnlyAllowedDegreeEnrolment() || protocol.isAlien() || !protocol.allowDissertationCandidacyWithoutChecks() || protocol.isForOfficialMobilityReporting() || protocol.attemptAlmaMatterFromPrecedent()) continue;
            return mobilityProgram;
        }
        return null;
    }

    public void removeProcess(MobilityIndividualApplicationProcess individualCandidacyProcess) {
        this.subjectProcesses.remove((Object)individualCandidacyProcess);
    }

    public void addProcess(MobilityIndividualApplicationProcess individualCandidacyProcess) {
        this.subjectProcesses.add(individualCandidacyProcess);
    }

    public void retrieveProcesses() {
        this.subjectProcesses = new ArrayList<MobilityIndividualApplicationProcess>();
        for (IndividualCandidacyProcess child : this.mobilityApplicationProcess.getChildProcessesSet()) {
            MobilityIndividualApplicationProcess individualCandidacyProcess = (MobilityIndividualApplicationProcess)((Object)child);
            if (!individualCandidacyProcess.isStudentAcceptedAndNotified() || this.includeOnlyProcessWithNoReceptionEmail && individualCandidacyProcess.isStudentNotifiedWithReceptionEmail() || individualCandidacyProcess.getMobilityProgram() != this.mobilityProgram) continue;
            this.subjectProcesses.add(individualCandidacyProcess);
        }
    }

    public boolean isIncludeOnlyProcessWithNoReceptionEmail() {
        return this.includeOnlyProcessWithNoReceptionEmail;
    }

    public void setIncludeOnlyProcessWithNoReceptionEmail(boolean includeOnlyProcessWithNoReceptionEmail) {
        this.includeOnlyProcessWithNoReceptionEmail = includeOnlyProcessWithNoReceptionEmail;
    }

    public MobilityProgram getMobilityProgram() {
        return this.mobilityProgram;
    }

    public void setMobilityProgram(MobilityProgram mobilityProgram) {
        this.mobilityProgram = mobilityProgram;
        this.emailSubject = this.mobilityApplicationProcess.getCandidacyPeriod().getEmailTemplateFor(mobilityProgram, MobilityEmailTemplateType.IST_RECEPTION).getSubject();
        this.emailBody = this.mobilityApplicationProcess.getCandidacyPeriod().getEmailTemplateFor(mobilityProgram, MobilityEmailTemplateType.IST_RECEPTION).getBody();
    }

    public List<MobilityIndividualApplicationProcess> getSubjectProcesses() {
        return this.subjectProcesses;
    }

    public void setSubjectProcesses(List<MobilityIndividualApplicationProcess> subjectProcesses) {
        this.subjectProcesses = subjectProcesses;
    }

    public MobilityApplicationProcess getMobilityApplicationProcess() {
        return this.mobilityApplicationProcess;
    }

    public void setMobilityApplicationProcess(MobilityApplicationProcess mobilityApplicationProcess) {
        this.mobilityApplicationProcess = mobilityApplicationProcess;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody;
    }
}

