/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessWithPrecedentDegreeInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplication;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentDataBean;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;

public class PrecedentDegreeInformationForIndividualCandidacyFactory {
    public static PrecedentDegreeInformation create(IndividualCandidacy individualCandidacy, IndividualCandidacyProcessBean processBean) {
        if (processBean.isStandalone()) {
            return null;
        }
        PrecedentDegreeInformation pid = null;
        if (processBean.isDegreeChange() || processBean.isDegreeTransfer()) {
            pid = PrecedentDegreeInformationForIndividualCandidacyFactory.createForDegreeTransferOrDegreeChange(processBean);
        } else if (processBean.isSecondCycle() || processBean.isDegreeCandidacyForGraduatedPerson()) {
            pid = PrecedentDegreeInformationForIndividualCandidacyFactory.createForSecondCycleOrDegreeCandidacyForGraduatedPerson(processBean);
        } else if (processBean.isOver23()) {
            pid = PrecedentDegreeInformationForIndividualCandidacyFactory.createForOver23(processBean);
        } else if (processBean.isErasmus()) {
            pid = PrecedentDegreeInformationForIndividualCandidacyFactory.createForErasmus(processBean);
        }
        pid.setIndividualCandidacy(individualCandidacy);
        return pid;
    }

    private static PrecedentDegreeInformation createForErasmus(IndividualCandidacyProcessBean processBean) {
        MobilityIndividualApplicationProcessBean erasmusBean = (MobilityIndividualApplicationProcessBean)processBean;
        MobilityStudentDataBean erasmusStudentDataBean = erasmusBean.getMobilityStudentDataBean();
        PrecedentDegreeInformation pdi = new PrecedentDegreeInformation();
        pdi.setCandidacyInternal(false);
        pdi.setPrecedentCountry(erasmusStudentDataBean.getSelectedCountry());
        pdi.setPrecedentInstitution((Unit)((Object)erasmusStudentDataBean.getSelectedUniversity()));
        pdi.setPrecedentSchoolLevel(erasmusStudentDataBean.getCurrentSchoolLevel());
        pdi.setOtherPrecedentSchoolLevel(erasmusStudentDataBean.getCurrentOtherSchoolLevel());
        pdi.setCountryHighSchool(erasmusStudentDataBean.getCountryWhereFinishedHighSchoolLevel());
        if (erasmusStudentDataBean.getHasDiplomaOrDegree().booleanValue()) {
            pdi.setDegreeDesignation(erasmusStudentDataBean.getDiplomaName());
            pdi.setConclusionYear(erasmusStudentDataBean.getDiplomaConclusionYear());
        }
        return pdi;
    }

    private static PrecedentDegreeInformation createForOver23(IndividualCandidacyProcessBean processBean) {
        Over23IndividualCandidacyProcessBean over23Bean = (Over23IndividualCandidacyProcessBean)processBean;
        if (!over23Bean.getFormationConcludedBeanList().isEmpty()) {
            PrecedentDegreeInformation pid = new PrecedentDegreeInformation();
            pid.setCandidacyInternal(false);
            FormationBean formationBean = over23Bean.getFormationConcludedBeanList().iterator().next();
            pid.setDegreeDesignation(formationBean.getDesignation());
            pid.setInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(formationBean.getInstitutionName()));
            pid.setConclusionYear(formationBean.getConclusionExecutionYear().getEndCivilYear());
            return pid;
        }
        if (!over23Bean.getFormationNonConcludedBeanList().isEmpty()) {
            PrecedentDegreeInformation pdi = new PrecedentDegreeInformation();
            pdi.setCandidacyInternal(false);
            FormationBean formationBean = over23Bean.getFormationNonConcludedBeanList().iterator().next();
            pdi.setDegreeDesignation(formationBean.getDesignation());
            pdi.setInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(formationBean.getInstitutionName()));
            return pdi;
        }
        return null;
    }

    private static PrecedentDegreeInformation createForDegreeTransferOrDegreeChange(IndividualCandidacyProcessBean processBean) {
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean candidacyProcessWithPDIBean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)processBean;
        PrecedentDegreeInformationBean bean = candidacyProcessWithPDIBean.getPrecedentDegreeInformation();
        PrecedentDegreeInformation pdi = new PrecedentDegreeInformation();
        pdi.setPrecedentDegreeDesignation(bean.getDegreeDesignation());
        pdi.setNumberOfEnroledCurricularCourses(bean.getNumberOfEnroledCurricularCourses());
        pdi.setNumberOfApprovedCurricularCourses(bean.getNumberOfApprovedCurricularCourses());
        pdi.setGradeSum(bean.getGradeSum());
        pdi.setApprovedEcts(bean.getApprovedEcts());
        pdi.setEnroledEcts(bean.getEnroledEcts());
        if (candidacyProcessWithPDIBean.isExternalPrecedentDegreeType()) {
            pdi.setPrecedentInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(bean));
            pdi.setNumberOfEnrolmentsInPreviousDegrees(candidacyProcessWithPDIBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree());
            pdi.setCandidacyInternal(false);
        } else {
            pdi.setCandidacyInternal(true);
            StudentCurricularPlan studentCurricularPlan = candidacyProcessWithPDIBean.getPrecedentStudentCurricularPlan();
            if (studentCurricularPlan == null) {
                throw new DomainException("error.IndividualCandidacy.invalid.precedentDegreeInformation", new String[0]);
            }
            pdi.setStudentCurricularPlan(studentCurricularPlan);
        }
        return pdi;
    }

    private static PrecedentDegreeInformation createForSecondCycleOrDegreeCandidacyForGraduatedPerson(IndividualCandidacyProcessBean processBean) {
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean candidacyProcessWithPrecedentDegreeInformationBean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)processBean;
        PrecedentDegreeInformationBean bean = candidacyProcessWithPrecedentDegreeInformationBean.getPrecedentDegreeInformation();
        PrecedentDegreeInformation pdi = new PrecedentDegreeInformation();
        pdi.setCandidacyInternal(false);
        pdi.setDegreeDesignation(bean.getDegreeDesignation());
        pdi.setInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(bean));
        pdi.setCountry(bean.getCountry());
        pdi.setConclusionDate(bean.getConclusionDate());
        if (bean.getConclusionDate() != null) {
            pdi.setConclusionYear(bean.getConclusionDate().getYear());
        }
        pdi.setConclusionGrade(bean.getConclusionGrade());
        return pdi;
    }

    private static Unit getOrCreateInstitution(PrecedentDegreeInformationBean bean) {
        if (bean.getInstitution() != null) {
            return bean.getInstitution();
        }
        return PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(bean.getInstitutionName());
    }

    private static Unit getOrCreateInstitution(String institutionName) {
        if (institutionName == null || institutionName.isEmpty()) {
            throw new DomainException("error.ExternalPrecedentDegreeCandidacy.invalid.institution.name", new String[0]);
        }
        Unit unit = Unit.findFirstExternalUnitByName(institutionName);
        return unit != null ? unit : Unit.createNewNoOfficialExternalInstitution(institutionName);
    }

    public static final void edit(IndividualCandidacyProcessBean processBean) {
        if (processBean.isDegreeChange() || processBean.isDegreeTransfer()) {
            PrecedentDegreeInformationForIndividualCandidacyFactory.editForDegreeTransferOrDegreeChange(processBean);
        } else if (processBean.isSecondCycle() || processBean.isDegreeCandidacyForGraduatedPerson()) {
            PrecedentDegreeInformationForIndividualCandidacyFactory.editForSecondCycleOrDegreeCandidacyForGraduatedPerson(processBean);
        } else if (processBean.isOver23()) {
            PrecedentDegreeInformationForIndividualCandidacyFactory.editForOver23(processBean);
        } else if (processBean.isErasmus()) {
            PrecedentDegreeInformationForIndividualCandidacyFactory.editForErasmus(processBean);
        }
    }

    private static void editForErasmus(IndividualCandidacyProcessBean processBean) {
        MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)processBean;
        MobilityStudentDataBean erasmusStudentDataBean = bean.getMobilityStudentDataBean();
        MobilityIndividualApplicationProcess erasmusIndividualCandidacyProcess = (MobilityIndividualApplicationProcess)((Object)processBean.getIndividualCandidacyProcess());
        MobilityIndividualApplication erasmusCandidacy = erasmusIndividualCandidacyProcess.getCandidacy();
        PrecedentDegreeInformation pid = erasmusCandidacy.getRefactoredPrecedentDegreeInformation();
        pid.setPrecedentCountry(erasmusStudentDataBean.getSelectedCountry());
        pid.setPrecedentInstitution((Unit)((Object)erasmusStudentDataBean.getSelectedUniversity()));
        pid.setPrecedentSchoolLevel(erasmusStudentDataBean.getCurrentSchoolLevel());
        pid.setOtherPrecedentSchoolLevel(erasmusStudentDataBean.getCurrentOtherSchoolLevel());
        pid.setCountryHighSchool(erasmusStudentDataBean.getCountryWhereFinishedHighSchoolLevel());
        if (erasmusStudentDataBean.getHasDiplomaOrDegree().booleanValue()) {
            pid.setDegreeDesignation(erasmusStudentDataBean.getDiplomaName());
            pid.setConclusionYear(erasmusStudentDataBean.getDiplomaConclusionYear());
        }
    }

    private static void editForOver23(IndividualCandidacyProcessBean processBean) {
        Over23IndividualCandidacyProcessBean over23Bean = (Over23IndividualCandidacyProcessBean)processBean;
        IndividualCandidacyProcess individualCandidacyProcess = processBean.getIndividualCandidacyProcess();
        IndividualCandidacy candidacy = individualCandidacyProcess.getCandidacy();
        PrecedentDegreeInformation pid = candidacy.getRefactoredPrecedentDegreeInformation();
        if (!over23Bean.getFormationConcludedBeanList().isEmpty()) {
            FormationBean formationBean = over23Bean.getFormationConcludedBeanList().iterator().next();
            pid.setDegreeDesignation(formationBean.getDesignation());
            pid.setInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(formationBean.getInstitutionName()));
            pid.setConclusionYear(formationBean.getConclusionExecutionYear().getEndCivilYear());
        } else if (over23Bean.getFormationNonConcludedBeanList().isEmpty()) {
            FormationBean formationBean = over23Bean.getFormationNonConcludedBeanList().iterator().next();
            pid.setDegreeDesignation(formationBean.getDesignation());
            pid.setInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(formationBean.getInstitutionName()));
        }
    }

    private static void editForSecondCycleOrDegreeCandidacyForGraduatedPerson(IndividualCandidacyProcessBean processBean) {
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean candidacyProcessWithPrecedentDegreeInformationBean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)processBean;
        IndividualCandidacyProcess individualCandidacyProcess = processBean.getIndividualCandidacyProcess();
        IndividualCandidacy candidacy = individualCandidacyProcess.getCandidacy();
        PrecedentDegreeInformation pid = candidacy.getRefactoredPrecedentDegreeInformation();
        PrecedentDegreeInformationBean bean = candidacyProcessWithPrecedentDegreeInformationBean.getPrecedentDegreeInformation();
        pid.setDegreeDesignation(bean.getDegreeDesignation());
        pid.setInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(bean));
        pid.setCountry(bean.getCountry());
        pid.setConclusionDate(bean.getConclusionDate());
        if (bean.getConclusionDate() != null) {
            pid.setConclusionYear(bean.getConclusionDate().getYear());
        }
        pid.setConclusionGrade(bean.getConclusionGrade());
    }

    private static void editForDegreeTransferOrDegreeChange(IndividualCandidacyProcessBean processBean) {
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean candidacyProcessWithPrecedentDegreeInformationBean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)processBean;
        PrecedentDegreeInformationBean bean = candidacyProcessWithPrecedentDegreeInformationBean.getPrecedentDegreeInformation();
        IndividualCandidacyProcess individualCandidacyProcess = processBean.getIndividualCandidacyProcess();
        IndividualCandidacy candidacy = individualCandidacyProcess.getCandidacy();
        PrecedentDegreeInformation pid = candidacy.getRefactoredPrecedentDegreeInformation();
        pid.setPrecedentDegreeDesignation(bean.getDegreeDesignation());
        pid.setPrecedentInstitution(PrecedentDegreeInformationForIndividualCandidacyFactory.getOrCreateInstitution(bean));
        pid.setNumberOfEnroledCurricularCourses(bean.getNumberOfEnroledCurricularCourses());
        pid.setNumberOfApprovedCurricularCourses(bean.getNumberOfApprovedCurricularCourses());
        pid.setGradeSum(bean.getGradeSum());
        pid.setApprovedEcts(bean.getApprovedEcts());
        pid.setEnroledEcts(bean.getEnroledEcts());
    }
}

