/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.core.security.Authenticate;

public class CandidacyProcessSelectDegreesBean
implements Serializable {
    private static final long serialVersionUID = -3289144446453054775L;
    private List<Degree> degrees = new ArrayList<Degree>();

    public List<Degree> getDegrees() {
        return this.degrees;
    }

    public void setDegrees(List<Degree> degrees) {
        this.degrees = degrees;
    }

    public Collection<Degree> getFirstCycleDegrees() {
        return this.filterDegrees(Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree)));
    }

    public Collection<Degree> getSecondCycleDegrees() {
        return this.filterDegrees(Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree)));
    }

    protected Collection<Degree> filterDegrees(Collection<Degree> degrees) {
        final Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, Authenticate.getUser()).collect(Collectors.toSet());
        return Collections2.filter(degrees, (Predicate)new Predicate<Degree>(){

            public boolean apply(Degree degree) {
                return programs.contains(degree);
            }
        });
    }
}

