/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.util;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.util.PaymentCodeGenerator;
import org.fenixedu.academic.domain.util.Verhoeff;

public class PersonPaymentCodeGenerator
extends PaymentCodeGenerator {
    private static final String CODE_FILLER = "0";
    private static final int PERSON_CODE_LENGTH = 6;
    private static final int TYPE_CODE_LENGTH = 2;
    private static final int CODE_LENGTH = 9;

    @Override
    public boolean canGenerateNewCode(PaymentCodeType paymentCodeType, Person person) {
        for (PaymentCode code : person.getPaymentCodesBy(paymentCodeType)) {
            if (!this.isCodeMadeByThisFactory(code)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateNewCodeFor(PaymentCodeType paymentCodeType, Person person) {
        String baseCode = this.getPersonCodeDigits(person) + StringUtils.leftPad((String)Integer.toString(paymentCodeType.getTypeDigit()), (int)2, (String)CODE_FILLER);
        if ((baseCode = baseCode + Verhoeff.generateVerhoeff(baseCode)).length() != 9) {
            throw new RuntimeException("Unexpected code length for generated code");
        }
        return baseCode;
    }

    private String getPersonCodeDigits(Person person) {
        if (person.getUsername().length() > 9) {
            throw new RuntimeException("SIBS Payment Code: " + person.getUsername() + " exceeded maximun size accepted");
        }
        return StringUtils.leftPad((String)person.getUsername().replace("ist", ""), (int)6, (String)CODE_FILLER);
    }

    @Override
    public boolean isCodeMadeByThisFactory(PaymentCode paymentCode) {
        return paymentCode.getCode().startsWith(this.getPersonCodeDigits(paymentCode.getPerson()));
    }
}

