/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.phd;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicServiceRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.phd.PhdFinalizationCertificateRequestPR_Base;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class PhdFinalizationCertificateRequestPR
extends PhdFinalizationCertificateRequestPR_Base {
    protected PhdFinalizationCertificateRequestPR() {
    }

    public PhdFinalizationCertificateRequestPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(EntryType.PHD_FINALIZATION_CERTIFICATE_REQUEST_FEE, EventType.PHD_FINALIZATION_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        AcademicServiceRequestEvent academicServiceRequestEvent = (AcademicServiceRequestEvent)((Object)event);
        AcademicServiceRequest academicServiceRequest = academicServiceRequestEvent.getAcademicServiceRequest();
        return super.doCalculationForAmountToPay((Event)((Object)academicServiceRequestEvent), when, applyDiscount).multiply(academicServiceRequest.isUrgentRequest() ? 2 : 1);
    }

    public PhdFinalizationCertificateRequestPR edit(Money fixedAmount) {
        this.deactivate();
        return new PhdFinalizationCertificateRequestPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }

    public Money getUrgentAmount() {
        return super.getFixedAmount();
    }
}

