/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.DegreeFinalizationCertificateRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DegreeFinalizationCertificateRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class DegreeFinalizationCertificateRequestEvent
extends DegreeFinalizationCertificateRequestEvent_Base {
    private DegreeFinalizationCertificateRequestEvent() {
    }

    public DegreeFinalizationCertificateRequestEvent(AdministrativeOffice administrativeOffice, Person person, DegreeFinalizationCertificateRequest certificateRequest) {
        this();
        super.init(administrativeOffice, EventType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST, person, (RegistrationAcademicServiceRequest)((Object)certificateRequest));
    }

    public DegreeFinalizationCertificateRequest getAcademicServiceRequest() {
        return (DegreeFinalizationCertificateRequest)((Object)super.getAcademicServiceRequest());
    }

    protected void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        this.addCycleDescriptionIfRequired(labelFormatter);
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent());
        labelFormatter.appendLabel(")");
        labelFormatter.appendLabel(" - ").appendLabel(this.getAcademicServiceRequest().getServiceRequestNumberYear());
    }

    private void addCycleDescriptionIfRequired(LabelFormatter labelFormatter) {
        DegreeFinalizationCertificateRequest request = this.getAcademicServiceRequest();
        if (request.getProgramConclusion() != null) {
            labelFormatter.appendLabel(request.getProgramConclusion().getName().getContent()).appendLabel(" ").appendLabel("label.of", "resources.ApplicationResources").appendLabel(" ");
        }
    }
}

