/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.candidacy;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.candidacy.IndividualCandidacyEvent_Base;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.YearMonthDay;

public abstract class IndividualCandidacyEvent
extends IndividualCandidacyEvent_Base {
    protected IndividualCandidacyEvent() {
    }

    protected void init(IndividualCandidacy candidacy, EventType eventType, Person person) {
        AdministrativeOffice administrativeOffice = this.readAdministrativeOffice();
        this.checkParameters(candidacy, administrativeOffice);
        super.init(administrativeOffice, eventType, person);
        this.setIndividualCandidacy(candidacy);
    }

    protected void attachAvailablePaymentCode(Person person) {
        YearMonthDay candidacyDate = this.getIndividualCandidacy().getCandidacyDate().toDateTimeAtStartOfDay().toYearMonthDay();
        IndividualCandidacyPaymentCode paymentCode = IndividualCandidacyPaymentCode.getAvailablePaymentCodeAndUse(this.getPaymentCodeType(), candidacyDate, (Event)((Object)this), person);
        if (paymentCode == null) {
            throw new DomainException("error.IndividualCandidacyEvent.invalid.payment.code", new String[0]);
        }
    }

    protected void checkParameters(IndividualCandidacy candidacy, AdministrativeOffice administrativeOffice) {
        if (candidacy == null) {
            throw new DomainException("error.IndividualCandidacyEvent.invalid.candidacy", new String[0]);
        }
        if (administrativeOffice == null) {
            throw new DomainException("error.IndividualCandidacyEvent.invalid.administrativeOffice", new String[0]);
        }
    }

    protected abstract AdministrativeOffice readAdministrativeOffice();

    public PaymentCodeType getPaymentCodeType() {
        PostingRule postingRule = this.getAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
        return postingRule.calculatePaymentCodeTypeFromEvent((Event)((Object)this), this.getWhenOccured(), false);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        return new LabelFormatter().appendLabel(entryType.name(), "resources.EnumerationResources");
    }

    protected Account getFromAccount() {
        return this.getPerson().getExternalAccount();
    }

    public PostingRule getPostingRule() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getInternalAccount();
    }

    public Student getCandidacyStudent() {
        return this.getIndividualCandidacy().getStudent();
    }

    public boolean hasCandidacyStudent() {
        return this.getIndividualCandidacy().hasStudent();
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        return this.internalProcess(responsibleUser, Collections.singletonList(new EntryDTO(this.getEntryType(), (Event)((Object)this), amountToPay)), transactionDetail);
    }

    protected abstract EntryType getEntryType();

    public boolean isIndividualCandidacyEvent() {
        return true;
    }
}

