/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.EventType;

public class EventTypes {
    private final ImmutableSet<EventType> types;

    public EventTypes(JsonElement json) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonElement el : json.getAsJsonArray()) {
            builder.add((Object)EventType.valueOf(el.getAsString()));
        }
        this.types = builder.build();
    }

    public EventTypes(Set<EventType> types) {
        this.types = ImmutableSet.copyOf(types);
    }

    public EventTypes() {
        this.types = ImmutableSet.of();
    }

    public Set<EventType> getTypes() {
        return this.types;
    }

    public JsonElement toJson() {
        JsonArray array = new JsonArray();
        this.types.stream().map(Enum::name).map(JsonPrimitive::new).forEach(type -> array.add((JsonElement)type));
        return array;
    }
}

