/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.AccountingTransactionDetail_Base;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class AccountingTransactionDetail
extends AccountingTransactionDetail_Base {
    protected AccountingTransactionDetail() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenProcessed(new DateTime());
    }

    public AccountingTransactionDetail(DateTime whenRegistered, PaymentMode paymentMode) {
        this(whenRegistered, paymentMode, null);
    }

    public AccountingTransactionDetail(DateTime whenRegistered, PaymentMode paymentMode, String comments) {
        this();
        this.init(whenRegistered, paymentMode, comments);
    }

    private void checkParameters(DateTime whenRegistered, PaymentMode paymentMode) {
        if (whenRegistered == null) {
            throw new DomainException("error.accounting.AccountingTransactionDetail.whenRegistered.cannot.be.null", new String[0]);
        }
        if (paymentMode == null) {
            throw new DomainException("error.accounting.AccountingTransactionDetail.paymentMode.cannot.be.null", new String[0]);
        }
    }

    protected void init(DateTime whenRegistered, PaymentMode paymentMode, String comments) {
        this.checkParameters(whenRegistered, paymentMode);
        super.setWhenRegistered(whenRegistered);
        super.setPaymentMode(paymentMode);
        super.setComments(comments);
    }

    public void setWhenRegistered(DateTime whenRegistered) {
        throw new DomainException("error.accounting.AccountingTransactionDetail.cannot.modify.whenRegistered", new String[0]);
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        throw new DomainException("error.accounting.AccountingTransactionDetail.cannot.modify.paymentMode", new String[0]);
    }

    public void setTransaction(AccountingTransaction transaction) {
        throw new DomainException("error.accounting.AccountingTransactionDetail.cannot.modify.transaction", new String[0]);
    }

    void delete() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setTransaction(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public Event getEvent() {
        return this.getTransaction().getEvent();
    }
}

