/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.IdentificationDocumentExtraDigit;
import org.fenixedu.academic.domain.IdentificationDocumentSeriesNumber;
import org.fenixedu.academic.domain.Person$callable$incValidationRequest;
import org.fenixedu.academic.domain.Person$callable$setNumberOfValidationRequests;
import org.fenixedu.academic.domain.PersonIdentificationDocumentExtraInfo;
import org.fenixedu.academic.domain.PersonInformationLog;
import org.fenixedu.academic.domain.Person_Base;
import org.fenixedu.academic.domain.PhotoState;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accounting.AcademicEvent;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.accounting.ServiceAgreement;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.PastAdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.DegreeCandidacy;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPerson;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacy;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.contacts.WebAddress;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.documents.AnnualIRSDeclarationDocument;
import org.fenixedu.academic.domain.documents.GeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.IdDocument;
import org.fenixedu.academic.domain.person.IdDocumentTypeObject;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.candidacy.PHDProgramCandidacy;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.Money;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserProfile;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.rendererExtensions.util.IPresentableEnum;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Person
extends Person_Base {
    private static final Integer MAX_VALIDATION_REQUESTS;
    public static final String PERSON_CREATE_SIGNAL = "academic.person.create";
    public static final Advice advice$setNumberOfValidationRequests;
    public static final Advice advice$incValidationRequest;

    private IdDocument getIdDocument() {
        Iterator documentIterator = this.getIdDocumentsSet().iterator();
        return documentIterator.hasNext() ? (IdDocument)((Object)documentIterator.next()) : null;
    }

    public void setUser(User user) {
        super.setUser(user);
        if (this.getProfile() != null) {
            this.getProfile().setAvatarUrl(CoreConfiguration.getConfiguration().applicationUrl() + "/user/photo/" + this.getUser().getUsername());
        }
    }

    public MultiLanguageString getPartyName() {
        LocalizedString.Builder builder = new LocalizedString.Builder();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            builder.with(locale, this.getName());
        }
        return MultiLanguageString.fromLocalizedString(builder.build());
    }

    public String getName() {
        return this.getProfile().getFullName();
    }

    @Deprecated
    public String getGivenNames() {
        return this.getProfile().getGivenNames();
    }

    @Deprecated
    public String getFamilyNames() {
        return this.getProfile().getFamilyNames();
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        if (documentIdNumber == null || Strings.isNullOrEmpty((String)documentIdNumber)) {
            throw new DomainException("error.person.empty.documentIdNumber", new String[0]);
        }
        IdDocument idDocument = this.getIdDocument();
        if (idDocument == null) {
            idDocument = new IdDocument(this, documentIdNumber, (IdDocumentTypeObject)null);
        } else {
            idDocument.setValue(documentIdNumber);
        }
        this.logSetterNullString("log.personInformation.edit.generalTemplate.personalId", this.getDocumentIdNumber(), documentIdNumber, "label.documentNumber");
        super.setDocumentIdNumber(documentIdNumber);
    }

    public void setIdDocumentType(IDDocumentType idDocumentType) {
        if (idDocumentType == null) {
            throw new DomainException("error.person.empty.idDocumentType", new String[0]);
        }
        IdDocument idDocument = this.getIdDocument();
        if (idDocument == null) {
            idDocument = new IdDocument(this, null, idDocumentType);
        } else {
            idDocument.setIdDocumentType(idDocumentType);
        }
        this.logSetterNullEnum("log.personInformation.edit.generalTemplate.personalId", this.getIdDocumentType(), idDocumentType, "label.documentIdType");
        super.setIdDocumentType(idDocumentType);
    }

    public void setIdentification(String documentIdNumber, IDDocumentType idDocumentType) {
        if ((documentIdNumber = StringUtils.trimToNull((String)documentIdNumber)) != null && idDocumentType != null && this.checkIfDocumentNumberIdAndDocumentIdTypeExists(documentIdNumber, idDocumentType)) {
            throw new DomainException("error.person.existent.docIdAndType", new String[0]);
        }
        this.setDocumentIdNumber(documentIdNumber);
        this.setIdDocumentType(idDocumentType);
    }

    public void setIdentificationAndNames(String documentIdNumber, IDDocumentType idDocumentType, String givenNames, String familyNames) {
        this.getProfile().changeName(givenNames, familyNames, null);
        this.setIdentification(documentIdNumber, idDocumentType);
    }

    private boolean checkIfDocumentNumberIdAndDocumentIdTypeExists(String documentIDNumber, IDDocumentType documentType) {
        Person person = Person.readByDocumentIdNumberAndIdDocumentType(documentIDNumber, documentType);
        return person != null && !person.equals((Object)this);
    }

    public final String getValidatedName() {
        return StringFormatter.prettyPrint(this.getName());
    }

    public Person(UserProfile profile) {
        this(profile, true);
    }

    private Person(UserProfile profile, boolean emitSignal) {
        this.setProfile(profile);
        if (profile.getUser() != null) {
            this.setUser(profile.getUser());
        }
        this.setMaritalStatus(MaritalStatus.UNKNOWN);
        if (emitSignal) {
            Signal.emit((String)PERSON_CREATE_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this));
        }
    }

    public Person(PersonBean personBean) {
        this(personBean, false, true);
    }

    public Person(PersonBean personBean, boolean validateEmail) {
        this(personBean, validateEmail, true);
    }

    private Person(PersonBean personBean, boolean validateEmail, boolean emitSignal) {
        this(new UserProfile(personBean.getGivenNames(), personBean.getFamilyNames(), null, personBean.getEmail(), Locale.getDefault()), false);
        this.setProperties(personBean);
        PhysicalAddress.createPhysicalAddress((Party)((Object)this), personBean.getPhysicalAddressData(), PartyContactType.PERSONAL, true);
        Phone.createPhone((Party)((Object)this), personBean.getPhone(), PartyContactType.PERSONAL, true);
        MobilePhone.createMobilePhone((Party)((Object)this), personBean.getMobile(), PartyContactType.PERSONAL, true);
        EmailAddress emailAddress = EmailAddress.createEmailAddress((Party)((Object)this), personBean.getEmail(), PartyContactType.PERSONAL, true);
        if (validateEmail) {
            emailAddress.setValid();
        }
        WebAddress.createWebAddress((Party)((Object)this), personBean.getWebAddress(), PartyContactType.PERSONAL, true);
        if (emitSignal) {
            Signal.emit((String)PERSON_CREATE_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this));
        }
    }

    public Person(IndividualCandidacyPersonalDetails candidacyPersonalDetails) {
        this(new UserProfile(candidacyPersonalDetails.getGivenNames(), candidacyPersonalDetails.getFamilyNames(), null, candidacyPersonalDetails.getEmail(), Locale.getDefault()), false);
        this.setUser(new User(this.getProfile()));
        this.setCountry(candidacyPersonalDetails.getCountry());
        this.setDateOfBirthYearMonthDay(candidacyPersonalDetails.getDateOfBirthYearMonthDay());
        this.setDocumentIdNumber(candidacyPersonalDetails.getDocumentIdNumber());
        this.setExpirationDateOfDocumentIdYearMonthDay(candidacyPersonalDetails.getExpirationDateOfDocumentIdYearMonthDay());
        this.setGender(candidacyPersonalDetails.getGender());
        this.setIdDocumentType(candidacyPersonalDetails.getIdDocumentType());
        this.setSocialSecurityNumber(candidacyPersonalDetails.getSocialSecurityNumber());
        PhysicalAddressData physicalAddressData = new PhysicalAddressData(candidacyPersonalDetails.getAddress(), candidacyPersonalDetails.getAreaCode(), "", candidacyPersonalDetails.getArea(), "", "", "", candidacyPersonalDetails.getCountryOfResidence());
        PhysicalAddress.createPhysicalAddress((Party)((Object)this), physicalAddressData, PartyContactType.PERSONAL, true);
        Phone.createPhone((Party)((Object)this), candidacyPersonalDetails.getTelephoneContact(), PartyContactType.PERSONAL, true);
        EmailAddress.createEmailAddress((Party)((Object)this), candidacyPersonalDetails.getEmail(), PartyContactType.PERSONAL, true);
        Signal.emit((String)PERSON_CREATE_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Person editPersonalInformation(PersonBean personBean) {
        AccessControl.check(this, AcademicPredicates.EDIT_STUDENT_PERSONAL_DATA);
        this.setProperties(personBean);
        return this;
    }

    public Person editByPublicCandidate(PersonBean personBean) {
        this.getProfile().changeName(personBean.getGivenNames(), personBean.getFamilyNames(), null);
        this.setGender(personBean.getGender());
        this.setIdentification(personBean.getDocumentIdNumber(), personBean.getIdDocumentType());
        this.setExpirationDateOfDocumentIdYearMonthDay(personBean.getDocumentIdExpirationDate());
        this.setSocialSecurityNumber(personBean.getSocialSecurityNumber());
        this.setDateOfBirthYearMonthDay(personBean.getDateOfBirth());
        this.setCountry(personBean.getNationality());
        this.setDefaultPhysicalAddressData(personBean.getPhysicalAddressData());
        this.setDefaultPhoneNumber(personBean.getPhone());
        this.setDefaultEmailAddressValue(personBean.getEmail(), true);
        return this;
    }

    public Person edit(IndividualCandidacyPersonalDetails candidacyExternalDetails) {
        this.setCountry(candidacyExternalDetails.getCountry());
        this.setDateOfBirthYearMonthDay(candidacyExternalDetails.getDateOfBirthYearMonthDay());
        this.setIdentification(candidacyExternalDetails.getDocumentIdNumber(), candidacyExternalDetails.getIdDocumentType());
        this.setExpirationDateOfDocumentIdYearMonthDay(candidacyExternalDetails.getExpirationDateOfDocumentIdYearMonthDay());
        this.setGender(candidacyExternalDetails.getGender());
        this.getProfile().changeName(candidacyExternalDetails.getGivenNames(), candidacyExternalDetails.getFamilyNames(), null);
        this.setSocialSecurityNumber(candidacyExternalDetails.getSocialSecurityNumber());
        PhysicalAddressData physicalAddressData = new PhysicalAddressData(candidacyExternalDetails.getAddress(), candidacyExternalDetails.getAreaCode(), this.getAreaOfAreaCode(), candidacyExternalDetails.getArea(), this.getParishOfResidence(), this.getDistrictSubdivisionOfResidence(), this.getDistrictOfResidence(), candidacyExternalDetails.getCountryOfResidence());
        this.setDefaultPhysicalAddressData(physicalAddressData);
        this.setDefaultPhoneNumber(candidacyExternalDetails.getTelephoneContact());
        this.setDefaultEmailAddressValue(candidacyExternalDetails.getEmail());
        return this;
    }

    public Person editPersonWithExternalData(PersonBean personBean, boolean updateExistingContacts) {
        this.setProperties(personBean);
        this.setDefaultPhysicalAddressData(personBean.getPhysicalAddressData());
        if (updateExistingContacts) {
            this.setDefaultPhoneNumber(personBean.getPhone());
            this.setDefaultMobilePhoneNumber(personBean.getMobile());
            this.setDefaultWebAddressUrl(personBean.getWebAddress());
            this.setDefaultEmailAddressValue(personBean.getEmail());
        } else {
            Phone.createPhone((Party)((Object)this), personBean.getPhone(), PartyContactType.PERSONAL, !this.hasDefaultPhone());
            MobilePhone.createMobilePhone((Party)((Object)this), personBean.getMobile(), PartyContactType.PERSONAL, !this.hasDefaultMobilePhone());
            EmailAddress.createEmailAddress((Party)((Object)this), personBean.getEmail(), PartyContactType.PERSONAL, !this.hasDefaultEmailAddress());
            WebAddress.createWebAddress((Party)((Object)this), personBean.getWebAddress(), PartyContactType.PERSONAL, !this.hasDefaultWebAddress());
        }
        return this;
    }

    public String getUsername() {
        User user = this.getUser();
        return user == null ? null : user.getUsername();
    }

    public Registration getStudentByType(DegreeType degreeType) {
        for (Registration registration : this.getStudents()) {
            if (registration.getDegreeType() != degreeType) continue;
            return registration;
        }
        return null;
    }

    private String valueToUpdateIfNewNotNull(String actualValue, String newValue) {
        if (newValue == null || newValue.length() == 0) {
            return actualValue;
        }
        return newValue;
    }

    private Object valueToUpdateIfNewNotNull(Object actualValue, Object newValue) {
        if (newValue == null) {
            return actualValue;
        }
        return newValue;
    }

    private void setProperties(PersonBean personBean) {
        this.getProfile().changeName(personBean.getGivenNames(), personBean.getFamilyNames(), null);
        this.setGender(personBean.getGender());
        this.setProfession(personBean.getProfession());
        this.setMaritalStatus(personBean.getMaritalStatus());
        this.setIdentification(personBean.getDocumentIdNumber(), personBean.getIdDocumentType());
        this.setEmissionLocationOfDocumentId(personBean.getDocumentIdEmissionLocation());
        this.setEmissionDateOfDocumentIdYearMonthDay(personBean.getDocumentIdEmissionDate());
        this.setExpirationDateOfDocumentIdYearMonthDay(personBean.getDocumentIdExpirationDate());
        this.setSocialSecurityNumber(personBean.getSocialSecurityNumber());
        this.setEidentifier(personBean.getEidentifier());
        this.setDateOfBirthYearMonthDay(personBean.getDateOfBirth());
        this.setCountry(personBean.getNationality());
        this.setParishOfBirth(personBean.getParishOfBirth());
        this.setDistrictSubdivisionOfBirth(personBean.getDistrictSubdivisionOfBirth());
        this.setDistrictOfBirth(personBean.getDistrictOfBirth());
        this.setCountryOfBirth(personBean.getCountryOfBirth());
        this.setNameOfMother(personBean.getMotherName());
        this.setNameOfFather(personBean.getFatherName());
    }

    public Group getPersonGroup() {
        return UserGroup.of((User[])new User[]{this.getUser()});
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        if (this.getPersonalPhotoEvenIfRejected() != null) {
            this.getPersonalPhotoEvenIfRejected().delete();
        }
        if (this.getAssociatedPersonAccount() != null) {
            this.getAssociatedPersonAccount().delete();
        }
        if (this.getStudent() != null) {
            this.getStudent().delete();
        }
        this.getThesisEvaluationParticipantsSet().clear();
        while (!this.getIdDocumentsSet().isEmpty()) {
            ((IdDocument)((Object)this.getIdDocumentsSet().iterator().next())).delete();
        }
        while (!this.getScientificCommissionsSet().isEmpty()) {
            ((ScientificCommission)((Object)this.getScientificCommissionsSet().iterator().next())).delete();
        }
        super.setCountry(null);
        super.setCountryOfBirth(null);
        this.setProfile(null);
        super.setUser(null);
        super.delete();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!(this.getPartyContactsSet().isEmpty() && this.getChildsSet().isEmpty() && this.getParentsSet().isEmpty() && this.getExportGroupingReceiversSet().isEmpty() && this.getAssociatedQualificationsSet().isEmpty() && this.getAssociatedAlteredCurriculumsSet().isEmpty() && this.getEnrolmentEvaluationsSet().isEmpty() && this.getExportGroupingSendersSet().isEmpty() && this.getResponsabilityTransactionsSet().isEmpty() && this.getGuidesSet().isEmpty() && this.getTeacher() == null && this.getInternalParticipantsSet().isEmpty() && this.getCreatedQualificationsSet().isEmpty() && this.getCreateJobsSet().isEmpty())) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.person.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public void setDisableSendEmails(Boolean disableSendEmails) {
        super.setDisableSendEmails(disableSendEmails);
        this.getProfile().setEmail(this.getEmailForSendingEmails());
    }

    public boolean hasDegreeCandidacyForExecutionDegree(ExecutionDegree executionDegree) {
        for (Candidacy candidacy : this.getCandidaciesSet()) {
            DegreeCandidacy degreeCandidacy;
            if (!(candidacy instanceof DegreeCandidacy) || !candidacy.isActive() || !(degreeCandidacy = (DegreeCandidacy)((Object)candidacy)).getExecutionDegree().equals(executionDegree)) continue;
            return true;
        }
        return false;
    }

    public StudentCandidacy getStudentCandidacyForExecutionDegree(ExecutionDegree executionDegree) {
        for (Candidacy candidacy : this.getCandidaciesSet()) {
            StudentCandidacy studentCandidacy;
            if (!(candidacy instanceof StudentCandidacy) || !candidacy.isActive() || candidacy instanceof PHDProgramCandidacy || !(studentCandidacy = (StudentCandidacy)((Object)candidacy)).getExecutionDegree().equals(executionDegree)) continue;
            return studentCandidacy;
        }
        return null;
    }

    public boolean hasStudentCandidacyForExecutionDegree(ExecutionDegree executionDegree) {
        return this.getStudentCandidacyForExecutionDegree(executionDegree) != null;
    }

    public static Person readPersonByUsername(String username) {
        User user = User.findByUsername((String)username);
        return user == null ? null : user.getPerson();
    }

    public static Collection<Person> readByDocumentIdNumber(String documentIdNumber) {
        HashSet<Person> result = new HashSet<Person>();
        for (IdDocument idDocument : IdDocument.find(documentIdNumber)) {
            result.add(idDocument.getPerson());
        }
        return result;
    }

    public static Person readByDocumentIdNumberAndIdDocumentType(String documentIdNumber, IDDocumentType idDocumentType) {
        for (IdDocument idDocument : IdDocument.find(documentIdNumber)) {
            if (idDocument.getIdDocumentType().getValue() != idDocumentType) continue;
            return idDocument.getPerson();
        }
        return null;
    }

    public static Collection<Person> findByDateOfBirth(YearMonthDay dateOfBirth, Collection<Person> persons) {
        ArrayList<Person> result = new ArrayList<Person>();
        for (Person person : persons) {
            if (person.getDateOfBirthYearMonthDay() != null && !person.getDateOfBirthYearMonthDay().equals((Object)dateOfBirth)) continue;
            result.add(person);
        }
        return result;
    }

    public static Stream<Person> findPersonStream(String name, int size) {
        return UserProfile.searchByName((String)name, (int)size).map(p -> p.getPerson()).filter(Objects::nonNull);
    }

    public static Collection<Person> findPerson(String name, int size) {
        return Person.findPersonStream(name, size).collect(Collectors.toSet());
    }

    public static Collection<Person> readPersonsByNameAndRoleType(String name, RoleType roleType) {
        Collection<Person> people = Person.findPerson(name);
        Iterator<Person> iter = people.iterator();
        while (iter.hasNext()) {
            Person person = iter.next();
            if (roleType.isMember(person.getUser())) continue;
            iter.remove();
        }
        return people;
    }

    public SortedSet<StudentCurricularPlan> getActiveStudentCurricularPlansSortedByDegreeTypeAndDegreeName() {
        TreeSet<StudentCurricularPlan> studentCurricularPlans = new TreeSet<StudentCurricularPlan>(StudentCurricularPlan.STUDENT_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_DEGREE_NAME);
        for (Registration registration : this.getStudentsSet()) {
            StudentCurricularPlan studentCurricularPlan = registration.getActiveStudentCurricularPlan();
            if (studentCurricularPlan == null) continue;
            studentCurricularPlans.add(studentCurricularPlan);
        }
        return studentCurricularPlans;
    }

    public Set<Attends> getCurrentAttends() {
        HashSet<Attends> attends = new HashSet<Attends>();
        for (Registration registration : this.getStudentsSet()) {
            for (Attends attend : registration.getAssociatedAttendsSet()) {
                ExecutionCourse executionCourse = attend.getExecutionCourse();
                ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
                if (!executionSemester.getState().equals(PeriodState.CURRENT)) continue;
                attends.add(attend);
            }
        }
        return attends;
    }

    private Set<Event> getEventsFromType(Class<? extends Event> clazz) {
        HashSet<Event> events = new HashSet<Event>();
        for (Event event : this.getEventsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)event)).getClass())) continue;
            events.add(event);
        }
        return events;
    }

    public Set<Event> getAcademicEvents() {
        return this.getEventsFromType(AcademicEvent.class);
    }

    public Set<Event> getResidencePaymentEvents() {
        return this.getEventsFromType(ResidenceEvent.class);
    }

    public Set<Event> getNotPayedEventsPayableOn(AdministrativeOffice administrativeOffice, Class eventClass, boolean withInstallments) {
        HashSet<Event> result = new HashSet<Event>();
        Set<Event> events = this.getEventsFromType(eventClass);
        for (Event event : events) {
            if (!event.isOpen() || event.hasInstallments() != withInstallments || !this.isPayableOnAnyOfAdministrativeOffices(Collections.singleton(administrativeOffice), event)) continue;
            result.add(event);
        }
        return result;
    }

    public Set<Event> getNotPayedEventsPayableOn(AdministrativeOffice administrativeOffice, boolean withInstallments) {
        return this.getNotPayedEventsPayableOn(administrativeOffice, AcademicEvent.class, withInstallments);
    }

    public Set<Event> getNotPayedEvents() {
        HashSet<Event> result = new HashSet<Event>();
        for (Event event : this.getAcademicEvents()) {
            if (!event.isOpen()) continue;
            result.add(event);
        }
        return result;
    }

    private boolean isPayableOnAnyOfAdministrativeOffices(Set<AdministrativeOffice> administrativeOffices, Event event) {
        if (administrativeOffices == null) {
            return true;
        }
        for (AdministrativeOffice administrativeOffice : administrativeOffices) {
            if (administrativeOffice != null && !event.isPayableOnAdministrativeOffice(administrativeOffice)) continue;
            return true;
        }
        return false;
    }

    public List<Event> getPayedEvents(Class eventClass) {
        ArrayList<Event> result = new ArrayList<Event>();
        Set<Event> events = this.getEventsFromType(eventClass);
        for (Event event : events) {
            if (!event.isClosed()) continue;
            result.add(event);
        }
        return result;
    }

    public List<Event> getPayedEvents() {
        return this.getPayedEvents(AcademicEvent.class);
    }

    public List<Event> getEventsWithPayments() {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.getAcademicEvents()) {
            if (event.isCancelled() || !event.hasAnyPayments()) continue;
            result.add(event);
        }
        return result;
    }

    public Set<Entry> getPaymentsWithoutReceipt() {
        return this.getPaymentsWithoutReceiptByAdministrativeOffices(null);
    }

    public Set<Entry> getPaymentsWithoutReceiptByAdministrativeOffices(Set<AdministrativeOffice> administrativeOffices) {
        HashSet<Entry> result = new HashSet<Entry>();
        for (Event event : this.getAcademicEvents()) {
            if (event.isCancelled() || !this.isPayableOnAnyOfAdministrativeOffices(administrativeOffices, event)) continue;
            result.addAll(event.getEntriesWithoutReceipt());
        }
        return result;
    }

    public Set<Entry> getPayments(Class eventClass) {
        HashSet<Entry> result = new HashSet<Entry>();
        Set<Event> events = this.getEventsFromType(eventClass);
        for (Event event : events) {
            if (event.isCancelled()) continue;
            result.addAll(event.getPositiveEntries());
        }
        return result;
    }

    public Set<Entry> getPayments() {
        return this.getPayments(AcademicEvent.class);
    }

    public Money getTotalPaymentsAmountWithAdjustment() {
        Money total = new Money(0L);
        for (Entry entry : this.getPayments(AcademicEvent.class)) {
            total = total.add(entry.getAmountWithAdjustment());
        }
        return total;
    }

    public Set<? extends Event> getEventsByEventTypes(Collection<EventType> eventTypes) {
        HashSet<Event> result = new HashSet<Event>();
        for (EventType eventType : eventTypes) {
            for (Event event : this.getAcademicEvents()) {
                if (event.isCancelled() || event.getEventType() != eventType) continue;
                result.add(event);
            }
        }
        return result;
    }

    public Set<? extends Event> getEventsByEventType(EventType eventType) {
        return this.getEventsByEventTypeAndClass(eventType, null);
    }

    public Set<? extends Event> getEventsByEventTypeAndClass(EventType eventType, Class<? extends Event> clazz) {
        HashSet<Event> result = new HashSet<Event>();
        for (Event event : this.getEventsSet()) {
            if (event.isCancelled() || event.getEventType() != eventType || clazz != null && !((Object)((Object)event)).getClass().equals(clazz)) continue;
            result.add(event);
        }
        return result;
    }

    public Set<AnnualEvent> getAnnualEventsFor(ExecutionYear executionYear) {
        HashSet<AnnualEvent> result = new HashSet<AnnualEvent>();
        for (Event event : this.getEventsSet()) {
            AnnualEvent annualEvent;
            if (!(event instanceof AnnualEvent) || !(annualEvent = (AnnualEvent)((Object)event)).isFor(executionYear) || annualEvent.isCancelled()) continue;
            result.add(annualEvent);
        }
        return result;
    }

    public boolean hasInsuranceEventOrAdministrativeOfficeFeeInsuranceEventFor(ExecutionYear executionYear) {
        return this.hasInsuranceEventFor(executionYear) || this.hasAdministrativeOfficeFeeInsuranceEventFor(executionYear);
    }

    public Set<InsuranceEvent> getNotCancelledInsuranceEvents() {
        HashSet<InsuranceEvent> result = new HashSet<InsuranceEvent>();
        for (Event event : this.getEventsByEventType(EventType.INSURANCE)) {
            InsuranceEvent specificEvent = (InsuranceEvent)((Object)event);
            if (specificEvent.isCancelled()) continue;
            result.add(specificEvent);
        }
        return result;
    }

    public Set<InsuranceEvent> getNotCancelledInsuranceEventsUntil(ExecutionYear executionYear) {
        HashSet<InsuranceEvent> result = new HashSet<InsuranceEvent>();
        for (Event event : this.getEventsByEventType(EventType.INSURANCE)) {
            InsuranceEvent specificEvent = (InsuranceEvent)((Object)event);
            if (specificEvent.isCancelled() || !specificEvent.getExecutionYear().isBeforeOrEquals(executionYear)) continue;
            result.add(specificEvent);
        }
        return result;
    }

    public InsuranceEvent getInsuranceEventFor(ExecutionYear executionYear) {
        for (Event event : this.getEventsByEventType(EventType.INSURANCE)) {
            InsuranceEvent insuranceEvent = (InsuranceEvent)((Object)event);
            if (insuranceEvent.isCancelled() || !insuranceEvent.isFor(executionYear)) continue;
            return insuranceEvent;
        }
        return null;
    }

    public boolean hasInsuranceEventFor(ExecutionYear executionYear) {
        return this.getInsuranceEventFor(executionYear) != null;
    }

    public Set<AdministrativeOfficeFeeAndInsuranceEvent> getNotCancelledAdministrativeOfficeFeeAndInsuranceEvents(AdministrativeOffice office) {
        HashSet<AdministrativeOfficeFeeAndInsuranceEvent> result = new HashSet<AdministrativeOfficeFeeAndInsuranceEvent>();
        for (Event event : this.getEventsByEventType(EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE)) {
            AdministrativeOfficeFeeAndInsuranceEvent specificEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
            if (specificEvent.isCancelled() || specificEvent.getAdministrativeOffice() != office) continue;
            result.add(specificEvent);
        }
        return result;
    }

    public Set<AdministrativeOfficeFeeAndInsuranceEvent> getNotCancelledAdministrativeOfficeFeeAndInsuranceEventsUntil(AdministrativeOffice office, ExecutionYear executionYear) {
        HashSet<AdministrativeOfficeFeeAndInsuranceEvent> result = new HashSet<AdministrativeOfficeFeeAndInsuranceEvent>();
        for (Event event : this.getEventsByEventType(EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE)) {
            AdministrativeOfficeFeeAndInsuranceEvent specificEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
            if (specificEvent.isCancelled() || specificEvent.getAdministrativeOffice() != office || !specificEvent.getExecutionYear().isBeforeOrEquals(executionYear)) continue;
            result.add(specificEvent);
        }
        return result;
    }

    public AdministrativeOfficeFeeAndInsuranceEvent getAdministrativeOfficeFeeInsuranceEventFor(ExecutionYear executionYear) {
        for (Event event : this.getEventsByEventType(EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE)) {
            AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
            if (administrativeOfficeFeeAndInsuranceEvent.isCancelled() || !administrativeOfficeFeeAndInsuranceEvent.isFor(executionYear)) continue;
            return administrativeOfficeFeeAndInsuranceEvent;
        }
        return null;
    }

    public boolean hasAdministrativeOfficeFeeInsuranceEventFor(ExecutionYear executionYear) {
        return this.getAdministrativeOfficeFeeInsuranceEventFor(executionYear) != null;
    }

    public Set<Event> getEventsSupportingPaymentByOtherParties() {
        HashSet<Event> result = new HashSet<Event>();
        for (Event event : this.getEventsSet()) {
            if (event.isCancelled() || !event.isOtherPartiesPaymentsSupported()) continue;
            result.add(event);
        }
        return result;
    }

    public List<PaymentCode> getPaymentCodesBy(PaymentCodeType paymentCodeType) {
        ArrayList<PaymentCode> result = new ArrayList<PaymentCode>();
        for (PaymentCode paymentCode : this.getPaymentCodesSet()) {
            if (paymentCode.getType() != paymentCodeType) continue;
            result.add(paymentCode);
        }
        return result;
    }

    public PaymentCode getPaymentCodeBy(String code) {
        for (PaymentCode paymentCode : this.getPaymentCodesSet()) {
            if (!paymentCode.getCode().equals(code)) continue;
            return paymentCode;
        }
        return null;
    }

    public Set<GratuityEvent> getGratuityEvents() {
        return this.getEventsByEventTypes(EventType.getGratuityEventTypes());
    }

    public List<Event> getEventsWithExemptionAppliable() {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.getEventsSet()) {
            if (event.isCancelled() || !event.isExemptionAppliable()) continue;
            result.add(event);
        }
        return result;
    }

    public Money getMaxDeductableAmountForLegalTaxes(EventType eventType, int civilYear) {
        Money result = Money.ZERO;
        for (Event event : this.getEventsByEventType(eventType)) {
            result = result.add(event.getMaxDeductableAmountForLegalTaxes(civilYear));
        }
        return result;
    }

    public Set<Receipt> getReceiptsByAdministrativeOffices(Set<AdministrativeOffice> administrativeOffices) {
        HashSet<Receipt> result = new HashSet<Receipt>();
        for (Receipt receipt : this.getReceiptsSet()) {
            for (AdministrativeOffice administrativeOffice : administrativeOffices) {
                if (!receipt.isFromAdministrativeOffice(administrativeOffice)) continue;
                result.add(receipt);
            }
        }
        return result;
    }

    public final boolean isPerson() {
        return true;
    }

    public final boolean isFemale() {
        return this.getGender() == Gender.FEMALE;
    }

    public final boolean isMale() {
        return this.getGender() == Gender.MALE;
    }

    @Deprecated
    public Set<Registration> getStudents() {
        return this.getStudent() != null ? this.getStudent().getRegistrationsSet() : Collections.emptySet();
    }

    @Deprecated
    public boolean hasAnyStudents() {
        return this.getStudentsCount() > 0;
    }

    @Deprecated
    public int getStudentsCount() {
        return this.getStudent() != null ? this.getStudent().getRegistrationsSet().size() : 0;
    }

    @Deprecated
    public Set<Registration> getStudentsSet() {
        return this.getStudent() != null ? this.getStudent().getRegistrationsSet() : Collections.EMPTY_SET;
    }

    public SortedSet<String> getOrganizationalUnitsPresentation() {
        TreeSet<String> organizationalUnits = new TreeSet<String>();
        for (Accountability accountability : this.getParentsSet()) {
            if (!this.isOrganizationalUnitsForPresentation(accountability)) continue;
            Party party = accountability.getParentParty();
            organizationalUnits.add(party.getName());
        }
        if (this.getStudent() != null) {
            for (Registration registration : this.getStudent().getRegistrationsSet()) {
                DegreeCurricularPlan degreeCurricularPlan;
                if (!registration.isActive() || (degreeCurricularPlan = registration.getLastDegreeCurricularPlan()) == null) continue;
                Degree degree = degreeCurricularPlan.getDegree();
                organizationalUnits.add(degree.getPresentationName());
            }
        }
        return organizationalUnits;
    }

    private boolean isOrganizationalUnitsForPresentation(Accountability accountability) {
        AccountabilityType accountabilityType = accountability.getAccountabilityType();
        AccountabilityTypeEnum accountabilityTypeEnum = accountabilityType.getType();
        return accountabilityTypeEnum == AccountabilityTypeEnum.WORKING_CONTRACT;
    }

    @Deprecated
    public String getNickname() {
        return this.getProfile().getDisplayName();
    }

    public String getHomepageWebAddress() {
        if (this.isDefaultWebAddressVisible() && this.getDefaultWebAddress().hasUrl()) {
            return this.getDefaultWebAddress().getUrl();
        }
        return null;
    }

    @Deprecated
    public boolean hasAvailableWebSite() {
        return this.getAvailableWebSite() != null && this.getAvailableWebSite() != false;
    }

    public Collection<ExecutionDegree> getCoordinatedExecutionDegrees(DegreeCurricularPlan degreeCurricularPlan) {
        TreeSet<ExecutionDegree> result = new TreeSet<ExecutionDegree>(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_YEAR);
        for (Coordinator coordinator : this.getCoordinatorsSet()) {
            if (!coordinator.getExecutionDegree().getDegreeCurricularPlan().equals((Object)degreeCurricularPlan)) continue;
            result.add(coordinator.getExecutionDegree());
        }
        return result;
    }

    public boolean isCoordinatorFor(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionYear) continue;
            return executionDegree.getCoordinatorByTeacher(this) != null;
        }
        return false;
    }

    public boolean isResponsibleOrCoordinatorFor(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        Teacher teacher = this.getTeacher();
        return teacher != null && teacher.isResponsibleFor(curricularCourse, executionSemester) || this.isCoordinatorFor(curricularCourse.getDegreeCurricularPlan(), executionSemester.getExecutionYear());
    }

    public boolean isCoordinatorFor(ExecutionYear executionYear, List<DegreeType> degreeTypes) {
        for (Coordinator coordinator : this.getCoordinatorsSet()) {
            ExecutionDegree executionDegree = coordinator.getExecutionDegree();
            if (executionDegree == null || executionDegree.getExecutionYear() != executionYear || !degreeTypes.contains(executionDegree.getDegree().getDegreeType())) continue;
            return true;
        }
        return false;
    }

    public ServiceAgreement getServiceAgreementFor(ServiceAgreementTemplate serviceAgreementTemplate) {
        for (ServiceAgreement serviceAgreement : this.getServiceAgreementsSet()) {
            if (serviceAgreement.getServiceAgreementTemplate() != serviceAgreementTemplate) continue;
            return serviceAgreement;
        }
        return null;
    }

    public String getFirstAndLastName() {
        String[] name = this.getName().split(" ");
        return name[0] + " " + name[name.length - 1];
    }

    public static Collection<Person> findPerson(String name) {
        return Person.findPerson(name, Integer.MAX_VALUE);
    }

    public static Collection<Person> findPersonMatchingFirstAndLastName(String completeName) {
        if (completeName != null) {
            String[] splittedName = completeName.split(" ");
            return splittedName.length > 0 ? Person.findPerson(splittedName[0] + " " + splittedName[splittedName.length - 1]) : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection<Person> findPersonByDocumentID(String documentIDValue) {
        ArrayList<Person> people = new ArrayList<Person>();
        if (!StringUtils.isEmpty((String)documentIDValue)) {
            for (IdDocument idDocument : IdDocument.find(documentIDValue)) {
                people.add(idDocument.getPerson());
            }
        }
        return people;
    }

    public static Person readPersonByEmailAddress(String email) {
        EmailAddress emailAddress = EmailAddress.find(email);
        return emailAddress != null && emailAddress.getParty().isPerson() ? (Person)((Object)emailAddress.getParty()) : null;
    }

    public boolean hasEmailAddress(String email) {
        for (PartyContact partyContact : this.getPartyContactsSet()) {
            EmailAddress emailAddress;
            if (!partyContact.isEmailAddress() || !(emailAddress = (EmailAddress)((Object)partyContact)).hasValue(email)) continue;
            return true;
        }
        return false;
    }

    public boolean isPhotoAvailableToCurrentUser() {
        return this.isPhotoAvailableToPerson(AccessControl.getPerson());
    }

    public boolean isPhotoAvailableToPerson(Person requester) {
        if (this.isPhotoPubliclyAvailable()) {
            return true;
        }
        return requester != null && RoleType.PERSON.isMember(requester.getUser());
    }

    public Photograph getPersonalPhoto() {
        Photograph photo = super.getPersonalPhoto();
        if (photo == null) {
            return null;
        }
        do {
            if (photo.getState() != PhotoState.APPROVED) continue;
            return photo;
        } while ((photo = photo.getPrevious()) != null);
        return null;
    }

    public Photograph getPersonalPhotoEvenIfPending() {
        Photograph photo = super.getPersonalPhoto();
        if (photo == null) {
            return null;
        }
        do {
            if (photo.getState() == PhotoState.REJECTED || photo.getState() == PhotoState.USER_REJECTED) continue;
            return photo;
        } while ((photo = photo.getPrevious()) != null);
        return null;
    }

    public Photograph getPersonalPhotoEvenIfRejected() {
        return super.getPersonalPhoto();
    }

    public void setPersonalPhoto(Photograph photo) {
        if (super.getPersonalPhoto() != null) {
            photo.setPrevious(super.getPersonalPhoto());
        }
        super.setPersonalPhoto(photo);
        if (photo != null) {
            photo.logCreate(this);
        }
    }

    public List<Photograph> getPhotographHistory() {
        LinkedList<Photograph> history = new LinkedList<Photograph>();
        for (Photograph photo = super.getPersonalPhoto(); photo != null; photo = photo.getPrevious()) {
            history.addFirst(photo);
        }
        return history;
    }

    public boolean isPhotoPubliclyAvailable() {
        return this.getPhotoAvailable();
    }

    public boolean isDefaultEmailVisible() {
        return this.getDefaultEmailAddress() == null ? false : this.getDefaultEmailAddress().getVisibleToPublic();
    }

    public boolean isDefaultWebAddressVisible() {
        return this.getDefaultWebAddress() == null ? false : this.getDefaultWebAddress().getVisibleToPublic();
    }

    @Deprecated
    public Boolean getAvailableEmail() {
        return this.isDefaultEmailVisible();
    }

    @Deprecated
    public void setAvailableEmail(Boolean available) {
        if (this.getDefaultEmailAddress() != null) {
            this.getDefaultEmailAddress().setVisibleToPublic(available);
        }
    }

    @Deprecated
    public Boolean getAvailableWebSite() {
        return this.isDefaultWebAddressVisible();
    }

    @Deprecated
    public void setAvailableWebSite(Boolean available) {
        if (this.getDefaultWebAddress() != null) {
            this.getDefaultWebAddress().setVisibleToPublic(available);
        }
    }

    public String getPresentationName() {
        String username = this.getUsername();
        return username == null ? this.getName() : this.getName() + " (" + this.getUsername() + ")";
    }

    public String getPartyPresentationName() {
        return this.getPresentationName();
    }

    private boolean hasValidIndividualCandidacy(Class<? extends IndividualCandidacy> clazz, ExecutionInterval executionInterval) {
        for (IndividualCandidacyPersonalDetails candidacyDetails : this.getIndividualCandidaciesSet()) {
            IndividualCandidacy candidacy = candidacyDetails.getCandidacy();
            if (candidacy.isCancelled() || !((Object)((Object)candidacy)).getClass().equals(clazz) || !candidacy.isFor(executionInterval)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidOver23IndividualCandidacy(ExecutionInterval executionInterval) {
        return this.hasValidIndividualCandidacy(Over23IndividualCandidacy.class, executionInterval);
    }

    public boolean hasValidSecondCycleIndividualCandidacy(ExecutionInterval executionInterval) {
        return this.hasValidIndividualCandidacy(SecondCycleIndividualCandidacy.class, executionInterval);
    }

    public boolean hasValidDegreeCandidacyForGraduatedPerson(ExecutionInterval executionInterval) {
        return this.hasValidIndividualCandidacy(DegreeCandidacyForGraduatedPerson.class, executionInterval);
    }

    public boolean hasValidStandaloneIndividualCandidacy(ExecutionInterval executionInterval) {
        return this.hasValidIndividualCandidacy(StandaloneIndividualCandidacy.class, executionInterval);
    }

    public List<Formation> getFormations() {
        ArrayList<Formation> formations = new ArrayList<Formation>();
        for (Qualification qualification : this.getAssociatedQualificationsSet()) {
            if (!(qualification instanceof Formation)) continue;
            formations.add((Formation)((Object)qualification));
        }
        return formations;
    }

    public Qualification getLastQualification() {
        return !this.getAssociatedQualificationsSet().isEmpty() ? Collections.max(this.getAssociatedQualificationsSet(), Qualification.COMPARATOR_BY_YEAR) : null;
    }

    public Set<AnnualIRSDeclarationDocument> getAnnualIRSDocuments() {
        HashSet<AnnualIRSDeclarationDocument> result = new HashSet<AnnualIRSDeclarationDocument>();
        for (GeneratedDocument each : this.getAddressedDocumentSet()) {
            if (!(each instanceof AnnualIRSDeclarationDocument)) continue;
            result.add((AnnualIRSDeclarationDocument)((Object)each));
        }
        return result;
    }

    public AnnualIRSDeclarationDocument getAnnualIRSDocumentFor(Integer year) {
        for (AnnualIRSDeclarationDocument each : this.getAnnualIRSDocuments()) {
            if (!each.getYear().equals(year)) continue;
            return each;
        }
        return null;
    }

    public boolean hasAnnualIRSDocumentFor(Integer year) {
        return this.getAnnualIRSDocumentFor(year) != null;
    }

    public boolean hasAnyAdministrativeOfficeFeeAndInsuranceEventInDebt() {
        for (Event event : this.getEventsByEventType(EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPastAdministrativeOfficeFeeAndInsuranceEventInDebt() {
        for (Event event : this.getEventsByEventType(EventType.ADMINISTRATIVE_OFFICE_FEE_INSURANCE)) {
            AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event);
            if (!(administrativeOfficeFeeAndInsuranceEvent instanceof PastAdministrativeOfficeFeeAndInsuranceEvent) || !event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyResidencePaymentsInDebtForPreviousYear() {
        int previousYear = new LocalDate().minusYears(1).getYear();
        for (Event event : this.getResidencePaymentEvents()) {
            ResidenceEvent residenceEvent = (ResidenceEvent)((Object)event);
            if (!residenceEvent.isFor(previousYear) || residenceEvent.isCancelled() || residenceEvent.isPayed()) continue;
            return true;
        }
        return false;
    }

    public Professorship getProfessorshipByExecutionCourse(ExecutionCourse executionCourse) {
        return this.getProfessorshipsSet().stream().filter(prof -> prof.getExecutionCourse().equals((Object)executionCourse)).findAny().orElse(null);
    }

    public boolean hasProfessorshipForExecutionCourse(ExecutionCourse executionCourse) {
        return this.getProfessorshipByExecutionCourse(executionCourse) != null;
    }

    public Set<PhdAlertMessage> getUnreadedPhdAlertMessages() {
        HashSet<PhdAlertMessage> result = new HashSet<PhdAlertMessage>();
        for (PhdAlertMessage message : this.getPhdAlertMessagesSet()) {
            if (message.isReaded()) continue;
            result.add(message);
        }
        return result;
    }

    public boolean isPhdStudent() {
        return !this.getPhdIndividualProgramProcessesSet().isEmpty();
    }

    public RegistrationProtocol getOnlyRegistrationProtocol() {
        if (this.getRegistrationProtocolsSet().size() == 1) {
            return (RegistrationProtocol)this.getRegistrationProtocolsSet().iterator().next();
        }
        return null;
    }

    public List<Professorship> getProfessorships(ExecutionSemester executionSemester) {
        ArrayList<Professorship> professorships = new ArrayList<Professorship>();
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (!professorship.getExecutionCourse().getExecutionPeriod().equals(executionSemester)) continue;
            professorships.add(professorship);
        }
        return professorships;
    }

    public List<Professorship> getProfessorships(ExecutionYear executionYear) {
        ArrayList<Professorship> professorships = new ArrayList<Professorship>();
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (!professorship.getExecutionCourse().getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
            professorships.add(professorship);
        }
        return professorships;
    }

    public boolean teachesAny(Collection<ExecutionCourse> executionCourses) {
        for (Professorship professorship : this.getProfessorshipsSet()) {
            if (!executionCourses.contains((Object)professorship.getExecutionCourse())) continue;
            return true;
        }
        return false;
    }

    public boolean isTeacherEvaluationCoordinatorCouncilMember() {
        PersistentGroup group = Bennu.getInstance().getTeacherEvaluationCoordinatorCouncil();
        return group != null ? group.isMember(Authenticate.getUser()) : false;
    }

    public EmailAddress getEmailAddressForSendingEmails() {
        Boolean disableSendEmails = this.getDisableSendEmails();
        if (disableSendEmails != null && disableSendEmails.booleanValue()) {
            return null;
        }
        EmailAddress defaultEmailAddress = this.getDefaultEmailAddress();
        if (defaultEmailAddress != null) {
            return defaultEmailAddress;
        }
        EmailAddress institutionalEmailAddress = this.getInstitutionalEmailAddress();
        if (institutionalEmailAddress != null) {
            return institutionalEmailAddress;
        }
        for (PartyContact partyContact : this.getPartyContactsSet()) {
            if (!partyContact.isEmailAddress() || !partyContact.isActiveAndValid() || !partyContact.isValid()) continue;
            EmailAddress otherEmailAddress = (EmailAddress)((Object)partyContact);
            return otherEmailAddress;
        }
        return null;
    }

    public String getEmailForSendingEmails() {
        EmailAddress emailAddress = this.getEmailAddressForSendingEmails();
        return emailAddress == null ? null : emailAddress.getValue();
    }

    public boolean areContactsRecent(Class<? extends PartyContact> contactClass, int daysNotUpdated) {
        List partyContacts = this.getPartyContacts(contactClass);
        boolean isUpdated = false;
        for (PartyContact partyContact : partyContacts) {
            DateTime now;
            if (partyContact.getLastModifiedDate() == null) {
                isUpdated = isUpdated;
                continue;
            }
            DateTime lastModifiedDate = partyContact.getLastModifiedDate();
            Months months = Months.monthsBetween((ReadableInstant)lastModifiedDate, (ReadableInstant)(now = new DateTime()));
            if (months.getMonths() > daysNotUpdated) {
                isUpdated = isUpdated;
                continue;
            }
            if (!isUpdated) {
                // empty if block
            }
            isUpdated = true;
        }
        return isUpdated;
    }

    @Deprecated
    public String getFiscalCode() {
        return super.getFiscalCode();
    }

    @Deprecated
    public void setFiscalCode(String value) {
        super.setFiscalCode(value);
    }

    public static Person findByUsername(String username) {
        User user = User.findByUsername((String)username);
        return user == null ? null : user.getPerson();
    }

    public String getIdentificationDocumentExtraDigitValue() {
        PersonIdentificationDocumentExtraInfo result = this.getPersonIdentificationDocumentExtraInfo(IdentificationDocumentExtraDigit.class);
        return result != null ? result.getValue() : null;
    }

    public String getIdentificationDocumentSeriesNumberValue() {
        PersonIdentificationDocumentExtraInfo result = this.getPersonIdentificationDocumentExtraInfo(IdentificationDocumentSeriesNumber.class);
        return result != null ? result.getValue() : null;
    }

    public PersonIdentificationDocumentExtraInfo getPersonIdentificationDocumentExtraInfo(Class clazz) {
        PersonIdentificationDocumentExtraInfo result = null;
        for (PersonIdentificationDocumentExtraInfo info : this.getPersonIdentificationDocumentExtraInfoSet()) {
            if (((Object)((Object)info)).getClass() != clazz || result != null && !result.getRegisteredInSystemTimestamp().isBefore((ReadableInstant)info.getRegisteredInSystemTimestamp())) continue;
            result = info;
        }
        return result == null ? null : result;
    }

    public void setIdentificationDocumentSeriesNumber(String identificationDocumentSeriesNumber) {
        if (!StringUtils.isEmpty((String)identificationDocumentSeriesNumber)) {
            if (identificationDocumentSeriesNumber.trim().length() == 1) {
                PersonIdentificationDocumentExtraInfo personIdentificationDocumentExtraInfo = this.getPersonIdentificationDocumentExtraInfo(IdentificationDocumentExtraDigit.class);
                if (personIdentificationDocumentExtraInfo == null) {
                    new IdentificationDocumentExtraDigit(this, identificationDocumentSeriesNumber);
                } else {
                    personIdentificationDocumentExtraInfo.setValue(identificationDocumentSeriesNumber);
                }
            } else {
                PersonIdentificationDocumentExtraInfo personIdentificationDocumentExtraInfo = this.getPersonIdentificationDocumentExtraInfo(IdentificationDocumentSeriesNumber.class);
                if (personIdentificationDocumentExtraInfo == null) {
                    new IdentificationDocumentSeriesNumber(this, identificationDocumentSeriesNumber);
                } else {
                    personIdentificationDocumentExtraInfo.setValue(identificationDocumentSeriesNumber);
                }
            }
        }
    }

    public void setIdentificationDocumentExtraDigit(String identificationDocumentExtraDigit) {
        if (!StringUtils.isEmpty((String)identificationDocumentExtraDigit)) {
            PersonIdentificationDocumentExtraInfo personIdentificationDocumentExtraInfo = this.getPersonIdentificationDocumentExtraInfo(IdentificationDocumentExtraDigit.class);
            if (personIdentificationDocumentExtraInfo == null) {
                new IdentificationDocumentExtraDigit(this, identificationDocumentExtraDigit);
            } else {
                personIdentificationDocumentExtraInfo.setValue(identificationDocumentExtraDigit);
            }
        }
    }

    public void setNumberOfValidationRequests(Integer n) {
        Object object = advice$setNumberOfValidationRequests.perform((Callable)new Person$callable$setNumberOfValidationRequests(this, n));
    }

    static /* synthetic */ void advised$setNumberOfValidationRequests(Person this_, Integer numberOfValidationRequests) {
        super.setNumberOfValidationRequests(numberOfValidationRequests);
    }

    public boolean getCanValidateContacts() {
        DateTime now = new DateTime();
        DateTime requestDate = this.getLastValidationRequestDate();
        if (requestDate == null || this.getNumberOfValidationRequests() == null) {
            return true;
        }
        DateTime plus30 = requestDate.plusDays(30);
        if (now.isAfter((ReadableInstant)plus30) || now.isEqual((ReadableInstant)plus30)) {
            this.setNumberOfValidationRequests(0);
        }
        return this.getNumberOfValidationRequests() <= MAX_VALIDATION_REQUESTS;
    }

    public void incValidationRequest() {
        Object object = advice$incValidationRequest.perform((Callable)new Person$callable$incValidationRequest(this));
    }

    static /* synthetic */ void advised$incValidationRequest(Person this_) {
        this_.getCanValidateContacts();
        Integer numberOfValidationRequests = this_.getNumberOfValidationRequests();
        numberOfValidationRequests = numberOfValidationRequests == null ? 0 : numberOfValidationRequests;
        if (numberOfValidationRequests <= MAX_VALIDATION_REQUESTS) {
            this_.setNumberOfValidationRequests(numberOfValidationRequests + 1);
            this_.setLastValidationRequestDate(new DateTime());
        }
    }

    public Integer getNumberOfValidationRequests() {
        Integer numberOfValidationRequests = super.getNumberOfValidationRequests();
        if (numberOfValidationRequests == null) {
            return 0;
        }
        return numberOfValidationRequests;
    }

    public boolean isOptOutAvailable() {
        Group optOutGroup = Bennu.getInstance().getSystemSender().getOptOutGroup();
        return optOutGroup.isMember(this.getUser());
    }

    @Deprecated
    public Date getDateOfBirth() {
        YearMonthDay ymd = this.getDateOfBirthYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public Date getEmissionDateOfDocumentId() {
        YearMonthDay ymd = this.getEmissionDateOfDocumentIdYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public Date getExpirationDateOfDocumentId() {
        YearMonthDay ymd = this.getExpirationDateOfDocumentIdYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    private void logSetter(String keyTypeOfData, String oldValue, String newValue, String keyLabel) {
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(this);
        if (oldValue.compareTo(newValue) != 0) {
            String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)keyLabel, (String[])new String[0]);
            String typeOfData = BundleUtil.getString((String)"resources.MessagingResources", (String)keyTypeOfData, (String[])new String[0]);
            PersonInformationLog.createLog(this, "resources.MessagingResources", "log.personInformation.edit.generalTemplate", typeOfData, infoLabel, personViewed, oldValue);
        }
    }

    private void logSetterNullString(String keyInfoType, String oldValue, String newValue, String keyLabel) {
        String argOld = this.valueToUpdateIfNewNotNull(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]), oldValue);
        String argNew = this.valueToUpdateIfNewNotNull(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]), newValue);
        this.logSetter(keyInfoType, argOld, argNew, keyLabel);
    }

    private void logSetterNullYearMonthDay(String keyInfoType, YearMonthDay oldValue, YearMonthDay newValue, String keyLabel) {
        Object argOld = this.valueToUpdateIfNewNotNull((Object)BundleUtil.getString((String)"resources.HtmlaltResources", (String)"text.dateEmpty", (String[])new String[0]), oldValue);
        Object argNew = this.valueToUpdateIfNewNotNull((Object)BundleUtil.getString((String)"resources.HtmlaltResources", (String)"text.dateEmpty", (String[])new String[0]), newValue);
        String strOld = argOld instanceof YearMonthDay ? ((YearMonthDay)argOld).toString("yyyy/MM/dd") : (String)argOld;
        String strNew = argNew instanceof YearMonthDay ? ((YearMonthDay)argNew).toString("yyyy/MM/dd") : (String)argNew;
        this.logSetter(keyInfoType, strOld, strNew, keyLabel);
    }

    private void logSetterNullEnum(String keyInfoType, IPresentableEnum oldValue, IPresentableEnum newValue, String keyLabel) {
        Object argOld = this.valueToUpdateIfNewNotNull((Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]), oldValue);
        Object argNew = this.valueToUpdateIfNewNotNull((Object)BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]), newValue);
        String strOld = argOld instanceof Enum ? ((IPresentableEnum)argOld).getLocalizedName() : (String)argOld;
        String strNew = argNew instanceof Enum ? ((IPresentableEnum)argNew).getLocalizedName() : (String)argNew;
        this.logSetter(keyInfoType, strOld, strNew, keyLabel);
    }

    public void setGender(Gender arg) {
        this.logSetterNullEnum("log.personInformation.edit.generalTemplate.personalData", this.getGender(), arg, "label.gender");
        super.setGender(arg);
    }

    public void setProfession(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.personalData", this.getProfession(), arg, "label.occupation");
        super.setProfession(arg);
    }

    public void setMaritalStatus(MaritalStatus arg) {
        MaritalStatus argToSet = arg != null ? arg : MaritalStatus.UNKNOWN;
        this.logSetterNullEnum("log.personInformation.edit.generalTemplate.personalData", this.getMaritalStatus(), argToSet, "label.maritalStatus");
        super.setMaritalStatus(argToSet);
    }

    public void setEmissionLocationOfDocumentId(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.personalId", this.getEmissionLocationOfDocumentId(), arg, "label.documentIdEmissionLocation");
        super.setEmissionLocationOfDocumentId(arg);
    }

    public void setEmissionDateOfDocumentIdYearMonthDay(YearMonthDay arg) {
        this.logSetterNullYearMonthDay("log.personInformation.edit.generalTemplate.personalId", this.getEmissionDateOfDocumentIdYearMonthDay(), arg, "label.documentIdEmissionDate");
        super.setEmissionDateOfDocumentIdYearMonthDay(arg);
    }

    public void setExpirationDateOfDocumentIdYearMonthDay(YearMonthDay arg) {
        this.logSetterNullYearMonthDay("log.personInformation.edit.generalTemplate.personalId", this.getExpirationDateOfDocumentIdYearMonthDay(), arg, "label.documentIdExpirationDate");
        super.setExpirationDateOfDocumentIdYearMonthDay(arg);
    }

    public void setSocialSecurityNumber(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.personalId", this.getSocialSecurityNumber(), arg, "label.socialSecurityNumber");
        super.setSocialSecurityNumber(arg);
    }

    public void setEidentifier(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.personalId", this.getEidentifier(), arg, "label.eidentifier");
        super.setEidentifier(arg);
    }

    public void setDateOfBirthYearMonthDay(YearMonthDay arg) {
        this.logSetterNullYearMonthDay("log.personInformation.edit.generalTemplate.filiation", this.getDateOfBirthYearMonthDay(), arg, "label.dateOfBirth");
        super.setDateOfBirthYearMonthDay(arg);
    }

    public void setCountry(Country arg) {
        String argOld = this.getCountry() != null ? (this.getCountry().getCountryNationality() != null ? this.getCountry().getCountryNationality().getContent() : this.getCountry().getName()) : BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]);
        String argNew = arg != null ? (arg.getCountryNationality() != null ? arg.getCountryNationality().getContent() : arg.getName()) : BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]);
        super.setCountry(arg);
        this.logSetter("log.personInformation.edit.generalTemplate.filiation", argOld, argNew, "label.nationality");
    }

    public void setParishOfBirth(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.filiation", this.getParishOfBirth(), arg, "label.parishOfBirth");
        super.setParishOfBirth(arg);
    }

    public void setDistrictSubdivisionOfBirth(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.filiation", this.getDistrictSubdivisionOfBirth(), arg, "label.districtSubdivisionOfBirth");
        super.setDistrictSubdivisionOfBirth(arg);
    }

    public void setDistrictOfBirth(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.filiation", this.getDistrictOfBirth(), arg, "label.districtOfBirth");
        super.setDistrictOfBirth(arg);
    }

    public void setCountryOfBirth(Country arg) {
        String argOld = this.getCountryOfBirth() != null ? this.getCountryOfBirth().getName() : BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]);
        String argNew = arg != null ? arg.getName() : BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]);
        super.setCountryOfBirth(arg);
        this.logSetter("log.personInformation.edit.generalTemplate.filiation", argOld, argNew, "label.countryOfBirth");
    }

    public void setNameOfMother(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.filiation", this.getNameOfMother(), arg, "label.nameOfMother");
        super.setNameOfMother(arg);
    }

    public void setNameOfFather(String arg) {
        this.logSetterNullString("log.personInformation.edit.generalTemplate.filiation", this.getNameOfFather(), arg, "label.nameOfFather");
        super.setNameOfFather(arg);
    }

    public void logCreateContact(PartyContact contact) {
        contact.logCreate(this);
    }

    public void logEditContact(PartyContact contact, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
        contact.logEdit(this, propertiesChanged, valueChanged, createdNewContact, newValue);
    }

    public void logDeleteContact(PartyContact contact) {
        contact.logDelete(this);
    }

    public void logValidContact(PartyContact contact) {
        contact.logValid(this);
    }

    public void logRefuseContact(PartyContact contact) {
        contact.logRefuse(this);
    }

    public static Set<User> convertToUsers(Collection<Person> persons) {
        return persons.stream().map(Person_Base::getUser).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    static {
        advice$setNumberOfValidationRequests = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$incValidationRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        MAX_VALIDATION_REQUESTS = 5;
    }
}

