/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum EntryPhase {
    FIRST_PHASE(1),
    SECOND_PHASE(2),
    THIRD_PHASE(3);

    private int phaseNumber;

    private EntryPhase(int phaseNumber) {
        this.phaseNumber = phaseNumber;
    }

    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.name();
    }

    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public int getPhaseNumber() {
        return this.phaseNumber;
    }

    public static EntryPhase valueOf(int phaseNumber) {
        for (EntryPhase phase : EntryPhase.values()) {
            if (phase.phaseNumber != phaseNumber) continue;
            return phase;
        }
        return null;
    }
}

