/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.departmentAdmOffice;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.dto.directiveCouncil.DepartmentSummaryElement;
import org.fenixedu.academic.dto.directiveCouncil.DetailSummaryElement;
import org.fenixedu.academic.dto.directiveCouncil.ExecutionCourseSummaryElement;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.util.Pair;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=AcademicAdministrationApplication.class, path="summaries-control", titleKey="link.summaries.control", bundle="ApplicationResources", accessGroup="academic(SUMMARIES_CONTROL)")
@Mapping(path="/summariesControl")
@Forward(name="success", path="/departmentAdmOffice/summariesControl/listTeacherSummariesControl.jsp")
public final class SummariesControlAction
extends FenixDispatchAction {
    private final BigDecimal EMPTY = BigDecimal.ZERO;

    @EntryPoint
    public ActionForward prepareSummariesControl(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentSummaryElement departmentSummaryElement = new DepartmentSummaryElement(null, null);
        request.setAttribute("executionSemesters", (Object)departmentSummaryElement);
        return mapping.findForward("success");
    }

    public ActionForward listSummariesControl(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentSummaryElement departmentSummaryElement = (DepartmentSummaryElement)this.getRenderedObject();
        String executionSemesterID = null;
        if (departmentSummaryElement != null) {
            executionSemesterID = departmentSummaryElement.getExecutionSemester().getExternalId();
        } else {
            executionSemesterID = (String)this.getFromRequest(request, "executionSemesterID");
            ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionSemesterID);
            departmentSummaryElement = new DepartmentSummaryElement(null, executionSemester);
        }
        request.setAttribute("executionSemesters", (Object)departmentSummaryElement);
        this.setAllDepartmentsSummaryResume(request, executionSemesterID);
        return mapping.findForward("success");
    }

    public ActionForward listDepartmentSummariesControl(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentSummaryElement departmentSummaryElement = (DepartmentSummaryElement)this.getRenderedObject();
        DepartmentSummaryElement.SummaryControlCategory summaryControlCategory = departmentSummaryElement.getSummaryControlCategory();
        departmentSummaryElement = this.getDepartmentSummaryResume(departmentSummaryElement.getExecutionSemester(), departmentSummaryElement.getDepartment());
        departmentSummaryElement.setSummaryControlCategory(summaryControlCategory);
        request.setAttribute("departmentResume", (Object)departmentSummaryElement);
        ArrayList<DepartmentSummaryElement> departmentList = new ArrayList<DepartmentSummaryElement>();
        departmentList.add(departmentSummaryElement);
        request.setAttribute("departmentResumeList", departmentList);
        RenderUtils.invalidateViewState();
        return mapping.findForward("success");
    }

    public ActionForward departmentSummariesResume(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String departmentID = request.getParameter("departmentID");
        String executionPeriodID = request.getParameter("executionSemesterID");
        String categoryControl = (String)this.getFromRequest(request, "categoryControl");
        DepartmentSummaryElement.SummaryControlCategory summaryControlCategory = null;
        if (!StringUtils.isEmpty((String)categoryControl)) {
            summaryControlCategory = DepartmentSummaryElement.SummaryControlCategory.valueOf(categoryControl);
        }
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodID);
        Department department = (Department)FenixFramework.getDomainObject((String)departmentID);
        DepartmentSummaryElement departmentSummaryResume = this.getDepartmentSummaryResume(executionSemester, department);
        departmentSummaryResume.setSummaryControlCategory(summaryControlCategory);
        request.setAttribute("departmentResume", (Object)departmentSummaryResume);
        ArrayList<DepartmentSummaryElement> departmentList = new ArrayList<DepartmentSummaryElement>();
        departmentList.add(departmentSummaryResume);
        request.setAttribute("departmentResumeList", departmentList);
        return mapping.findForward("success");
    }

    public ActionForward executionCourseSummariesControl(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String departmentID = (String)this.getFromRequest(request, "departmentID");
        String categoryControl = (String)this.getFromRequest(request, "categoryControl");
        String executionCourseId = (String)this.getFromRequest(request, "executionCourseID");
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        List<DetailSummaryElement> executionCoursesResume = this.getExecutionCourseResume(executionCourse.getExecutionPeriod(), executionCourse.getProfessorshipsSet());
        request.setAttribute("departmentID", (Object)departmentID);
        request.setAttribute("categoryControl", (Object)categoryControl);
        request.setAttribute("executionCourse", (Object)executionCourse);
        request.setAttribute("executionCoursesResume", executionCoursesResume);
        return mapping.findForward("success");
    }

    public ActionForward teacherSummariesControl(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String departmentID = (String)this.getFromRequest(request, "departmentID");
        String categoryControl = (String)this.getFromRequest(request, "categoryControl");
        String executionSemesterId = (String)this.getFromRequest(request, "executionSemesterID");
        String personId = (String)this.getFromRequest(request, "personID");
        Person person = (Person)FenixFramework.getDomainObject((String)personId);
        ArrayList<Pair<ExecutionSemester, List<DetailSummaryElement>>> last4SemestersSummaryControl = new ArrayList<Pair<ExecutionSemester, List<DetailSummaryElement>>>();
        ExecutionSemester executionSemesterToPresent = ExecutionSemester.readActualExecutionSemester();
        List<DetailSummaryElement> executionCoursesResume = this.getExecutionCourseResume(executionSemesterToPresent, person.getProfessorships(executionSemesterToPresent));
        last4SemestersSummaryControl.add(new Pair<ExecutionSemester, List<DetailSummaryElement>>(executionSemesterToPresent, executionCoursesResume));
        for (int iter = 0; iter < 3; ++iter) {
            executionSemesterToPresent = executionSemesterToPresent.getPreviousExecutionPeriod();
            executionCoursesResume = this.getExecutionCourseResume(executionSemesterToPresent, person.getProfessorships(executionSemesterToPresent));
            last4SemestersSummaryControl.add(new Pair<ExecutionSemester, List<DetailSummaryElement>>(executionSemesterToPresent, executionCoursesResume));
        }
        request.setAttribute("last4SemestersSummaryControl", last4SemestersSummaryControl);
        request.setAttribute("person", (Object)person);
        request.setAttribute("departmentID", (Object)departmentID);
        request.setAttribute("categoryControl", (Object)categoryControl);
        request.setAttribute("executionSemesterID", (Object)executionSemesterId);
        return mapping.findForward("success");
    }

    private List<DetailSummaryElement> getExecutionCourseResume(ExecutionSemester executionSemester, Collection<Professorship> professorships) {
        ArrayList<DetailSummaryElement> allListElements = new ArrayList<DetailSummaryElement>();
        LocalDate today = new LocalDate();
        LocalDate oneWeekBeforeToday = today.minusDays(8);
        for (Professorship professorship : professorships) {
            BigDecimal summariesGiven = this.EMPTY;
            BigDecimal notTaughtSummaries = this.EMPTY;
            if (!professorship.belongsToExecutionPeriod(executionSemester)) continue;
            for (Shift shift : professorship.getExecutionCourse().getAssociatedShifts()) {
                summariesGiven = this.getSummariesGiven(professorship, shift, summariesGiven, oneWeekBeforeToday);
                notTaughtSummaries = this.getNotTaughtSummaries(professorship, shift, notTaughtSummaries, oneWeekBeforeToday);
            }
            summariesGiven = summariesGiven.setScale(1, RoundingMode.HALF_UP);
            notTaughtSummaries = notTaughtSummaries.setScale(1, RoundingMode.HALF_UP);
            Teacher teacher = professorship.getTeacher();
            String categoryName = null;
            if (teacher != null) {
                Optional<TeacherAuthorization> authorization = teacher.getTeacherAuthorization(executionSemester.getAcademicInterval());
                categoryName = authorization.isPresent() ? authorization.get().getTeacherCategory().getName().getContent() : null;
            }
            String siglas = this.getSiglas(professorship);
            String teacherEmail = professorship.getPerson().getDefaultEmailAddress() != null ? professorship.getPerson().getDefaultEmailAddress().getPresentationValue() : null;
            DetailSummaryElement listElementDTO = new DetailSummaryElement(professorship.getPerson().getName(), professorship.getExecutionCourse().getNome(), teacher != null ? teacher.getTeacherId() : null, teacherEmail, categoryName, summariesGiven, notTaughtSummaries, siglas);
            allListElements.add(listElementDTO);
        }
        return allListElements;
    }

    private void setAllDepartmentsSummaryResume(HttpServletRequest request, String executionPeriodOID) throws FenixServiceException {
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodOID);
        ArrayList<DepartmentSummaryElement> allDepartmentsSummariesResume = new ArrayList<DepartmentSummaryElement>();
        for (Department department : rootDomainObject.getDepartmentsSet()) {
            DepartmentSummaryElement departmentSummariesElement = this.getDepartmentSummaryResume(executionSemester, department);
            allDepartmentsSummariesResume.add(departmentSummariesElement);
        }
        if (executionSemester.isCurrent()) {
            LocalDate oneWeekBeforeDate = new LocalDate();
            request.setAttribute("currentSemester", (Object)"true");
            request.setAttribute("oneWeekBeforeDate", (Object)oneWeekBeforeDate.minusDays(8));
        }
        Collections.sort(allDepartmentsSummariesResume, new BeanComparator("department.realName"));
        request.setAttribute("summariesResumeMap", allDepartmentsSummariesResume);
    }

    private DepartmentSummaryElement getDepartmentSummaryResume(ExecutionSemester executionSemester, Department department) {
        DepartmentSummaryElement departmentSummariesElement = new DepartmentSummaryElement(department, executionSemester);
        Set<ExecutionCourse> allDepartmentExecutionCourses = this.getDepartmentExecutionCourses(department, executionSemester);
        if (allDepartmentExecutionCourses != null) {
            LocalDate today = new LocalDate();
            LocalDate oneWeekBeforeToday = today.minusDays(8);
            for (ExecutionCourse executionCourse : allDepartmentExecutionCourses) {
                ExecutionCourseSummaryElement executionCourseSummaryElement;
                int[] instanceLessonsTotal = new int[]{0, 0, 0};
                for (Shift shift : executionCourse.getAssociatedShifts()) {
                    this.getInstanceLessonsTotalsByShift(shift, instanceLessonsTotal, oneWeekBeforeToday);
                }
                BigDecimal result = BigDecimal.valueOf(0L);
                BigDecimal numberOfLessonInstances = BigDecimal.valueOf(instanceLessonsTotal[0]);
                BigDecimal numberOfLessonInstancesWithSummary = BigDecimal.valueOf(0L);
                BigDecimal percentageOfLessonsWithNotTaughtSummary = BigDecimal.valueOf(0L);
                BigDecimal numberOfLessonInstancesWithNotTaughtSummary = BigDecimal.valueOf(0L);
                if (instanceLessonsTotal[0] == 0) continue;
                if (instanceLessonsTotal[1] != 0) {
                    numberOfLessonInstancesWithSummary = BigDecimal.valueOf(instanceLessonsTotal[1]);
                    result = numberOfLessonInstancesWithSummary.divide(numberOfLessonInstances, 3, 2).multiply(BigDecimal.valueOf(100L));
                }
                if (instanceLessonsTotal[2] != 0) {
                    numberOfLessonInstancesWithNotTaughtSummary = BigDecimal.valueOf(instanceLessonsTotal[2]);
                    percentageOfLessonsWithNotTaughtSummary = numberOfLessonInstancesWithNotTaughtSummary.divide(numberOfLessonInstances, 3, 2).multiply(BigDecimal.valueOf(100L));
                }
                DepartmentSummaryElement.SummaryControlCategory resumeClassification = this.getResumeClassification(result);
                Map<DepartmentSummaryElement.SummaryControlCategory, List<ExecutionCourseSummaryElement>> departmentResumeMap = departmentSummariesElement.getExecutionCoursesResume();
                List<ExecutionCourseSummaryElement> executionCoursesSummary = null;
                if (departmentResumeMap == null) {
                    departmentResumeMap = new HashMap<DepartmentSummaryElement.SummaryControlCategory, List<ExecutionCourseSummaryElement>>();
                    executionCoursesSummary = new ArrayList<ExecutionCourseSummaryElement>();
                    executionCourseSummaryElement = new ExecutionCourseSummaryElement(executionCourse, numberOfLessonInstances, numberOfLessonInstancesWithSummary, result, numberOfLessonInstancesWithNotTaughtSummary, percentageOfLessonsWithNotTaughtSummary);
                    executionCoursesSummary.add(executionCourseSummaryElement);
                    departmentResumeMap.put(resumeClassification, executionCoursesSummary);
                    departmentSummariesElement.setExecutionCoursesResume(departmentResumeMap);
                    continue;
                }
                executionCoursesSummary = departmentResumeMap.get((Object)resumeClassification);
                if (executionCoursesSummary == null) {
                    executionCoursesSummary = new ArrayList<ExecutionCourseSummaryElement>();
                    executionCourseSummaryElement = new ExecutionCourseSummaryElement(executionCourse, numberOfLessonInstances, numberOfLessonInstancesWithSummary, result, numberOfLessonInstancesWithNotTaughtSummary, percentageOfLessonsWithNotTaughtSummary);
                    executionCoursesSummary.add(executionCourseSummaryElement);
                    departmentResumeMap.put(resumeClassification, executionCoursesSummary);
                    continue;
                }
                executionCourseSummaryElement = new ExecutionCourseSummaryElement(executionCourse, numberOfLessonInstances, numberOfLessonInstancesWithSummary, result, numberOfLessonInstancesWithNotTaughtSummary, percentageOfLessonsWithNotTaughtSummary);
                executionCoursesSummary.add(executionCourseSummaryElement);
            }
        }
        return departmentSummariesElement;
    }

    private Set<ExecutionCourse> getDepartmentExecutionCourses(Department department, ExecutionSemester executionSemester) {
        HashSet<ExecutionCourse> executionCourses = new HashSet<ExecutionCourse>();
        List<Teacher> allDepartmentTeachers = department.getAllTeachers(executionSemester);
        for (Teacher teacher : allDepartmentTeachers) {
            for (Professorship professorship : teacher.getProfessorships()) {
                if (!professorship.belongsToExecutionPeriod(executionSemester) || professorship.getExecutionCourse().isMasterDegreeDFAOrDEAOnly()) continue;
                executionCourses.add(professorship.getExecutionCourse());
            }
        }
        return executionCourses;
    }

    private DepartmentSummaryElement.SummaryControlCategory getResumeClassification(BigDecimal result) {
        if (result.compareTo(BigDecimal.valueOf(20L)) < 0) {
            return DepartmentSummaryElement.SummaryControlCategory.BETWEEN_0_20;
        }
        if (result.compareTo(BigDecimal.valueOf(40L)) < 0) {
            return DepartmentSummaryElement.SummaryControlCategory.BETWEEN_20_40;
        }
        if (result.compareTo(BigDecimal.valueOf(60L)) < 0) {
            return DepartmentSummaryElement.SummaryControlCategory.BETWEEN_40_60;
        }
        if (result.compareTo(BigDecimal.valueOf(80L)) < 0) {
            return DepartmentSummaryElement.SummaryControlCategory.BETWEEN_60_80;
        }
        return DepartmentSummaryElement.SummaryControlCategory.BETWEEN_80_100;
    }

    private void getInstanceLessonsTotalsByShift(Shift shift, int[] instanceLessonsTotals, LocalDate oneWeekBeforeToday) {
        int numberOfPossibleInstanceLessons = 0;
        int numberOfInstanceLessonsWithSummary = 0;
        int numberOfInstanceLessonsWithNotTaughtSummary = 0;
        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
            List<LessonInstance> allLessonInstanceUntil = lesson.getAllLessonInstancesUntil(oneWeekBeforeToday);
            SortedSet<YearMonthDay> allPossibleDates = lesson.getAllLessonDatesUntil(new YearMonthDay((Object)oneWeekBeforeToday));
            numberOfPossibleInstanceLessons += allPossibleDates.size();
            for (LessonInstance lessonInstance : allLessonInstanceUntil) {
                if (lessonInstance.getSummary() == null) continue;
                ++numberOfInstanceLessonsWithSummary;
                if (lessonInstance.getSummary().getTaught() == null || lessonInstance.getSummary().getTaught().booleanValue()) continue;
                ++numberOfInstanceLessonsWithNotTaughtSummary;
            }
        }
        instanceLessonsTotals[0] = instanceLessonsTotals[0] + numberOfPossibleInstanceLessons;
        instanceLessonsTotals[1] = instanceLessonsTotals[1] + numberOfInstanceLessonsWithSummary;
        instanceLessonsTotals[2] = instanceLessonsTotals[2] + numberOfInstanceLessonsWithNotTaughtSummary;
    }

    private BigDecimal getSummariesGiven(Professorship professorship, Shift shift, BigDecimal summariesGiven, LocalDate oneWeekBeforeToday) {
        for (Summary summary : shift.getAssociatedSummariesSet()) {
            if (summary.getProfessorship() == null || summary.getProfessorship() != professorship || summary.getIsExtraLesson().booleanValue() || summary.getLessonInstance().getBeginDateTime().toLocalDate().isAfter((ReadablePartial)oneWeekBeforeToday)) continue;
            summariesGiven = summariesGiven.add(BigDecimal.ONE);
        }
        return summariesGiven;
    }

    private BigDecimal getNotTaughtSummaries(Professorship professorship, Shift shift, BigDecimal notTaughtSummaries, LocalDate oneWeekBeforeToday) {
        for (Summary summary : shift.getAssociatedSummariesSet()) {
            if (summary.getProfessorship() == null || summary.getProfessorship() != professorship || summary.getIsExtraLesson().booleanValue() || summary.getLessonInstance().getBeginDateTime().toLocalDate().isAfter((ReadablePartial)oneWeekBeforeToday) || summary.getTaught() == null || summary.getTaught().booleanValue()) continue;
            notTaughtSummaries = notTaughtSummaries.add(BigDecimal.ONE);
        }
        return notTaughtSummaries;
    }

    private String getSiglas(Professorship professorship) {
        ExecutionCourse executionCourse = professorship.getExecutionCourse();
        int numberOfCurricularCourse = executionCourse.getAssociatedCurricularCoursesSet().size();
        ArrayList<String> siglas = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            String sigla = curricularCourse.getDegreeCurricularPlan().getDegree().getSigla();
            if (!siglas.contains(sigla)) {
                if (numberOfCurricularCourse < executionCourse.getAssociatedCurricularCoursesSet().size()) {
                    buffer.append(",");
                }
                buffer.append(sigla);
                siglas.add(sigla);
            }
            --numberOfCurricularCourse;
        }
        return buffer.toString();
    }

    private List<LabelValueBean> getAllDepartments(Collection<Department> allDepartments) {
        ArrayList<LabelValueBean> departments = new ArrayList<LabelValueBean>();
        for (Department department : allDepartments) {
            LabelValueBean labelValueBean = new LabelValueBean();
            labelValueBean.setValue(department.getExternalId().toString());
            labelValueBean.setLabel(department.getRealName());
            departments.add(labelValueBean);
        }
        Collections.sort(departments, new BeanComparator("label"));
        return departments;
    }

    protected void readAndSaveAllDepartments(HttpServletRequest request) throws FenixServiceException {
        Set allDepartments = rootDomainObject.getDepartmentsSet();
        List<LabelValueBean> departments = this.getAllDepartments(allDepartments);
        request.setAttribute("allDepartments", (Object)allDepartments);
        request.setAttribute("departments", departments);
    }

    public ActionForward exportInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String departmentID = request.getParameter("departmentID");
        String executionSemesterID = request.getParameter("executionSemesterID");
        String categoryControl = request.getParameter("categoryControl");
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionSemesterID);
        Department department = (Department)FenixFramework.getDomainObject((String)departmentID);
        DepartmentSummaryElement.SummaryControlCategory summaryControlCategory = null;
        String controlCategory = null;
        if (!StringUtils.isEmpty((String)categoryControl)) {
            summaryControlCategory = DepartmentSummaryElement.SummaryControlCategory.valueOf(categoryControl);
            controlCategory = BundleUtil.getString((String)"resources.EnumerationResources", (String)summaryControlCategory.toString(), (String[])new String[0]);
        } else {
            controlCategory = "0-100";
        }
        DepartmentSummaryElement departmentSummaryResume = this.getDepartmentSummaryResume(executionSemester, department);
        departmentSummaryResume.setSummaryControlCategory(summaryControlCategory);
        if (departmentSummaryResume != null) {
            String sigla = departmentSummaryResume.getDepartment().getAcronym();
            DateTime dt = new DateTime();
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"dd-MM-yyyy");
            String date = fmt.print((ReadableInstant)dt);
            String filename = BundleUtil.getString((String)"resources.ApplicationResources", (String)"link.summaries.control", (String[])new String[0]).replaceAll(" ", "_") + "_" + controlCategory + "_" + sigla + "_" + date + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            ServletOutputStream writer = response.getOutputStream();
            this.exportToXls(departmentSummaryResume, departmentSummaryResume.getDepartment(), executionSemester, (OutputStream)writer);
            writer.flush();
            response.flushBuffer();
        }
        return null;
    }

    private void exportToXls(DepartmentSummaryElement departmentSummaryResume, Department department, ExecutionSemester executionSemester, OutputStream os) throws IOException {
        StyledExcelSpreadsheet spreadsheet = new StyledExcelSpreadsheet(BundleUtil.getString((String)"resources.ApplicationResources", (String)"link.summaries.control", (String[])new String[0]));
        this.fillSpreadSheet(departmentSummaryResume, department, executionSemester, spreadsheet);
        spreadsheet.getWorkbook().write(os);
    }

    private void fillSpreadSheet(DepartmentSummaryElement departmentSummaryResume, Department department, ExecutionSemester semester, StyledExcelSpreadsheet sheet) {
        this.setHeaders(sheet);
        int counter = 0;
        List<ExecutionCourseSummaryElement> executionCourses = departmentSummaryResume.getExecutionCourses();
        for (ExecutionCourseSummaryElement executionCourse : executionCourses) {
            counter = 0;
            List<DetailSummaryElement> executionCoursesResume = this.getExecutionCourseResume(executionCourse.getExecutionCourse().getExecutionPeriod(), executionCourse.getExecutionCourse().getProfessorshipsSet());
            int lessons = executionCourse.getNumberOfLessonInstances().intValue();
            int lessonsWithSummaries = executionCourse.getNumberOfLessonInstancesWithSummary().intValue();
            double lessonsWithSummariesPercentage = executionCourse.getPercentageOfLessonsWithSummary().doubleValue();
            int lessonsWithNotTaughtSummaries = executionCourse.getNumberOfLessonInstancesWithNotTaughtSummary().intValue();
            double lessonsWithNotTaughtSummariesPercentage = executionCourse.getPercentageOfLessonsWithNotTaughtSummary().doubleValue();
            for (DetailSummaryElement detailSummaryElement : executionCoursesResume) {
                if (counter == 0) {
                    sheet.newRow();
                    sheet.addCell((Object)semester.getName(), sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)department.getName(), sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)executionCourse.getExecutionCourse().getName(), sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)lessons, sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)lessonsWithSummaries, sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)lessonsWithSummariesPercentage, sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)lessonsWithNotTaughtSummaries, sheet.getExcelStyle().getLabelStyle());
                    sheet.addCell((Object)lessonsWithNotTaughtSummariesPercentage, sheet.getExcelStyle().getLabelStyle());
                }
                sheet.newRow();
                sheet.addCell(null);
                sheet.addCell(null);
                sheet.addCell(null);
                sheet.addCell((Object)detailSummaryElement.getGivenSummaries());
                sheet.addCell((Object)detailSummaryElement.getGivenNotTaughtSummaries());
                sheet.addCell((Object)detailSummaryElement.getTeacherName());
                sheet.addCell((Object)detailSummaryElement.getTeacherId());
                sheet.addCell((Object)detailSummaryElement.getTeacherEmail());
                ++counter;
            }
        }
    }

    private void setHeaders(StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.semester", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.department", (String[])new String[0]), 10000);
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.course", (String[])new String[0]), 10000);
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.lessons.summaries", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.lessons.notTaught.summaries", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.professorName", (String[])new String[0]), 10000);
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.professorUsername", (String[])new String[0]));
        spreadsheet.addHeader(BundleUtil.getString((String)"resources.PedagogicalCouncilResources", (String)"label.excel.professorEmail", (String[])new String[0]), 10000);
    }
}

