/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.student.administrativeOfficeServices;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.RegisteredCandidacySituation;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.administrativeOffice.ExecutionDegreeBean;
import org.fenixedu.academic.dto.candidacy.IngressionInformationBean;
import org.fenixedu.academic.dto.candidacy.OriginInformationBean;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.student.administrativeOfficeServices.CreateStudent$callable$run;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateStudent {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Registration run(PersonBean personBean, ExecutionDegreeBean executionDegreeBean, PrecedentDegreeInformationBean precedentDegreeInformationBean, IngressionInformationBean ingressionInformationBean, OriginInformationBean originInformationBean) {
        return (Registration)((Object)advice$run.perform((Callable)new CreateStudent$callable$run(personBean, executionDegreeBean, precedentDegreeInformationBean, ingressionInformationBean, originInformationBean)));
    }

    static /* synthetic */ Registration advised$run(PersonBean personBean, ExecutionDegreeBean executionDegreeBean, PrecedentDegreeInformationBean precedentDegreeInformationBean, IngressionInformationBean ingressionInformationBean, OriginInformationBean originInformationBean) {
        AccessControl.check(AcademicPredicates.CREATE_REGISTRATION);
        Person person = CreateStudent.getPerson(personBean);
        StudentCandidacy studentCandidacy = StudentCandidacy.createStudentCandidacy(executionDegreeBean.getExecutionDegree(), person);
        new RegisteredCandidacySituation((Candidacy)((Object)studentCandidacy), ingressionInformationBean.getRegistrationProtocol(), executionDegreeBean.getCycleType(), ingressionInformationBean.getIngressionType(), ingressionInformationBean.getEntryPhase(), personBean.getStudentNumber());
        Registration registration = studentCandidacy.getRegistration();
        if (registration == null) {
            registration = Registration.createRegistrationWithCustomStudentNumber(person, executionDegreeBean.getDegreeCurricularPlan(), studentCandidacy, ingressionInformationBean.getRegistrationProtocol(), executionDegreeBean.getCycleType(), executionDegreeBean.getExecutionYear(), personBean.getStudentNumber());
        }
        registration.setHomologationDate(ingressionInformationBean.getHomologationDate());
        registration.setStudiesStartDate(ingressionInformationBean.getStudiesStartDate());
        PersonalIngressionData personalIngressionData = registration.getStudent().getPersonalIngressionDataByExecutionYear(executionDegreeBean.getExecutionDegree().getExecutionYear());
        if (personalIngressionData == null) {
            personalIngressionData = new PersonalIngressionData(originInformationBean, personBean, registration.getStudent(), executionDegreeBean.getExecutionDegree().getExecutionYear());
        } else {
            personalIngressionData.edit(originInformationBean, personBean);
        }
        PrecedentDegreeInformation precedentDegreeInformation = studentCandidacy.getPrecedentDegreeInformation();
        precedentDegreeInformation.edit(personalIngressionData, registration, precedentDegreeInformationBean, studentCandidacy);
        new Qualification(person, precedentDegreeInformation);
        return registration;
    }

    private static Person getPerson(PersonBean personBean) {
        Person person = null;
        if (personBean.getPerson() != null) {
            person = personBean.save();
        } else {
            person = new Person(personBean);
            if (person.getUser() == null) {
                person.setUser(new User(person.getProfile()));
            }
        }
        return person;
    }
}

