/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.serviceRequests;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class AcademicServiceRequestBean
implements Serializable {
    protected AcademicServiceRequestSituationType academicServiceRequestSituationType;
    private AcademicServiceRequest request;
    private String justification;
    private YearMonthDay situationDate;
    protected Integer serviceRequestYear;
    private Person responsible;
    DateTime finalSituationDate;

    protected AcademicServiceRequestBean() {
    }

    public AcademicServiceRequestBean(AcademicServiceRequest request, AcademicServiceRequestSituationType situationType) {
        this();
        this.setAcademicServiceRequest(request);
        this.setAcademicServiceRequestSituationType(situationType);
        this.setSituationDate(new YearMonthDay());
    }

    public AcademicServiceRequestBean(AcademicServiceRequestSituationType academicServiceRequestSituationType, Person responsible) {
        this();
        this.setAcademicServiceRequestSituationType(academicServiceRequestSituationType);
        this.setResponsible(responsible);
        this.setSituationDate(new YearMonthDay());
    }

    public AcademicServiceRequestBean(AcademicServiceRequestSituationType academicServiceRequestSituationType, Person responsible, Integer serviceRequestYear) {
        this(academicServiceRequestSituationType, responsible);
        this.setServiceRequestYear(serviceRequestYear);
    }

    public AcademicServiceRequestBean(AcademicServiceRequestSituationType academicServiceRequestSituationType, Person responsible, String justification) {
        this(academicServiceRequestSituationType, responsible);
        this.setJustification(justification);
    }

    public AcademicServiceRequestBean(AcademicServiceRequestSituationType academicServiceRequestSituationType, Person responsible, YearMonthDay situationDate, String justification) {
        this(academicServiceRequestSituationType, responsible, justification);
        this.setSituationDate(situationDate);
    }

    public AcademicServiceRequestBean(Person responsible, String justification) {
        this((AcademicServiceRequestSituationType)null, responsible, justification);
    }

    public AcademicServiceRequestSituationType getAcademicServiceRequestSituationType() {
        return this.academicServiceRequestSituationType;
    }

    public void setAcademicServiceRequestSituationType(AcademicServiceRequestSituationType academicServiceRequestSituationType) {
        this.academicServiceRequestSituationType = academicServiceRequestSituationType;
    }

    public boolean hasAcademicServiceRequestSituationType() {
        return this.academicServiceRequestSituationType != null;
    }

    public DateTime getFinalSituationDate() {
        if (this.finalSituationDate == null) {
            return this.getSituationDate().toDateTimeAtCurrentTime();
        }
        return this.finalSituationDate;
    }

    public void setFinalSituationDate(DateTime finalSituationDate) {
        this.finalSituationDate = finalSituationDate;
    }

    public YearMonthDay getSituationDate() {
        return this.situationDate;
    }

    public void setSituationDate(YearMonthDay situationDate) {
        this.situationDate = situationDate;
    }

    public Person getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Person responsible) {
        this.responsible = responsible;
    }

    private AcademicServiceRequest getAcademicServiceRequest() {
        return this.request;
    }

    private void setAcademicServiceRequest(AcademicServiceRequest request) {
        this.request = request;
    }

    public String getJustification() {
        if (StringUtils.isEmpty((String)this.justification) && this.getAcademicServiceRequest().isDocumentRequest() && ((DocumentRequest)((Object)this.getAcademicServiceRequest())).isDiploma()) {
            if (this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.CONCLUDED) {
                return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"DiplomaRequest.diploma.concluded", (String[])new String[0]);
            }
            if (this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY) {
                return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"DiplomaRequest.diploma.sent", (String[])new String[0]);
            }
            if (this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY) {
                return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"DiplomaRequest.diploma.received", (String[])new String[0]);
            }
        }
        return this.justification;
    }

    public void setJustification(String justification) {
        this.justification = justification;
    }

    public boolean hasJustification() {
        return !StringUtils.isEmpty((String)this.justification);
    }

    public Integer getServiceRequestYear() {
        return this.serviceRequestYear;
    }

    public void setServiceRequestYear(Integer serviceRequestYear) {
        this.serviceRequestYear = serviceRequestYear;
    }

    public boolean isNew() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.NEW;
    }

    public boolean isToProcess() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.PROCESSING;
    }

    public boolean isToDeliver() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.DELIVERED;
    }

    public boolean isToCancel() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.CANCELLED;
    }

    public boolean isToReject() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.REJECTED;
    }

    public boolean isToConclude() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.CONCLUDED;
    }

    public boolean isToSendToExternalEntity() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY;
    }

    public boolean isToReceiveFromExternalUnit() {
        return this.academicServiceRequestSituationType == AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY;
    }

    public boolean isToCancelOrReject() {
        return this.isToCancel() || this.isToReject();
    }

    public Collection<AcademicServiceRequest> searchAcademicServiceRequests() {
        return AcademicServiceRequest.getAcademicServiceRequests(AccessControl.getPerson(), this.serviceRequestYear, this.academicServiceRequestSituationType, null);
    }
}

