/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.contacts;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;

public class PendingPartyContactBean {
    private Person person;

    public PendingPartyContactBean(Person person) {
        this.person = person;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public PhysicalAddress getDefaultPhysicalAddress() {
        List pendingOrValidPhysicalAddresses = this.getPerson().getPendingOrValidPhysicalAddresses();
        if (!pendingOrValidPhysicalAddresses.isEmpty()) {
            if (pendingOrValidPhysicalAddresses.size() > 0) {
                return (PhysicalAddress)((Object)pendingOrValidPhysicalAddresses.iterator().next());
            }
            for (PhysicalAddress physicalAddress : pendingOrValidPhysicalAddresses) {
                if (physicalAddress.getPartyContactValidation() == null || physicalAddress.getPartyContactValidation().getToBeDefault() == null || !physicalAddress.getPartyContactValidation().getToBeDefault().booleanValue()) continue;
                return physicalAddress;
            }
            return null;
        }
        return null;
    }

    public Phone getDefaultPhone() {
        Phone defaultPhone = this.getPerson().getDefaultPhone();
        if (defaultPhone != null) {
            return defaultPhone;
        }
        List pendingPhones = this.getPerson().getPendingPhones();
        for (Phone phone : pendingPhones) {
            if (!Boolean.TRUE.equals(phone.getPartyContactValidation().getToBeDefault())) continue;
            return phone;
        }
        return null;
    }

    public MobilePhone getDefaultMobilePhone() {
        MobilePhone defaultPhone = this.getPerson().getDefaultMobilePhone();
        if (defaultPhone != null) {
            return defaultPhone;
        }
        List pendingPhones = this.getPerson().getPendingMobilePhones();
        for (MobilePhone phone : pendingPhones) {
            if (!Boolean.TRUE.equals(phone.getPartyContactValidation().getToBeDefault())) continue;
            return phone;
        }
        return null;
    }

    public EmailAddress getDefaultEmailAddress() {
        EmailAddress defaultEmailAddress = this.getPerson().getDefaultEmailAddress();
        if (defaultEmailAddress != null) {
            return defaultEmailAddress;
        }
        List pendingEmailAddresses = this.getPerson().getPendingEmailAddresses();
        for (EmailAddress emailAddress : pendingEmailAddresses) {
            if (!Boolean.TRUE.equals(emailAddress.getPartyContactValidation().getToBeDefault())) continue;
            return emailAddress;
        }
        return null;
    }
}

