/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.math.BigDecimal;
import java.util.List;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExtraCurriculumGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.YearMonthDay;

public class RaidesCommonReportFieldsWrapper {
    public static void createHeaders(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("ciclo");
        spreadsheet.setHeader("conclu\u00eddo (ano anterior)?");
        spreadsheet.setHeader("m\u00e9dia do ciclo");
        spreadsheet.setHeader("Data de conclus\u00e3o");
        spreadsheet.setHeader("Data de in\u00edcio");
        spreadsheet.setHeader("n\u00famero aluno");
        spreadsheet.setHeader("tipo identifica\u00e7\u00e3o");
        spreadsheet.setHeader("n\u00famero identifica\u00e7\u00e3o");
        spreadsheet.setHeader("digitos controlo");
        spreadsheet.setHeader("vers\u00e3o doc identifica\u00e7\u00e3o");
        spreadsheet.setHeader("nome");
        spreadsheet.setHeader("g\u00e9nero");
        spreadsheet.setHeader("data nascimento");
        spreadsheet.setHeader("pa\u00eds nascimento");
        spreadsheet.setHeader("pa\u00eds nacionalidade");
        spreadsheet.setHeader("tipo curso");
        spreadsheet.setHeader("nome curso");
        spreadsheet.setHeader("sigla curso");
        spreadsheet.setHeader("Ramo Principal");
        spreadsheet.setHeader("Ramo Secund\u00e1ro");
        spreadsheet.setHeader("ano curricular");
        spreadsheet.setHeader("ano ingresso curso actual");
        spreadsheet.setHeader("n\u00ba. anos lectivos inscri\u00e7\u00e3o curso actual");
        spreadsheet.setHeader("\u00daltimo ano inscrito neste curso");
        spreadsheet.setHeader("regime frequ\u00eancia curso");
        spreadsheet.setHeader("tipo aluno");
        spreadsheet.setHeader("regime ingresso (c\u00f3digo)");
        spreadsheet.setHeader("regime ingresso (designa\u00e7\u00e3o)");
        spreadsheet.setHeader("estabelecimento do grau preced. (qd aplic\u00e1vel)");
        spreadsheet.setHeader("curso grau preced. (qd aplic\u00e1vel)");
        spreadsheet.setHeader("estabelec. curso habl anterior compl");
        spreadsheet.setHeader("curso habl anterior compl");
        spreadsheet.setHeader("n\u00ba inscri\u00e7\u00f5es no curso preced.");
        spreadsheet.setHeader("nota ingresso");
        spreadsheet.setHeader("op\u00e7\u00e3o ingresso");
        spreadsheet.setHeader("estado civil");
        spreadsheet.setHeader("pa\u00eds resid\u00eancia permanente");
        spreadsheet.setHeader("distrito resid\u00eancia permanente");
        spreadsheet.setHeader("concelho resid\u00eancia permanente");
        spreadsheet.setHeader("deslocado resid\u00eancia permanente");
        spreadsheet.setHeader("n\u00edvel escolaridade pai");
        spreadsheet.setHeader("n\u00edvel escolaridade m\u00e3e");
        spreadsheet.setHeader("condi\u00e7\u00e3o perante profiss\u00e3o pai");
        spreadsheet.setHeader("condi\u00e7\u00e3o perante profiss\u00e3o m\u00e3e");
        spreadsheet.setHeader("profiss\u00e3o pai");
        spreadsheet.setHeader("profiss\u00e3o m\u00e3e");
        spreadsheet.setHeader("profiss\u00e3o aluno");
        spreadsheet.setHeader("Data preenchimento dados RAIDES");
        spreadsheet.setHeader("estatuto trabalhador estudante introduzido (info. RAIDES)");
        spreadsheet.setHeader("estatuto trabalhador 1\u00ba semestre ano (info. oficial)");
        spreadsheet.setHeader("estatuto trabalhador 2\u00ba semestre ano (info. oficial)");
        spreadsheet.setHeader("bolseiro (info. RAIDES)");
        spreadsheet.setHeader("institui\u00e7\u00e3o que atribuiu a bolsa (qd aplic\u00e1vel)");
        spreadsheet.setHeader("bolseiro (info. oficial)");
        spreadsheet.setHeader("Grau Precedente");
        spreadsheet.setHeader("Outro Grau Precedente");
        spreadsheet.setHeader("grau habl anterior compl");
        spreadsheet.setHeader("Codigo do grau habl anterior");
        spreadsheet.setHeader("Outro grau habl anterior compl");
        spreadsheet.setHeader("pa\u00eds habilita\u00e7\u00e3o anterior");
        spreadsheet.setHeader("pa\u00eds habilita\u00e7\u00e3o 12\u00ba ano ou equivalente");
        spreadsheet.setHeader("ano de conclus\u00e3o da habilita\u00e7\u00e3o anterior");
        spreadsheet.setHeader("nota da habilita\u00e7\u00e3o anterior");
        spreadsheet.setHeader("Programa mobilidade");
        spreadsheet.setHeader("Pa\u00eds mobilidade");
        spreadsheet.setHeader("Dura\u00e7\u00e3o programa mobilidade");
        spreadsheet.setHeader("tipo estabelecimento ensino secund\u00e1rio");
        spreadsheet.setHeader("total ECTS inscritos no ano");
        spreadsheet.setHeader("total ECTS conclu\u00eddos fim ano lectivo anterior");
        spreadsheet.setHeader("n\u00ba. disciplinas inscritas ano lectivo anterior dados");
        spreadsheet.setHeader("n\u00ba. disciplinas aprovadas ano lectivo anterior dados");
        spreadsheet.setHeader("n\u00ba. inscri\u00e7\u00f5es externas ano dados");
        spreadsheet.setHeader("estado matr\u00edcula ano anterior dados");
        spreadsheet.setHeader("estado matr\u00edcula ano dados");
        spreadsheet.setHeader("data do estado de matr\u00edcula");
        spreadsheet.setHeader("n\u00ba. ECTS 1\u00ba ciclo conclu\u00eddos fim ano lectivo anterior");
        spreadsheet.setHeader("n\u00ba. ECTS 2\u00ba ciclo conclu\u00eddos fim ano lectivo anterior");
        spreadsheet.setHeader("n\u00ba. ECTS extra 1\u00ba ciclo conclu\u00eddos fim ano lectivo anterior");
        spreadsheet.setHeader("n\u00ba. ECTS extracurriculares conclu\u00eddos fim ano lectivo anterior");
        spreadsheet.setHeader("n\u00ba. ECTS Propedeuticas conclu\u00eddos fim ano lectivo anterior");
        spreadsheet.setHeader("n\u00ba. ECTS inscritos em Propedeut e extra-curriculares");
        spreadsheet.setHeader("n\u00ba. ECTS equival\u00eancia/substitui\u00e7\u00e3o/dispensa");
        spreadsheet.setHeader("Tem situa\u00e7\u00e3o de propinas no lectivo dos dados?");
    }

    /*
     * WARNING - void declaration
     */
    public static Spreadsheet.Row reportRaidesFields(Spreadsheet sheet, Registration registration, List<Registration> registrationPath, ExecutionYear executionYear, CycleType cycleType, boolean concluded, YearMonthDay conclusionDate, BigDecimal average, boolean graduation) {
        void var43_58;
        void var37_49;
        Spreadsheet.Row row = sheet.addRow();
        Person graduate = registration.getPerson();
        Registration sourceRegistration = registrationPath.iterator().next();
        PersonalInformationBean personalInformationBean = registration.getPersonalInformationBean(executionYear);
        StudentCurricularPlan lastStudentCurricularPlan = registration.getLastStudentCurricularPlan();
        row.setCell(cycleType.getDescription());
        row.setCell(String.valueOf(concluded));
        if (graduation) {
            row.setCell(concluded ? RaidesCommonReportFieldsWrapper.printBigDecimal(average.setScale(0, 6)) : RaidesCommonReportFieldsWrapper.printBigDecimal(average));
        } else {
            row.setCell(concluded ? lastStudentCurricularPlan.getCycle(cycleType).getCurriculum().getRawGrade().getValue() : "n/a");
        }
        row.setCell(conclusionDate != null ? conclusionDate.toString("dd-MM-yyyy") : "");
        row.setCell(registration.getStartDate() != null ? registration.getStartDate().toString("dd-MM-yyyy") : "");
        row.setCell(registration.getNumber());
        row.setCell(graduate.getIdDocumentType().getLocalizedName());
        row.setCell(graduate.getDocumentIdNumber());
        row.setCell(graduate.getIdentificationDocumentExtraDigitValue());
        row.setCell(graduate.getIdentificationDocumentSeriesNumberValue());
        row.setCell(registration.getName());
        row.setCell(graduate.getGender().toString());
        row.setCell(graduate.getDateOfBirthYearMonthDay() != null ? graduate.getDateOfBirthYearMonthDay().toString("dd-MM-yyyy") : "n/a");
        row.setCell(graduate.getCountryOfBirth() != null ? graduate.getCountryOfBirth().getName() : "n/a");
        row.setCell(graduate.getCountry() != null ? graduate.getCountry().getName() : "n/a");
        row.setCell(registration.getDegreeType().getName().getContent());
        row.setCell(registration.getDegree().getNameI18N().getContent());
        row.setCell(registration.getDegree().getSigla());
        StringBuilder majorBranches = new StringBuilder();
        StringBuilder minorBranches = new StringBuilder();
        for (Object group : lastStudentCurricularPlan.getBranchCurriculumGroups()) {
            if (group.isMajor()) {
                majorBranches.append(group.getName().toString()).append(",");
                continue;
            }
            if (!group.isMinor()) continue;
            minorBranches.append(group.getName().toString()).append(",");
        }
        if (majorBranches.length() > 0) {
            row.setCell(majorBranches.deleteCharAt(majorBranches.length() - 1).toString());
        } else {
            row.setCell("");
        }
        if (minorBranches.length() > 0) {
            row.setCell(minorBranches.deleteCharAt(minorBranches.length() - 1).toString());
        } else {
            row.setCell("");
        }
        row.setCell(Integer.valueOf(registration.getCurricularYear(executionYear)));
        row.setCell(sourceRegistration.getStartExecutionYear().getName());
        int numberOfEnrolmentYears = 0;
        for (Registration current : registrationPath) {
            numberOfEnrolmentYears += current.getNumberOfYearsEnrolledUntil(executionYear);
        }
        row.setCell(Integer.valueOf(numberOfEnrolmentYears));
        row.setCell(registration.getLastEnrolmentExecutionYear() != null ? registration.getLastEnrolmentExecutionYear().getName() : "");
        row.setCell(registration.getRegimeType(executionYear) != null ? registration.getRegimeType(executionYear).getName() : "");
        row.setCell(registration.getRegistrationProtocol() != null ? registration.getRegistrationProtocol().getCode() : "");
        IngressionType ingressionType = sourceRegistration.getIngressionType();
        if (ingressionType == null && sourceRegistration.getStudentCandidacy() != null) {
            ingressionType = sourceRegistration.getStudentCandidacy().getIngressionType();
        }
        row.setCell(ingressionType != null ? ingressionType.getCode() : "");
        row.setCell(ingressionType != null ? ingressionType.getDescription().getContent() : "");
        row.setCell(personalInformationBean.getPrecedentInstitution() != null ? personalInformationBean.getPrecedentInstitution().getName() : "");
        row.setCell(personalInformationBean.getPrecedentDegreeDesignation() != null ? personalInformationBean.getPrecedentDegreeDesignation() : "");
        row.setCell(personalInformationBean.getInstitution() != null ? personalInformationBean.getInstitution().getName() : "");
        row.setCell(personalInformationBean.getDegreeDesignation());
        row.setCell(personalInformationBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree() != null ? personalInformationBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree().toString() : "");
        Double entryGrade = null;
        if (registration.getStudentCandidacy() != null) {
            entryGrade = registration.getStudentCandidacy().getEntryGrade();
        }
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(entryGrade));
        Integer placingOption = null;
        if (registration.getStudentCandidacy() != null) {
            placingOption = registration.getStudentCandidacy().getPlacingOption();
        }
        row.setCell(placingOption);
        row.setCell(personalInformationBean.getMaritalStatus() != null ? personalInformationBean.getMaritalStatus().toString() : registration.getPerson().getMaritalStatus().toString());
        if (personalInformationBean.getCountryOfResidence() != null) {
            row.setCell(personalInformationBean.getCountryOfResidence().getName());
        } else {
            row.setCell(registration.getStudent().getPerson().getCountryOfResidence() != null ? registration.getStudent().getPerson().getCountryOfResidence().getName() : "");
        }
        if (personalInformationBean.getDistrictSubdivisionOfResidence() != null) {
            row.setCell(personalInformationBean.getDistrictSubdivisionOfResidence().getDistrict().getName());
        } else {
            row.setCell(registration.getStudent().getPerson().getDistrictOfResidence());
        }
        if (personalInformationBean.getDistrictSubdivisionOfResidence() != null) {
            row.setCell(personalInformationBean.getDistrictSubdivisionOfResidence().getName());
        } else {
            row.setCell(registration.getStudent().getPerson().getDistrictSubdivisionOfResidence());
        }
        if (personalInformationBean.getDislocatedFromPermanentResidence() != null) {
            row.setCell(personalInformationBean.getDislocatedFromPermanentResidence().toString());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getFatherSchoolLevel() != null) {
            row.setCell(personalInformationBean.getFatherSchoolLevel().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getMotherSchoolLevel() != null) {
            row.setCell(personalInformationBean.getMotherSchoolLevel().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getFatherProfessionalCondition() != null) {
            row.setCell(personalInformationBean.getFatherProfessionalCondition().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getMotherProfessionalCondition() != null) {
            row.setCell(personalInformationBean.getMotherProfessionalCondition().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getFatherProfessionType() != null) {
            row.setCell(personalInformationBean.getFatherProfessionType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getMotherProfessionType() != null) {
            row.setCell(personalInformationBean.getMotherProfessionType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getProfessionType() != null) {
            row.setCell(personalInformationBean.getProfessionType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getLastModifiedDate() != null) {
            DateTime dateTime = personalInformationBean.getLastModifiedDate();
            row.setCell(dateTime.getYear() + "-" + dateTime.getMonthOfYear() + "-" + dateTime.getDayOfMonth());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getProfessionalCondition() != null) {
            row.setCell(personalInformationBean.getProfessionalCondition().getName());
        } else {
            row.setCell("");
        }
        boolean working1Found = false;
        for (Object statute : registration.getStudent().getStudentStatutesSet()) {
            if (!statute.getType().isWorkingStudentStatute() || !statute.isValidInExecutionPeriod(executionYear.getFirstExecutionPeriod())) continue;
            working1Found = true;
            break;
        }
        row.setCell(String.valueOf(working1Found));
        boolean working2Found = false;
        for (Object statute : registration.getStudent().getStudentStatutesSet()) {
            if (!statute.getType().isWorkingStudentStatute() || !statute.isValidInExecutionPeriod(executionYear.getLastExecutionPeriod())) continue;
            working2Found = true;
            break;
        }
        row.setCell(String.valueOf(working2Found));
        if (personalInformationBean.getGrantOwnerType() != null) {
            row.setCell(personalInformationBean.getGrantOwnerType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getGrantOwnerType() != null && personalInformationBean.getGrantOwnerType().equals((Object)GrantOwnerType.OTHER_INSTITUTION_GRANT_OWNER)) {
            row.setCell(personalInformationBean.getGrantOwnerProviderName());
        } else {
            row.setCell("");
        }
        boolean sasFound = false;
        for (StudentStatute statute : registration.getStudent().getStudentStatutesSet()) {
            if (!statute.getType().isGrantOwnerStatute() || !statute.isValidInExecutionPeriod(executionYear.getFirstExecutionPeriod())) continue;
            sasFound = true;
            break;
        }
        row.setCell(String.valueOf(sasFound));
        row.setCell(personalInformationBean.getPrecedentSchoolLevel() != null ? personalInformationBean.getPrecedentSchoolLevel().getName() : "");
        row.setCell(personalInformationBean.getOtherPrecedentSchoolLevel());
        row.setCell(personalInformationBean.getSchoolLevel() != null ? personalInformationBean.getSchoolLevel().getName() : "");
        DegreeDesignation designation = DegreeDesignation.readByNameAndSchoolLevel(personalInformationBean.getDegreeDesignation(), personalInformationBean.getPrecedentSchoolLevel());
        row.setCell(designation != null ? designation.getDegreeClassification().getCode() : "");
        row.setCell(personalInformationBean.getOtherSchoolLevel());
        row.setCell(personalInformationBean.getCountryWhereFinishedPreviousCompleteDegree() != null ? personalInformationBean.getCountryWhereFinishedPreviousCompleteDegree().getName() : "");
        row.setCell(personalInformationBean.getCountryWhereFinishedHighSchoolLevel() != null ? personalInformationBean.getCountryWhereFinishedHighSchoolLevel().getName() : "");
        row.setCell(personalInformationBean.getConclusionYear());
        row.setCell(personalInformationBean.getConclusionGrade() != null ? personalInformationBean.getConclusionGrade() : "");
        MobilityAgreement mobilityAgreement = null;
        ExecutionInterval chosenCandidacyInterval = null;
        for (OutboundMobilityCandidacySubmission outboundCandidacySubmission : registration.getOutboundMobilityCandidacySubmissionSet()) {
            ExecutionInterval candidacyInterval;
            if (outboundCandidacySubmission.getSelectedCandidacy() == null || !outboundCandidacySubmission.getSelectedCandidacy().getSelected().booleanValue() || !(candidacyInterval = outboundCandidacySubmission.getOutboundMobilityCandidacyPeriod().getExecutionInterval()).getAcademicInterval().isBefore((ReadableInterval)executionYear.getAcademicInterval()) || mobilityAgreement != null && !candidacyInterval.getAcademicInterval().isAfter((ReadableInterval)chosenCandidacyInterval.getAcademicInterval())) continue;
            mobilityAgreement = outboundCandidacySubmission.getSelectedCandidacy().getOutboundMobilityCandidacyContest().getMobilityAgreement();
            chosenCandidacyInterval = candidacyInterval;
        }
        row.setCell(mobilityAgreement != null ? mobilityAgreement.getMobilityProgram().getName().getContent() : "");
        row.setCell(mobilityAgreement != null ? mobilityAgreement.getUniversityUnit().getCountry().getName() : "");
        row.setCell(personalInformationBean.getMobilityProgramDuration() != null ? BundleUtil.getString((String)"resources.EnumerationResources", (String)personalInformationBean.getMobilityProgramDuration().name(), (String[])new String[0]) : "");
        if (personalInformationBean.getHighSchoolType() != null) {
            row.setCell(personalInformationBean.getHighSchoolType().getName());
        } else {
            row.setCell("");
        }
        int totalEnrolmentsInPreviousYear = 0;
        int totalEnrolmentsApprovedInPreviousYear = 0;
        double totalEctsConcludedUntilPreviousYear = 0.0;
        for (CycleCurriculumGroup cycleCurriculumGroup : lastStudentCurricularPlan.getInternalCycleCurriculumGrops()) {
            totalEctsConcludedUntilPreviousYear += cycleCurriculumGroup.getCreditsConcluded(executionYear.getPreviousExecutionYear()).doubleValue();
            totalEnrolmentsInPreviousYear += cycleCurriculumGroup.getEnrolmentsBy(executionYear.getPreviousExecutionYear()).size();
            for (Enrolment enrolment : cycleCurriculumGroup.getEnrolmentsBy(executionYear.getPreviousExecutionYear())) {
                if (!enrolment.isApproved()) continue;
                ++totalEnrolmentsApprovedInPreviousYear;
            }
        }
        double totalCreditsEnrolled = 0.0;
        for (Enrolment enrollment : lastStudentCurricularPlan.getEnrolmentsByExecutionYear(executionYear)) {
            totalCreditsEnrolled += enrollment.getEctsCredits().doubleValue();
        }
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(totalCreditsEnrolled));
        double totalCreditsDismissed = 0.0;
        for (Credits credits : lastStudentCurricularPlan.getCreditsSet()) {
            if (!credits.isEquivalence()) continue;
            totalCreditsDismissed += credits.getEnrolmentsEcts().doubleValue();
        }
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(totalEctsConcludedUntilPreviousYear));
        row.setCell(Integer.valueOf(totalEnrolmentsInPreviousYear));
        row.setCell(Integer.valueOf(totalEnrolmentsApprovedInPreviousYear));
        ExtraCurriculumGroup extraCurriculumGroup = lastStudentCurricularPlan.getExtraCurriculumGroup();
        int extraCurricularEnrolmentsCount = extraCurriculumGroup != null ? extraCurriculumGroup.getEnrolmentsBy(executionYear).size() : 0;
        for (CycleCurriculumGroup cycleCurriculumGroup : lastStudentCurricularPlan.getExternalCurriculumGroups()) {
            extraCurricularEnrolmentsCount += cycleCurriculumGroup.getEnrolmentsBy(executionYear).size();
        }
        if (lastStudentCurricularPlan.hasPropaedeuticsCurriculumGroup()) {
            extraCurricularEnrolmentsCount += lastStudentCurricularPlan.getPropaedeuticCurriculumGroup().getEnrolmentsBy(executionYear).size();
        }
        row.setCell(Integer.valueOf(extraCurricularEnrolmentsCount));
        TreeSet<RegistrationState> states = new TreeSet<RegistrationState>(RegistrationState.DATE_COMPARATOR);
        for (Registration current : registrationPath) {
            states.addAll(current.getRegistrationStatesSet());
        }
        Object var37_48 = null;
        RegistrationState currentYearState = null;
        for (RegistrationState state : states) {
            if (!state.getStateDate().isAfter((ReadableInstant)executionYear.getPreviousExecutionYear().getEndDateYearMonthDay().toDateTimeAtMidnight())) {
                RegistrationState registrationState = state;
            }
            if (state.getStateDate().isAfter((ReadableInstant)executionYear.getEndDateYearMonthDay().toDateTimeAtMidnight())) continue;
            currentYearState = state;
        }
        row.setCell(var37_49 != null ? var37_49.getStateType().getDescription() : "n/a");
        row.setCell(currentYearState != null ? currentYearState.getStateType().getDescription() : "n/a");
        row.setCell(currentYearState != null ? currentYearState.getStateDate().toString("dd-MM-yyyy") : "n/a");
        CycleCurriculumGroup firstCycleCurriculumGroup = lastStudentCurricularPlan.getRoot().getCycleCurriculumGroup(CycleType.FIRST_CYCLE);
        row.setCell(firstCycleCurriculumGroup != null ? RaidesCommonReportFieldsWrapper.printBigDecimal(firstCycleCurriculumGroup.getCurriculum(executionYear).getSumEctsCredits()) : "");
        CycleCurriculumGroup secondCycleCurriculumGroup = lastStudentCurricularPlan.getRoot().getCycleCurriculumGroup(CycleType.SECOND_CYCLE);
        row.setCell(secondCycleCurriculumGroup != null && !secondCycleCurriculumGroup.isExternal() ? RaidesCommonReportFieldsWrapper.printBigDecimal(secondCycleCurriculumGroup.getCurriculum(executionYear).getSumEctsCredits()) : "");
        Double extraFirstCycleEcts = 0.0;
        for (CycleCurriculumGroup cycleCurriculumGroup : lastStudentCurricularPlan.getExternalCurriculumGroups()) {
            for (CurriculumLine curriculumLine : cycleCurriculumGroup.getAllCurriculumLines()) {
                if (curriculumLine.getExecutionYear().isAfter(executionYear.getPreviousExecutionYear())) continue;
                extraFirstCycleEcts = extraFirstCycleEcts + curriculumLine.getCreditsConcluded(executionYear.getPreviousExecutionYear());
            }
        }
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(extraFirstCycleEcts));
        Double extraCurricularEcts = 0.0;
        Double d = 0.0;
        if (extraCurriculumGroup != null) {
            for (CurriculumLine curriculumLine : extraCurriculumGroup.getAllCurriculumLines()) {
                if (curriculumLine.isApproved() && curriculumLine.hasExecutionPeriod() && !curriculumLine.getExecutionYear().isAfter(executionYear.getPreviousExecutionYear())) {
                    extraCurricularEcts = extraCurricularEcts + curriculumLine.getEctsCreditsForCurriculum().doubleValue();
                }
                if (!curriculumLine.hasExecutionPeriod() || curriculumLine.getExecutionYear() != executionYear) continue;
                Double d2 = var43_58.doubleValue() + curriculumLine.getEctsCreditsForCurriculum().doubleValue();
            }
        }
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(extraCurricularEcts));
        Double propaedeuticEcts = 0.0;
        Double allPropaedeuticEcts = 0.0;
        if (lastStudentCurricularPlan.getPropaedeuticCurriculumGroup() != null) {
            for (CurriculumLine curriculumLine : lastStudentCurricularPlan.getPropaedeuticCurriculumGroup().getAllCurriculumLines()) {
                if (curriculumLine.isApproved() && curriculumLine.hasExecutionPeriod() && !curriculumLine.getExecutionYear().isAfter(executionYear.getPreviousExecutionYear())) {
                    propaedeuticEcts = propaedeuticEcts + curriculumLine.getEctsCreditsForCurriculum().doubleValue();
                }
                if (!curriculumLine.hasExecutionPeriod() || curriculumLine.getExecutionYear() != executionYear) continue;
                allPropaedeuticEcts = allPropaedeuticEcts + curriculumLine.getEctsCreditsForCurriculum().doubleValue();
            }
        }
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(propaedeuticEcts));
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(allPropaedeuticEcts + var43_58.doubleValue()));
        row.setCell(RaidesCommonReportFieldsWrapper.printDouble(totalCreditsDismissed));
        row.setCell(String.valueOf(lastStudentCurricularPlan.hasAnyGratuityEventFor(executionYear)));
        return row;
    }

    private static String printDouble(Double value) {
        return value == null ? "" : value.toString().replace('.', ',');
    }

    private static String printBigDecimal(BigDecimal value) {
        return value == null ? "" : value.toPlainString().replace('.', ',');
    }
}

