/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.CandidacySituation;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.PHDProgramCandidacy_Base;
import org.fenixedu.academic.domain.util.workflow.Operation;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class PHDProgramCandidacy
extends PHDProgramCandidacy_Base {
    public PHDProgramCandidacy(Person person, ExecutionDegree executionDegree) {
        this.init(person, executionDegree);
    }

    public PHDProgramCandidacy(Person person) {
        this.init(person);
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)I18N.getLocale(), (String)"label.phd", (String[])new String[0]) + " - " + this.getDegreeInformation();
    }

    private String getDegreeInformation() {
        if (this.getExecutionDegree() != null) {
            return this.getDegreeCurricularPlan().getName() + " - " + this.getExecutionYear().getYear();
        }
        if (this.getRegistration() != null) {
            return this.getRegistration().getDegreeCurricularPlanName();
        }
        if (this.getCandidacyProcess().hasPhdProgram()) {
            return this.getCandidacyProcess().getPhdProgram().getName().getContent();
        }
        return this.getCandidacyProcess().getPhdProgramFocusArea().getName().getContent();
    }

    public Set<Operation> getOperations(CandidacySituation candidacySituation) {
        return Collections.emptySet();
    }

    protected void moveToNextState(CandidacyOperationType candidacyOperationType, Person person) {
    }

    public String getDefaultState() {
        return null;
    }

    public Map<String, Set<String>> getStateMapping() {
        return Collections.emptyMap();
    }

    public void copyFromStudentCandidacy(StudentCandidacy studentCandidacy) {
        this.setContigent(studentCandidacy.getContigent());
        this.setEntryGrade(studentCandidacy.getEntryGrade());
        this.setEntryPhase(studentCandidacy.getEntryPhase());
        this.setIngressionType(studentCandidacy.getIngressionType());
        this.setApplyForResidence(studentCandidacy.getApplyForResidence());
        this.setNotesAboutResidenceAppliance(studentCandidacy.getNotesAboutResidenceAppliance());
        this.setStudentPersonalDataAuthorizationChoice(studentCandidacy.getStudentPersonalDataAuthorizationChoice());
        this.setDislocatedFromPermanentResidence(studentCandidacy.getDislocatedFromPermanentResidence());
        this.setPlacingOption(studentCandidacy.getPlacingOption());
        this.setGrantOwnerType(studentCandidacy.getGrantOwnerType());
        this.setNumberOfCandidaciesToHigherSchool(studentCandidacy.getNumberOfCandidaciesToHigherSchool());
        this.setNumberOfFlunksOnHighSchool(studentCandidacy.getNumberOfFlunksOnHighSchool());
        this.setHighSchoolType(studentCandidacy.getHighSchoolType());
        this.setMaritalStatus(studentCandidacy.getMaritalStatus());
        this.setProfessionType(studentCandidacy.getProfessionType());
        this.setProfessionalCondition(studentCandidacy.getProfessionalCondition());
        this.setMotherSchoolLevel(studentCandidacy.getMotherSchoolLevel());
        this.setMotherProfessionType(studentCandidacy.getMotherProfessionType());
        this.setMotherProfessionalCondition(studentCandidacy.getMotherProfessionalCondition());
        this.setFatherSchoolLevel(studentCandidacy.getFatherSchoolLevel());
        this.setFatherProfessionType(studentCandidacy.getFatherProfessionType());
        this.setFatherProfessionalCondition(studentCandidacy.getFatherProfessionalCondition());
        this.setSpouseSchoolLevel(studentCandidacy.getSpouseSchoolLevel());
        this.setSpouseProfessionType(studentCandidacy.getSpouseProfessionType());
        this.setSpouseProfessionalCondition(studentCandidacy.getSpouseProfessionalCondition());
        this.setFirstTimeCandidacy(studentCandidacy.getFirstTimeCandidacy());
        this.getPrecedentDegreeInformation().setConclusionGrade(studentCandidacy.getPrecedentDegreeInformation().getConclusionGrade());
        this.getPrecedentDegreeInformation().setConclusionYear(studentCandidacy.getPrecedentDegreeInformation().getConclusionYear());
        this.getPrecedentDegreeInformation().setDegreeDesignation(studentCandidacy.getPrecedentDegreeInformation().getDegreeDesignation());
        this.getPrecedentDegreeInformation().setSchoolLevel(studentCandidacy.getPrecedentDegreeInformation().getSchoolLevel());
        this.getPrecedentDegreeInformation().setOtherSchoolLevel(studentCandidacy.getPrecedentDegreeInformation().getOtherSchoolLevel());
        this.getPrecedentDegreeInformation().setCountry(studentCandidacy.getPrecedentDegreeInformation().getCountry());
        this.getPrecedentDegreeInformation().setInstitution(studentCandidacy.getPrecedentDegreeInformation().getInstitution());
        this.getPrecedentDegreeInformation().setSourceInstitution(studentCandidacy.getPrecedentDegreeInformation().getSourceInstitution());
        this.setExecutionDegree(studentCandidacy.getExecutionDegree());
        this.setRegistration(studentCandidacy.getRegistration());
        this.setGrantOwnerProvider(studentCandidacy.getGrantOwnerProvider());
        this.getCandidacyDocumentsSet().addAll(studentCandidacy.getCandidacyDocumentsSet());
        this.getCandidacySituationsSet().addAll(studentCandidacy.getCandidacySituationsSet());
        this.setSchoolTimeDistrictSubDivisionOfResidence(studentCandidacy.getSchoolTimeDistrictSubDivisionOfResidence());
        this.setCountryOfResidence(studentCandidacy.getCountryOfResidence());
        this.setDistrictSubdivisionOfResidence(studentCandidacy.getDistrictSubdivisionOfResidence());
    }
}

