/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.EctsCompetenceCourseConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsCycleGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsDegreeByCurricularYearConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsDegreeGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsInstitutionByCurricularYearConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsInstitutionConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex$callable$readOrCreateByYear;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex_Base;
import org.fenixedu.academic.domain.degreeStructure.NoEctsComparabilityTableFound;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EctsTableIndex
extends EctsTableIndex_Base {
    public static final Advice advice$readOrCreateByYear = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public EctsTableIndex(AcademicInterval year) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setYear(year);
    }

    public boolean availableAt(DateTime processingDate) {
        return this.getProcessingDate() != null && this.getProcessingDate().isBefore((ReadableInstant)processingDate);
    }

    public static EctsTableIndex readByYear(AcademicInterval year) {
        for (EctsTableIndex index : Bennu.getInstance().getEctsTableIndexSet()) {
            if (!index.getYear().equals(year)) continue;
            return index;
        }
        return null;
    }

    protected static EctsTableIndex readByYearProcessable(AcademicInterval year, DateTime processingDate) {
        EctsTableIndex index = EctsTableIndex.readByYear(year);
        if (index != null && index.availableAt(processingDate)) {
            return index;
        }
        if (year.getPreviousAcademicInterval() != null) {
            return EctsTableIndex.readByYearProcessable(year.getPreviousAcademicInterval(), processingDate);
        }
        throw new NoEctsComparabilityTableFound(year);
    }

    public static EctsTableIndex readOrCreateByYear(AcademicInterval academicInterval) {
        return (EctsTableIndex)((Object)advice$readOrCreateByYear.perform((Callable)new EctsTableIndex$callable$readOrCreateByYear(academicInterval)));
    }

    static /* synthetic */ EctsTableIndex advised$readOrCreateByYear(AcademicInterval year) {
        EctsTableIndex index = EctsTableIndex.readByYear(year);
        return index == null ? new EctsTableIndex(year) : index;
    }

    public EctsCompetenceCourseConversionTable getEnrolmentTableBy(CompetenceCourse competenceCourse) {
        for (EctsConversionTable table : this.getTableSet()) {
            EctsCompetenceCourseConversionTable ccTable;
            if (!(table instanceof EctsCompetenceCourseConversionTable) || !(ccTable = (EctsCompetenceCourseConversionTable)((Object)table)).getCompetenceCourse().equals((Object)competenceCourse)) continue;
            return ccTable;
        }
        return null;
    }

    public EctsDegreeByCurricularYearConversionTable getEnrolmentTableBy(Degree degree, CurricularYear curricularYear) {
        for (EctsConversionTable table : this.getTableSet()) {
            EctsDegreeByCurricularYearConversionTable degreeTable;
            if (!(table instanceof EctsDegreeByCurricularYearConversionTable) || !(degreeTable = (EctsDegreeByCurricularYearConversionTable)((Object)table)).getDegree().equals(degree) || !degreeTable.getCurricularYear().equals(curricularYear)) continue;
            return degreeTable;
        }
        return null;
    }

    public EctsInstitutionByCurricularYearConversionTable getEnrolmentTableBy(Unit unit, CurricularYear curricularYear, CycleType cycleType) {
        for (EctsConversionTable table : this.getTableSet()) {
            EctsInstitutionByCurricularYearConversionTable unitTable;
            if (!(table instanceof EctsInstitutionByCurricularYearConversionTable) || !(unitTable = (EctsInstitutionByCurricularYearConversionTable)((Object)table)).getSchool().equals((Object)unit) || !unitTable.getCurricularYear().equals(curricularYear) || !unitTable.getCycle().equals((Object)cycleType)) continue;
            return unitTable;
        }
        return null;
    }

    public EctsInstitutionConversionTable getEnrolmentTableBy(Unit unit) {
        for (EctsConversionTable table : this.getTableSet()) {
            if (!(table instanceof EctsInstitutionConversionTable)) continue;
            EctsInstitutionConversionTable unitTable = (EctsInstitutionConversionTable)((Object)table);
            return unitTable;
        }
        return null;
    }

    public EctsDegreeGraduationGradeConversionTable getGraduationTableBy(Degree degree, CycleType cycleType) {
        for (EctsConversionTable table : this.getTableSet()) {
            EctsDegreeGraduationGradeConversionTable degreeTable;
            if (!(table instanceof EctsDegreeGraduationGradeConversionTable) || !(degreeTable = (EctsDegreeGraduationGradeConversionTable)((Object)table)).getDegree().equals(degree) || degree.getDegreeType().isComposite() && !degreeTable.getCycle().equals((Object)cycleType)) continue;
            return degreeTable;
        }
        return null;
    }

    public EctsCycleGraduationGradeConversionTable getGraduationTableBy(CycleType cycleType) {
        for (EctsConversionTable table : this.getTableSet()) {
            EctsCycleGraduationGradeConversionTable cycleTable;
            if (!(table instanceof EctsCycleGraduationGradeConversionTable) || !(cycleTable = (EctsCycleGraduationGradeConversionTable)((Object)table)).getCycle().equals((Object)cycleType)) continue;
            return cycleTable;
        }
        return null;
    }

    public static Grade convertGradeToEcts(CurricularCourse curricularCourse, CurriculumLine curriculumLine, Grade grade, DateTime processingDate) {
        EctsTableIndex index = EctsTableIndex.readByYearProcessable(curriculumLine.getExecutionYear().getAcademicInterval(), processingDate);
        return index.convertGradeToEcts(curricularCourse, curriculumLine, grade);
    }

    public static Grade convertGradeToEcts(Degree degree, CurriculumLine curriculumLine, Grade grade, DateTime processingDate) {
        EctsTableIndex index = EctsTableIndex.readByYearProcessable(curriculumLine.getExecutionYear().getAcademicInterval(), processingDate);
        return index.convertGradeToEcts(degree, curriculumLine, grade);
    }

    protected Grade convertGradeToEcts(CurricularCourse curricularCourse, CurriculumLine curriculumLine, Grade grade) {
        EctsCompetenceCourseConversionTable table;
        if (curricularCourse.getCompetenceCourse() != null && (table = this.getEnrolmentTableBy(curricularCourse.getCompetenceCourse())) != null) {
            return ((EctsConversionTable)((Object)table)).convert(grade);
        }
        return this.convertGradeToEcts(curricularCourse.getDegree(), curriculumLine, grade);
    }

    protected Grade convertGradeToEcts(Degree degree, CurriculumLine curriculumLine, Grade grade) {
        if (curriculumLine.getParentCycleCurriculumGroup() == null) {
            return this.convertGradeToEcts(Bennu.getInstance().getInstitutionUnit(), curriculumLine, grade);
        }
        CurricularYear curricularYear = CurricularYear.readByYear(curriculumLine.getParentCycleCurriculumGroup().getCurriculum(curriculumLine.getExecutionYear()).getCurricularYear());
        EctsDegreeByCurricularYearConversionTable table = this.getEnrolmentTableBy(degree, curricularYear);
        if (table != null) {
            return ((EctsConversionTable)((Object)table)).convert(grade);
        }
        return this.convertGradeToEcts(Bennu.getInstance().getInstitutionUnit(), curriculumLine, curricularYear, grade);
    }

    protected Grade convertGradeToEcts(Unit unit, CurriculumLine curriculumLine, CurricularYear curricularYear, Grade grade) {
        CycleType cycleType = curriculumLine.getParentCycleCurriculumGroup().getCycleType();
        EctsInstitutionByCurricularYearConversionTable table = this.getEnrolmentTableBy(unit, curricularYear, cycleType);
        if (table != null) {
            return ((EctsConversionTable)((Object)table)).convert(grade);
        }
        throw new NoEctsComparabilityTableFound(curriculumLine);
    }

    protected Grade convertGradeToEcts(Unit unit, CurriculumLine curriculumLine, Grade grade) {
        EctsInstitutionConversionTable table = this.getEnrolmentTableBy(unit);
        if (table != null) {
            return ((EctsConversionTable)((Object)table)).convert(grade);
        }
        throw new NoEctsComparabilityTableFound(curriculumLine);
    }

    public static EctsGraduationGradeConversionTable getGraduationGradeConversionTable(Degree degree, CycleType cycleType, AcademicInterval year, DateTime processingDate) {
        EctsTableIndex index = EctsTableIndex.readByYearProcessable(year, processingDate);
        return index.getGraduationGradeConversionTable(degree, cycleType, year);
    }

    protected EctsGraduationGradeConversionTable getGraduationGradeConversionTable(Degree degree, CycleType cycleType, AcademicInterval year) {
        EctsDegreeGraduationGradeConversionTable table = this.getGraduationTableBy(degree, cycleType);
        if (table != null) {
            return table;
        }
        return this.getGraduationGradeConversionTable(Bennu.getInstance().getInstitutionUnit(), cycleType, year);
    }

    protected EctsGraduationGradeConversionTable getGraduationGradeConversionTable(Unit institutionUnit, CycleType cycleType, AcademicInterval year) {
        EctsCycleGraduationGradeConversionTable table = this.getGraduationTableBy(cycleType);
        if (table != null) {
            return table;
        }
        throw new NoEctsComparabilityTableFound(year, cycleType);
    }
}

