/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationForIndividualCandidacyFactory;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusAlert;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusAlertEntityType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusCandidacyProcessExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusIndividualCandidacyProcessExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ExecutedActionType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.NationalIdCardAvoidanceQuestion;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ReceptionEmailExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.StorkAttributesList;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplication;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserLoginPeriod;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobilityIndividualApplicationProcess
extends MobilityIndividualApplicationProcess_Base {
    private static final Logger logger = LoggerFactory.getLogger(MobilityIndividualApplicationProcess.class);
    private static List<Activity> activities = new ArrayList<Activity>();

    public MobilityIndividualApplicationProcess() {
    }

    public MobilityIndividualApplicationProcess(MobilityIndividualApplicationProcessBean bean) {
        this();
        this.init(bean);
        this.setSpecificIndividualCandidacyDocumentFiles(bean);
        this.setValidatedByMobilityCoordinator(false);
        this.setValidatedByGri(false);
        this.setPersonalFieldsFromStork(bean.getPersonalFieldsFromStork() != null ? bean.getPersonalFieldsFromStork() : StorkAttributesList.EMPTY);
    }

    protected void init(IndividualCandidacyProcessBean bean) {
        this.checkParameters(bean.getCandidacyProcess());
        if (bean.getPublicCandidacyHashCode() == null) {
            throw new DomainException("error.IndividualCandidacy.hash.code.is.null", new String[0]);
        }
        if (this.existsIndividualCandidacyProcessForDocumentId(bean.getCandidacyProcess(), bean.getPersonBean().getIdDocumentType(), bean.getPersonBean().getDocumentIdNumber())) {
            throw new DomainException("error.IndividualCandidacy.exists.for.same.document.id", new String[0]);
        }
        if (!StringUtils.isEmpty((String)bean.getPersonBean().getEidentifier()) && this.existsIndividualCandidacyProcessForEidentifier(bean.getCandidacyProcess(), bean.getPersonBean().getEidentifier())) {
            throw new DomainException("error.individualCandidacy.exists.for.same.eIdentifier", new String[0]);
        }
        this.setCandidacyProcess(bean.getCandidacyProcess());
        this.createIndividualCandidacy(bean);
        this.setCandidacyHashCode(bean.getPublicCandidacyHashCode());
        this.setCandidacyDocumentFiles(bean);
        this.setProcessCodeForThisIndividualCandidacy(bean.getCandidacyProcess());
    }

    protected boolean existsIndividualCandidacyProcessForEidentifier(CandidacyProcess process2, String eidentifier) {
        return process2.getOpenChildProcessByEidentifier(eidentifier) != null;
    }

    private void setSpecificIndividualCandidacyDocumentFiles(MobilityIndividualApplicationProcessBean bean) {
    }

    protected void checkParameters(CandidacyProcess process2) {
        if (process2 == null || process2.getCandidacyPeriod() == null) {
            throw new DomainException("error.SecondCycleIndividualCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    protected void createIndividualCandidacy(IndividualCandidacyProcessBean bean) {
        new MobilityIndividualApplication(this, (MobilityIndividualApplicationProcessBean)bean);
    }

    public boolean canExecuteActivity(User userView) {
        return MobilityIndividualApplicationProcess.isAllowedToManageProcess(this, userView) || RoleType.SCIENTIFIC_COUNCIL.isMember(userView.getPerson().getUser()) || RoleType.COORDINATOR.isMember(userView.getPerson().getUser()) || this.isCoordinatorOfProcess(userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    private static boolean isAllowedToManageProcess(MobilityIndividualApplicationProcess process2, User userView) {
        if (process2 == null || process2.getCandidacy() == null) {
            return false;
        }
        return AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, (AcademicProgram)((Object)process2.getCandidacy().getSelectedDegree()), userView.getPerson().getUser());
    }

    private static boolean isInternationalRelationsOfficer(User userView) {
        return RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(userView.getPerson().getUser());
    }

    private static boolean isManager(User userView) {
        return RoleType.MANAGER.isMember(userView.getPerson().getUser());
    }

    private boolean isCoordinatorOfProcess(User userView) {
        if (userView.getPerson().getTeacher() == null) {
            return false;
        }
        return ((MobilityApplicationProcess)((Object)this.getCandidacyProcess())).isTeacherErasmusCoordinatorForDegree(userView.getPerson().getTeacher(), this.getCandidacy().getSelectedDegree());
    }

    public final MobilityIndividualApplication getCandidacy() {
        return (MobilityIndividualApplication)((Object)super.getCandidacy());
    }

    public Degree getCandidacySelectedDegree() {
        return this.getCandidacy().getSelectedDegree();
    }

    public boolean hasCandidacyForSelectedDegree(Degree degree) {
        return this.getCandidacySelectedDegree() == degree;
    }

    public String getCandidacyNotes() {
        return this.getCandidacy().getNotes();
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    public Boolean isCandidacyProcessComplete() {
        return null;
    }

    public boolean getIsCandidacyProcessWithEidentifer() {
        return !StringUtils.isEmpty((String)this.getPersonalDetails().getEidentifier());
    }

    protected void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile documentFile) {
        IndividualCandidacyDocumentFileType type = documentFile.getCandidacyFileType();
        IndividualCandidacyDocumentFile file = this.getActiveFileForType(type);
        if (file != null) {
            file.setCandidacyFileActive(false);
        }
    }

    public List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles() {
        ArrayList<IndividualCandidacyDocumentFileType> missingDocumentFiles = new ArrayList<IndividualCandidacyDocumentFileType>();
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PHOTO) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PHOTO);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION);
        }
        if (!this.getCandidacy().getMobilityProgram().getRegistrationProtocol().isOnlyAllowedDegreeEnrolment() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.LEARNING_AGREEMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.LEARNING_AGREEMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.CV_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.TRANSCRIPT_OF_RECORDS) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.TRANSCRIPT_OF_RECORDS);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.ENGLISH_LEVEL_DECLARATION) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.ENGLISH_LEVEL_DECLARATION);
        }
        return missingDocumentFiles;
    }

    private MobilityIndividualApplicationProcess editCandidacyInformation(MobilityIndividualApplicationProcessBean bean) {
        this.getCandidacy().getMobilityStudentData().edit(bean.getMobilityStudentDataBean());
        PrecedentDegreeInformationForIndividualCandidacyFactory.edit(bean);
        return this;
    }

    private MobilityIndividualApplicationProcess editDegreeAndCoursesInformation(MobilityIndividualApplicationProcessBean bean) {
        bean.getMobilityStudentDataBean().setMobilityAgreement();
        this.editPrecedentDegreeInformation(bean);
        this.getCandidacy().editDegreeAndCoursesInformation(bean);
        return this;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.CaseHandlingResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public List<CurricularCourse> getSortedSelectedCurricularCourses() {
        ArrayList<CurricularCourse> curricularCourses = new ArrayList<CurricularCourse>(this.getCandidacy().getCurricularCoursesSet());
        Collections.sort(curricularCourses, CurricularCourse.COMPARATOR_BY_NAME);
        return curricularCourses;
    }

    public List<ErasmusAlert> getAlertsNotViewed() {
        ArrayList<ErasmusAlert> alertsNotViewed = new ArrayList<ErasmusAlert>();
        CollectionUtils.select((Collection)this.getAlertSet(), arg0 -> {
            ErasmusAlert alert = (ErasmusAlert)((Object)((Object)arg0));
            return alert.isToFire();
        }, alertsNotViewed);
        Collections.sort(alertsNotViewed, Collections.reverseOrder(ErasmusAlert.WHEN_CREATED_COMPARATOR));
        return alertsNotViewed;
    }

    public ErasmusAlert getMostRecentAlert() {
        ArrayList alerts = new ArrayList(this.getAlertSet());
        Collections.sort(alerts, Collections.reverseOrder(ErasmusAlert.WHEN_CREATED_COMPARATOR));
        return (ErasmusAlert)((Object)alerts.iterator().next());
    }

    public boolean isProcessWithMostRecentAlertMessageNotViewed() {
        List<ErasmusAlert> alertsNotViewed = this.getAlertsNotViewed();
        return !alertsNotViewed.isEmpty() && alertsNotViewed.iterator().next() == this.getMostRecentAlert();
    }

    public boolean isStudentAccepted() {
        return this.isStudentAcceptedAtDate(new DateTime());
    }

    public boolean isStudentAcceptedAtDate(DateTime dateTime) {
        return !this.isCandidacyCancelled() && !this.isCandidacyRejected() && this.getValidatedByMobilityCoordinator() != false && this.getValidatedByGri() != false && (this.getCandidacy().getMostRecentApprovedLearningAgreement() != null && this.getCandidacy().getMostRecentApprovedLearningAgreement().getCreationDate().isBefore((ReadableInstant)dateTime) || this.getMobilityProgram().getRegistrationProtocol().isOnlyAllowedDegreeEnrolment());
    }

    public boolean isStudentAcceptedAndNotifiedAtDate(DateTime dateTime) {
        return this.isStudentAcceptedAtDate(dateTime) && this.getCandidacy().hasProcessWithAcceptNotificationAtDate(dateTime);
    }

    public boolean isStudentAcceptedAndNotified() {
        return this.isStudentAcceptedAndNotifiedAtDate(new DateTime());
    }

    public boolean isStudentNotifiedWithReceptionEmail() {
        return !this.getAllReceptionEmailNotifications().isEmpty();
    }

    List<ReceptionEmailExecutedAction> getAllReceptionEmailNotifications() {
        ArrayList<ReceptionEmailExecutedAction> list = new ArrayList<ReceptionEmailExecutedAction>();
        for (ErasmusCandidacyProcessExecutedAction executedAction : ((MobilityApplicationProcess)((Object)this.getCandidacyProcess())).getErasmusCandidacyProcessExecutedActionSet()) {
            if (!executedAction.isReceptionEmailExecutedAction() || !executedAction.getSubjectMobilityIndividualApplicationProcessSet().contains((Object)this)) continue;
            list.add((ReceptionEmailExecutedAction)((Object)executedAction));
        }
        Collections.sort(list, Collections.reverseOrder(new BeanComparator("whenOccured")));
        return list;
    }

    public DateTime getLastReceptionEmailSent() {
        List<ReceptionEmailExecutedAction> list = this.getAllReceptionEmailNotifications();
        return list.isEmpty() ? null : list.iterator().next().getWhenOccured();
    }

    public String getErasmusCandidacyStateDescription() {
        String registeredMessage;
        String string = registeredMessage = this.getCandidacy().getRegistration() != null ? "/" + BundleUtil.getString((String)"resources.CandidateResources", (String)"label.erasmus.candidacy.state.registered", (String[])new String[0]) : "";
        if (this.isCandidacyCancelled()) {
            return BundleUtil.getString((String)"resources.CandidateResources", (String)"label.erasmus.candidacy.state.description.cancelled", (String[])new String[0]) + registeredMessage;
        }
        if (this.isCandidacyRejected()) {
            return BundleUtil.getString((String)"resources.CandidateResources", (String)"label.erasmus.candidacy.state.description.rejected", (String[])new String[0]) + registeredMessage;
        }
        if (this.isCandidacyInStandBy() && this.isStudentAccepted()) {
            return BundleUtil.getString((String)"resources.CandidateResources", (String)"label.erasmus.candidacy.state.description.student.accepted", (String[])new String[0]) + registeredMessage;
        }
        return BundleUtil.getString((String)"resources.CandidateResources", (String)"label.erasmus.candidacy.state.description.student.pending", (String[])new String[0]) + registeredMessage;
    }

    private void createRegistration() {
        if (this.getCandidacy().getCandidacyProcess().getDegreeCurricularPlan(this).isFirstCycle()) {
            this.getCandidacy().createRegistration(this.getDegreeCurricularPlan(this), CycleType.FIRST_CYCLE, null);
        } else {
            this.getCandidacy().createRegistration(this.getDegreeCurricularPlan(this), CycleType.SECOND_CYCLE, null);
        }
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(MobilityIndividualApplicationProcess candidacyProcess) {
        return candidacyProcess.getCandidacySelectedDegree().getLastActiveDegreeCurricularPlan();
    }

    private void enrol() {
        this.getCandidacy().enrol();
    }

    public DateTime getMostRecentSentEmailAcceptedStudentActionWhenOccured() {
        if (this.getCandidacy().getMostRecentApprovedLearningAgreement() == null) {
            return null;
        }
        return this.getCandidacy().getMostRecentApprovedLearningAgreement().getMostRecentSentLearningAgreementActionWhenOccured();
    }

    public MobilityProgram getMobilityProgram() {
        return this.getCandidacy().getMobilityProgram();
    }

    static {
        activities.add(new CancelCandidacy());
        activities.add(new EditCandidacyPersonalInformation());
        activities.add(new EditCandidacyInformation());
        activities.add(new EditDegreeAndCoursesInformation());
        activities.add(new SendEmailForApplicationSubmission());
        activities.add(new EditPublicCandidacyPersonalInformation());
        activities.add(new EditPublicCandidacyInformation());
        activities.add(new EditPublicDegreeAndCoursesInformation());
        activities.add(new SetGriValidation());
        activities.add(new SetCoordinatorValidation());
        activities.add(new VisualizeAlerts());
        activities.add(new EditDocuments());
        activities.add(new EditPublicCandidacyDocumentFile());
        activities.add(new CreateStudentData());
        activities.add(new SetEIdentifierForTesting());
        activities.add(new BindLinkSubmitedIndividualCandidacyWithEidentifier());
        activities.add(new UploadApprovedLearningAgreement());
        activities.add(new ViewApprovedLearningAgreements());
        activities.add(new MarkAlertAsViewed());
        activities.add(new SendEmailToAcceptedStudent());
        activities.add(new SendEmailToCandidateForMissingDocuments());
        activities.add(new RevokeDocumentFile());
        activities.add(new RejectCandidacy());
        activities.add(new CreateRegistration());
        activities.add(new RevertCandidacyToStandBy());
        activities.add(new EnrolStudent());
        activities.add(new AnswerNationalIdCardAvoidanceOnSubmissionQuestion());
    }

    private static class AnswerNationalIdCardAvoidanceOnSubmissionQuestion
    extends Activity<MobilityIndividualApplicationProcess> {
        private AnswerNationalIdCardAvoidanceOnSubmissionQuestion() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!NationalIdCardAvoidanceQuestion.UNANSWERED.equals((Object)process2.getCandidacy().getNationalIdCardAvoidanceQuestion())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)object;
            MobilityIndividualApplication candidacy = process2.getCandidacy();
            candidacy.answerNationalIdCardAvoidanceOnSubmission(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class EnrolStudent
    extends Activity<MobilityIndividualApplicationProcess> {
        private EnrolStudent() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacy().getRegistration() == null) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return true;
        }
    }

    private static class RevertCandidacyToStandBy
    extends Activity<MobilityIndividualApplicationProcess> {
        private RevertCandidacyToStandBy() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyRejected()) {
                return;
            }
            if (process2.isCandidacyCancelled()) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.revertToStandBy(userView.getPerson());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return true;
        }
    }

    private static class EnrolOnFirstSemester
    extends Activity<MobilityIndividualApplicationProcess> {
        private EnrolOnFirstSemester() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacy().getRegistration() == null) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isStudentAcceptedAndNotified()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isStudentNotifiedWithReceptionEmail()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.enrol();
            return process2;
        }
    }

    private static class CreateRegistration
    extends Activity<MobilityIndividualApplicationProcess> {
        private CreateRegistration() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacy().getRegistration() != null) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isStudentAcceptedAndNotified()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.createRegistration();
            return process2;
        }
    }

    private static class RejectCandidacy
    extends Activity<MobilityIndividualApplicationProcess> {
        private RejectCandidacy() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
            if (MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                return;
            }
            if (MobilityIndividualApplicationProcess.isManager(userView)) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.rejectCandidacy(userView.getPerson());
            return process2;
        }
    }

    protected static class RevokeDocumentFile
    extends Activity<MobilityIndividualApplicationProcess> {
        protected RevokeDocumentFile() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView) && !MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            ((CandidacyProcessDocumentUploadBean)object).getDocumentFile().setCandidacyFileActive(Boolean.FALSE);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class SendEmailToCandidateForMissingDocuments
    extends Activity<MobilityIndividualApplicationProcess> {
        private SendEmailToCandidateForMissingDocuments() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isProcessMissingRequiredDocumentFiles()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityApplicationPeriod candidacyPeriod = (MobilityApplicationPeriod)((Object)process2.getCandidacyProcess().getCandidacyPeriod());
            MobilityEmailTemplate emailTemplateFor = candidacyPeriod.getEmailTemplateFor(MobilityEmailTemplateType.MISSING_DOCUMENTS);
            emailTemplateFor.sendEmailFor(process2.getCandidacyHashCode());
            new ErasmusIndividualCandidacyProcessExecutedAction(process2, ExecutedActionType.SENT_EMAIL_FOR_MISSING_REQUIRED_DOCUMENTS);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class SendEmailToAcceptedStudent
    extends Activity<MobilityIndividualApplicationProcess> {
        private SendEmailToAcceptedStudent() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isStudentAccepted()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityApplicationPeriod candidacyPeriod = (MobilityApplicationPeriod)((Object)process2.getCandidacyProcess().getCandidacyPeriod());
            MobilityEmailTemplate emailTemplateFor = candidacyPeriod.getEmailTemplateFor(process2.getMobilityProgram(), MobilityEmailTemplateType.CANDIDATE_ACCEPTED);
            emailTemplateFor.sendEmailFor(process2.getCandidacyHashCode());
            new ApprovedLearningAgreementExecutedAction(process2.getCandidacy().getMostRecentApprovedLearningAgreement(), ExecutedActionType.SENT_EMAIL_ACCEPTED_STUDENT);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class MarkAlertAsViewed
    extends Activity<MobilityIndividualApplicationProcess> {
        private MarkAlertAsViewed() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            ErasmusAlert alert = (ErasmusAlert)((Object)object);
            alert.setFireDate(new DateTime());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class ViewApprovedLearningAgreements
    extends Activity<MobilityIndividualApplicationProcess> {
        private ViewApprovedLearningAgreements() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (MobilityIndividualApplicationProcess.isManager(userView)) {
                return;
            }
            if (MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                return;
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return true;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }
    }

    private static class UploadApprovedLearningAgreement
    extends Activity<MobilityIndividualApplicationProcess> {
        private UploadApprovedLearningAgreement() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (MobilityIndividualApplicationProcess.isManager(userView)) {
                return;
            }
            if (MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                return;
            }
            if (process2.isCoordinatorOfProcess(userView)) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.getCandidacy().addApprovedLearningAgreements((ApprovedLearningAgreementDocumentFile)((Object)object));
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return true;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return true;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class BindLinkSubmitedIndividualCandidacyWithEidentifier
    extends Activity<MobilityIndividualApplicationProcess> {
        private BindLinkSubmitedIndividualCandidacyWithEidentifier() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!StringUtils.isEmpty((String)process2.getPersonalDetails().getEidentifier())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            String eidentifier = (String)object;
            if (StringUtils.isEmpty((String)eidentifier)) {
                throw new DomainException("error.erasmus.candidacy.eidentifer.must.not.be.empty", new String[0]);
            }
            MobilityApplicationProcess parentProcess = (MobilityApplicationProcess)((Object)process2.getCandidacyProcess());
            if (parentProcess.getOpenChildProcessByEidentifier(eidentifier) != null) {
                throw new DomainException("error.erasmus.candidacy.already.exists.with.eidentifier", new String[0]);
            }
            process2.getPersonalDetails().getPerson().setEidentifier(eidentifier);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class SetEIdentifierForTesting
    extends Activity<MobilityIndividualApplicationProcess> {
        private SetEIdentifierForTesting() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)object;
            String eidentifier = bean.getPersonBean().getEidentifier();
            process2.getPersonalDetails().getPerson().setEidentifier(eidentifier);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.TRUE;
        }
    }

    private static class CreateStudentData
    extends Activity<MobilityIndividualApplicationProcess> {
        private CreateStudentData() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            if (process2.getPersonalDetails().getPerson().getStudent() == null) {
                new Student(process2.getPersonalDetails().getPerson(), null);
                UserLoginPeriod.createOpenPeriod((User)process2.getPersonalDetails().getPerson().getUser());
                if (StringUtils.isEmpty((String)process2.getPersonalDetails().getPerson().getUsername())) {
                    throw new DomainException("error.erasmus.create.user", new String[]{null, "User not created"});
                }
            }
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.TRUE;
        }
    }

    private static class EditPublicCandidacyDocumentFile
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditPublicCandidacyDocumentFile() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditDocuments
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditDocuments() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }
    }

    private static class VisualizeAlerts
    extends Activity<MobilityIndividualApplicationProcess> {
        private VisualizeAlerts() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.TRUE;
        }
    }

    private static class SetCoordinatorValidation
    extends Activity<MobilityIndividualApplicationProcess> {
        private SetCoordinatorValidation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)object;
            process2.setValidatedByMobilityCoordinator(bean.getValidatedByErasmusCoordinator());
            if (bean.getCreateAlert().booleanValue()) {
                new ErasmusAlert(process2, bean.getSendEmail(), new LocalDate(), new MultiLanguageString(bean.getAlertSubject()), new MultiLanguageString(bean.getAlertBody()), ErasmusAlertEntityType.COORDINATOR);
            }
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.TRUE;
        }
    }

    private static class SetGriValidation
    extends Activity<MobilityIndividualApplicationProcess> {
        private SetGriValidation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)object;
            process2.setValidatedByGri(bean.getValidatedByGri());
            if (bean.getCreateAlert().booleanValue()) {
                ErasmusAlert alert = new ErasmusAlert(process2, bean.getSendEmail(), new LocalDate(), new MultiLanguageString(bean.getAlertSubject()), new MultiLanguageString(bean.getAlertBody()), ErasmusAlertEntityType.GRI);
                alert.setFireDate(new DateTime());
            }
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicDegreeAndCoursesInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditPublicDegreeAndCoursesInformation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (process2.isCandidacyCancelled() || process2.isCandidacyAccepted() || process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2.editDegreeAndCoursesInformation((MobilityIndividualApplicationProcessBean)object);
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditPublicCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2.editCandidacyInformation((MobilityIndividualApplicationProcessBean)object);
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyPersonalInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditPublicCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((MobilityIndividualApplicationProcessBean)object).getPersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class SendEmailForApplicationSubmission
    extends Activity<MobilityIndividualApplicationProcess> {
        private SendEmailForApplicationSubmission() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            DegreeOfficePublicCandidacyHashCode hashCode = (DegreeOfficePublicCandidacyHashCode)((Object)object);
            hashCode.sendEmailForApplicationSuccessfullySubmited();
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditDegreeAndCoursesInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditDegreeAndCoursesInformation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView) && !MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2.editDegreeAndCoursesInformation((MobilityIndividualApplicationProcessBean)object);
        }
    }

    private static class EditCandidacyInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView) && !MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            return process2.editCandidacyInformation((MobilityIndividualApplicationProcessBean)object);
        }
    }

    private static class EditCandidacyPersonalInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        private EditCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView) && !MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            MobilityIndividualApplicationProcessBean bean = (MobilityIndividualApplicationProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            return process2;
        }
    }

    private static class CancelCandidacy
    extends Activity<MobilityIndividualApplicationProcess> {
        private CancelCandidacy() {
        }

        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
            if (!MobilityIndividualApplicationProcess.isAllowedToManageProcess(process2, userView) && !MobilityIndividualApplicationProcess.isInternationalRelationsOfficer(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || !process2.isCandidacyInStandBy() || process2.hasAnyPaymentForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess process2, User userView, Object object) {
            process2.cancelCandidacy(userView.getPerson());
            return process2;
        }
    }

    @StartActivity
    public static class IndividualCandidacyInformation
    extends Activity<MobilityIndividualApplicationProcess> {
        @Override
        public void checkPreConditions(MobilityIndividualApplicationProcess process2, User userView) {
        }

        @Override
        protected MobilityIndividualApplicationProcess executeActivity(MobilityIndividualApplicationProcess dummy, User userView, Object object) {
            return new MobilityIndividualApplicationProcess((MobilityIndividualApplicationProcessBean)object);
        }
    }
}

