/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.candidacy.MeasurementTest;
import org.fenixedu.academic.domain.candidacy.MeasurementTestRoom;
import org.fenixedu.academic.domain.candidacy.MeasurementTestShift_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class MeasurementTestShift
extends MeasurementTestShift_Base {
    public static Comparator<MeasurementTestShift> COMPARATOR_BY_NAME = new Comparator<MeasurementTestShift>(){

        @Override
        public int compare(MeasurementTestShift leftMeasurementTestShift, MeasurementTestShift rightMeasurementTestShift) {
            int comparationResult = leftMeasurementTestShift.getName().compareTo(rightMeasurementTestShift.getName());
            return comparationResult == 0 ? leftMeasurementTestShift.getExternalId().compareTo(rightMeasurementTestShift.getExternalId()) : comparationResult;
        }
    };

    protected MeasurementTestShift() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    public MeasurementTestShift(String name, DateTime date, MeasurementTest test) {
        this();
        String[] args2 = new String[]{};
        if (name == null || name.isEmpty()) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestShift.name.cannot.be.null", args2);
        }
        String[] args = new String[]{};
        if (date == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestShift.date.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (test == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestShift.test.cannot.be.null", args1);
        }
        this.setDate(date);
        this.setName(name);
        this.setTest(test);
    }

    public MeasurementTestRoom getAvailableRoom() {
        for (MeasurementTestRoom room : this.getSortedRooms()) {
            if (!room.isAvailable()) continue;
            return room;
        }
        return null;
    }

    public boolean hasAvailableRoom() {
        return this.getAvailableRoom() != null;
    }

    public SortedSet<MeasurementTestRoom> getSortedRooms() {
        TreeSet<MeasurementTestRoom> result = new TreeSet<MeasurementTestRoom>(MeasurementTestRoom.COMPARATOR_BY_ROOM_ORDER);
        result.addAll(this.getRoomsSet());
        return result;
    }

    public MeasurementTestRoom getRoomByName(String name) {
        for (MeasurementTestRoom room : this.getRoomsSet()) {
            if (!room.getName().equals(name)) continue;
            return room;
        }
        return null;
    }

    static {
        MeasurementTestShift.getRelationMeasurementTestShiftMeasurementTest().addListener((RelationListener)new RelationAdapter<MeasurementTest, MeasurementTestShift>(){

            public void beforeAdd(MeasurementTest test, MeasurementTestShift toAdd) {
                if (toAdd != null && test != null && test.getShiftByName(toAdd.getName()) != null) {
                    throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTestShift.already.contains.shift.with.same.name", new String[0]);
                }
            }
        });
    }
}

