/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.EnrolmentCertificateRequestPR_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentCertificateRequest;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class EnrolmentCertificateRequestPR
extends EnrolmentCertificateRequestPR_Base {
    protected EnrolmentCertificateRequestPR() {
    }

    public EnrolmentCertificateRequestPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this();
        this.init(EntryType.ENROLMENT_CERTIFICATE_REQUEST_FEE, EventType.ENROLMENT_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        CertificateRequestEvent requestEvent = (CertificateRequestEvent)((Object)event);
        Money totalAmountToPay = this.calculateAmountToPayWithUnits(requestEvent, true).add(this.calculateAmountToPayForPages(requestEvent));
        return totalAmountToPay;
    }

    private Money calculateAmountToPayWithUnits(CertificateRequestEvent requestEvent, boolean checkUrgency) {
        Money total = checkUrgency && this.isUrgent(requestEvent) ? this.getBaseAmount().multiply(2) : this.getBaseAmount();
        EnrolmentCertificateRequest request = (EnrolmentCertificateRequest)((Object)requestEvent.getAcademicServiceRequest());
        if (request.isDetailed()) {
            total = total.add(this.getAmountForUnits((Event)((Object)requestEvent)));
        }
        return total;
    }

    public EnrolmentCertificateRequestPR edit(Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.deactivate();
        return new EnrolmentCertificateRequestPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }
}

