/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentGroupingGroup;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="grouping")
public class GroupingGroup
extends FenixGroup {
    private static final long serialVersionUID = 4708634747611078101L;
    @GroupArgument
    private Grouping grouping;

    private GroupingGroup() {
    }

    private GroupingGroup(Grouping grouping) {
        this();
        this.grouping = grouping;
    }

    public static GroupingGroup get(Grouping grouping) {
        return new GroupingGroup(grouping);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.grouping.getName()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (Attends attend : this.grouping.getAttendsSet()) {
            User user = attend.getRegistration().getStudent().getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        return user != null && this.getMembers().contains(user);
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentGroupingGroup.getInstance(this.grouping);
    }

    public boolean equals(Object object) {
        if (object instanceof GroupingGroup) {
            return Objects.equal((Object)((Object)this.grouping), (Object)((Object)((GroupingGroup)((Object)object)).grouping));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.grouping});
    }
}

