/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftEnrolment_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;

public class ShiftEnrolment
extends ShiftEnrolment_Base {
    public static final Comparator<ShiftEnrolment> COMPARATOR_BY_DATE = new Comparator<ShiftEnrolment>(){

        @Override
        public int compare(ShiftEnrolment o1, ShiftEnrolment o2) {
            int c = o1.getCreatedOn().compareTo((ReadableInstant)o2.getCreatedOn());
            return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
        }
    };

    public ShiftEnrolment(Shift shift, Registration registration) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setRegistration(registration);
        this.setShift(shift);
        this.setCreatedOn(new DateTime());
    }

    public void delete() {
        this.setShift(null);
        this.setRegistration(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public boolean hasRegistration(Registration registration) {
        return this.getRegistration() == registration;
    }
}

