/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher.executionCourse;

import com.google.common.base.Strings;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.portal.servlet.PortalLayoutInjector;
import pt.ist.fenixframework.FenixFramework;

public abstract class ExecutionCourseBaseAction
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.propageIds(request);
        ExecutionCourseBaseAction.propagateLayoutContextIDs(request);
        return super.execute(mapping, actionForm, request, response);
    }

    protected void propageIds(HttpServletRequest request) {
        ExecutionCourseBaseAction.propageContextIds(request);
    }

    public static void propageContextIds(HttpServletRequest request) {
        String executionCourseID = request.getParameter("executionCourseID");
        if (Strings.isNullOrEmpty((String)executionCourseID)) {
            executionCourseID = request.getParameter("objectCode");
        }
        if (executionCourseID != null && executionCourseID.length() > 0) {
            Professorship professorship = ExecutionCourseBaseAction.findProfessorship(request, executionCourseID);
            request.setAttribute("professorship", (Object)professorship);
            request.setAttribute("executionCourse", (Object)professorship.getExecutionCourse());
            request.setAttribute("executionCourseID", (Object)executionCourseID);
        }
    }

    public static void propagateLayoutContextIDs(HttpServletRequest request) {
        String executionCourseID = request.getParameter("executionCourseID");
        if (Strings.isNullOrEmpty((String)executionCourseID)) {
            executionCourseID = request.getParameter("objectCode");
        }
        if (!Strings.isNullOrEmpty((String)executionCourseID)) {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            Professorship professorship = ExecutionCourseBaseAction.findProfessorship(request, executionCourseID);
            HashMap<String, Object> requestContext = new HashMap<String, Object>();
            requestContext.put("professorship", (Object)professorship);
            requestContext.put("executionCourse", (Object)executionCourse);
            PortalLayoutInjector.addContextExtension(requestContext);
        }
    }

    protected ExecutionCourse getExecutionCourse(HttpServletRequest request) {
        return (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
    }

    private static Professorship findProfessorship(HttpServletRequest request, String executionCourseID) {
        Person person = AccessControl.getPerson();
        if (person != null) {
            for (Professorship professorship : person.getProfessorshipsSet()) {
                ExecutionCourse executionCourse = professorship.getExecutionCourse();
                if (!executionCourse.getExternalId().equals(executionCourseID)) continue;
                return professorship;
            }
        }
        throw new RuntimeException("User is not authorized to manage the selected course!");
    }
}

