/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.service.services.coordinator.AddCoordinator;
import org.fenixedu.academic.service.services.coordinator.ReadCoordinationResponsibility;
import org.fenixedu.academic.service.services.coordinator.ReadCoordinationTeam;
import org.fenixedu.academic.service.services.coordinator.RemoveCoordinators;
import org.fenixedu.academic.service.services.exceptions.ExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.masterDegree.administrativeOffice.commons.ReadExecutionDegreesByDegreeCurricularPlanID;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/viewCoordinationTeam", module="coordinator", formBean="addCoordinator", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="chooseExecutionYear", path="/coordinator/coordinationTeam/chooseExecutionYear.jsp"), @Forward(name="coordinationTeam", path="/coordinator/coordinationTeam/viewCoordinationTeam.jsp"), @Forward(name="addCoordinator", path="/coordinator/coordinationTeam/addCoordinator.jsp"), @Forward(name="sucess", path="/coordinator/viewCoordinationTeam.do?method=viewTeam"), @Forward(name="noAuthorization", path="/coordinator/student/notAuthorized_bd.jsp")})
public class CoordinationTeamDispatchAction
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward chooseExecutionYear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        String degreeCurricularPlanID = null;
        if (request.getParameter("degreeCurricularPlanID") != null) {
            degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        }
        List<InfoExecutionDegree> executionDegrees = ReadExecutionDegreesByDegreeCurricularPlanID.runReadExecutionDegreesByDegreeCurricularPlanID(degreeCurricularPlanID);
        request.setAttribute("executionDegrees", executionDegrees);
        return mapping.findForward("chooseExecutionYear");
    }

    public ActionForward viewTeam(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        User userView = CoordinationTeamDispatchAction.getUserView(request);
        String degreeCurricularPlanID = null;
        if (request.getParameter("degreeCurricularPlanID") != null) {
            degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        }
        String executionDegreeID = request.getParameter("infoExecutionDegreeId");
        request.setAttribute("infoExecutionDegreeId", (Object)executionDegreeID);
        ActionErrors actionErrors = new ActionErrors();
        Object[] args = new Object[]{executionDegreeID};
        List coordinators = new ArrayList();
        try {
            coordinators = ReadCoordinationTeam.runReadCoordinationTeam(executionDegreeID);
        }
        catch (NotAuthorizedException e) {
            actionErrors.add("error", new ActionError("noAuthorization"));
            this.saveErrors(request, actionErrors);
            return mapping.findForward("noAuthorization");
        }
        catch (FenixServiceException e) {
            actionErrors.add("error", new ActionError(e.getMessage()));
            this.saveErrors(request, actionErrors);
            return mapping.findForward("noAuthorization");
        }
        Boolean result = Boolean.FALSE;
        try {
            result = ReadCoordinationResponsibility.runReadCoordinationResponsibility(executionDegreeID, userView);
        }
        catch (FenixServiceException e) {
            actionErrors.add("error", new ActionError(e.getMessage()));
            this.saveErrors(request, actionErrors);
            return mapping.findForward("noAuthorization");
        }
        request.setAttribute("isResponsible", (Object)result);
        request.setAttribute("coordinators", coordinators);
        return mapping.findForward("coordinationTeam");
    }

    public ActionForward prepareAddCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        User userView = CoordinationTeamDispatchAction.getUserView(request);
        String degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        String infoExecutionDegreeIdString = request.getParameter("infoExecutionDegreeId");
        request.setAttribute("infoExecutionDegreeId", (Object)infoExecutionDegreeIdString);
        Boolean result = new Boolean(false);
        try {
            result = ReadCoordinationResponsibility.runReadCoordinationResponsibility(infoExecutionDegreeIdString, userView);
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        request.setAttribute("isResponsible", (Object)result);
        return mapping.findForward("addCoordinator");
    }

    public ActionForward AddCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        User userView = CoordinationTeamDispatchAction.getUserView(request);
        DynaActionForm teacherForm = (DynaActionForm)form;
        String username = new String((String)teacherForm.get("newCoordinatorUsername"));
        String infoExecutionDegreeIdString = request.getParameter("infoExecutionDegreeId");
        request.setAttribute("infoExecutionDegreeId", (Object)infoExecutionDegreeIdString);
        try {
            AddCoordinator.runAddCoordinator(infoExecutionDegreeIdString, username);
        }
        catch (NonExistingServiceException e) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("unknownTeacher", new ActionError("error.nonExistingTeacher"));
            this.saveErrors(request, actionErrors);
            return this.prepareAddCoordinator(mapping, form, request, response);
        }
        catch (InvalidArgumentsServiceException e) {
            throw new FenixActionException(e);
        }
        catch (ExistingServiceException e) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("existingCoordinator", new ActionError("error.existingTeacher"));
            this.saveErrors(request, actionErrors);
            return this.prepareAddCoordinator(mapping, form, request, response);
        }
        catch (FenixServiceException e) {
            ActionErrors actionErrors = new ActionErrors();
            if (e.getMessage().equals("error.noUserForUsername")) {
                actionErrors.add("unknownTeacher", new ActionError(e.getMessage(), (Object)username, (Object)Unit.getInstitutionAcronym()));
            } else {
                actionErrors.add("unknownTeacher", new ActionError(e.getMessage()));
            }
            this.saveErrors(request, actionErrors);
            return this.prepareAddCoordinator(mapping, form, request, response);
        }
        return mapping.findForward("sucess");
    }

    public ActionForward removeCoordinators(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        DynaActionForm removeCoordinatorsForm = (DynaActionForm)form;
        String[] coordinatorsIds = (String[])removeCoordinatorsForm.get("coordinatorsIds");
        List<String> coordinators = Arrays.asList(coordinatorsIds);
        String infoExecutionDegreeIdString = request.getParameter("infoExecutionDegreeId");
        request.setAttribute("infoExecutionDegreeId", (Object)infoExecutionDegreeIdString);
        try {
            RemoveCoordinators.runRemoveCoordinators(infoExecutionDegreeIdString, coordinators);
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        return this.viewTeam(mapping, form, request, response);
    }
}

