/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResultMessage;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.commons.ExecuteFactoryMethod;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.commons.FenixActionForward;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.struts.base.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public abstract class FenixDispatchAction
extends DispatchAction
implements ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(FenixDispatchAction.class);
    protected static final Bennu rootDomainObject = Bennu.getInstance();
    protected static final String ACTION_MESSAGES_REQUEST_KEY = "FENIX_ACTION_MESSAGES";

    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages actionMessages = new ActionMessages();
        request.setAttribute(ACTION_MESSAGES_REQUEST_KEY, (Object)actionMessages);
        ActionForward actionForward = super.execute(mapping, actionForm, request, response);
        if (!actionMessages.isEmpty()) {
            this.saveMessages(request, actionMessages);
        }
        if (CoreConfiguration.getConfiguration().developmentMode().booleanValue()) {
            logger.info("CLASS: " + ((Object)((Object)this)).getClass().getName() + ", method: " + this.getFromRequest(request, "method"));
        }
        return actionForward;
    }

    protected static User getUserView(HttpServletRequest request) {
        return Authenticate.getUser();
    }

    protected Person getLoggedPerson(HttpServletRequest request) {
        User userView = FenixDispatchAction.getUserView(request);
        return userView == null ? null : userView.getPerson();
    }

    protected ActionForward setError(HttpServletRequest request, ActionMapping mapping, String errorMessage, String forwardPage, Object actionArg) {
        this.addErrorMessage(request, errorMessage, errorMessage, actionArg);
        if (forwardPage != null) {
            return mapping.findForward(forwardPage);
        }
        return mapping.getInputForward();
    }

    protected boolean verifyStringParameterInForm(DynaValidatorForm dynaForm, String field) {
        return dynaForm.get(field) != null && !dynaForm.get(field).equals("");
    }

    protected boolean verifyParameterInRequest(HttpServletRequest request, String field) {
        return request.getParameter(field) != null && !request.getParameter(field).equals("");
    }

    protected Integer getInteger(DynaActionForm dynaActionForm, String string) {
        String value = dynaActionForm.getString(string);
        return value == null || value.length() == 0 ? null : Integer.valueOf(value);
    }

    protected String getRequestParameterAsString(HttpServletRequest request, String parameterName) {
        String requestParameter = request.getParameter(parameterName);
        if (!StringUtils.isEmpty((String)requestParameter)) {
            return requestParameter;
        }
        return null;
    }

    protected Integer getIntegerFromRequestOrForm(HttpServletRequest request, DynaActionForm form, String name) {
        Integer value = this.getIntegerFromRequest(request, name);
        return value != null ? value : this.getInteger(form, name);
    }

    protected Object getFromRequestOrForm(HttpServletRequest request, DynaActionForm form, String name) {
        Object value = this.getFromRequest(request, name);
        return value != null ? value : form.get(name);
    }

    protected Object getFromRequest(HttpServletRequest request, String name) {
        String requestParameter = request.getParameter(name);
        return requestParameter != null ? requestParameter : request.getAttribute(name);
    }

    protected String getStringFromRequest(HttpServletRequest request, String name) {
        String requestParameter = request.getParameter(name);
        return requestParameter != null ? requestParameter : (String)request.getAttribute(name);
    }

    protected Integer getIntegerFromRequest(HttpServletRequest request, String name) {
        String requestParameter = request.getParameter(name);
        return !StringUtils.isEmpty((String)requestParameter) ? Integer.valueOf(requestParameter) : (Integer)request.getAttribute(name);
    }

    protected Long getLongFromRequest(HttpServletRequest request, String name) {
        String requestParameter = request.getParameter(name);
        return !StringUtils.isEmpty((String)requestParameter) ? Long.valueOf(requestParameter) : (Long)request.getAttribute(name);
    }

    public ActionForward processException(HttpServletRequest request, ActionMapping mapping, ActionForward input, Exception e) {
        ViewDestination destination;
        if (!(e instanceof DomainException)) {
            return null;
        }
        DomainException domainException = (DomainException)((Object)e);
        ActionMessages messages = this.getMessages(request);
        if (messages == null) {
            messages = new ActionMessages();
        }
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(domainException.getKey(), (Object[])domainException.getArgs()));
        this.saveMessages(request, messages);
        IViewState viewState = RenderUtils.getViewState();
        if (viewState != null && (destination = viewState.getDestination("exception")) != null) {
            return this.forwardForDestination(destination);
        }
        logger.error(e.getMessage(), (Throwable)e);
        return input;
    }

    private ActionForward forwardForDestination(ViewDestination destination) {
        ActionForward forward = new ActionForward();
        forward.setModule(destination.getModule());
        forward.setPath(destination.getPath());
        forward.setRedirect(destination.getRedirect());
        return forward;
    }

    protected Object executeFactoryMethod() throws FenixServiceException {
        return this.executeFactoryMethod(this.getFactoryObject());
    }

    protected Object executeFactoryMethod(FactoryExecutor executor) throws FenixServiceException {
        return ExecuteFactoryMethod.run(executor);
    }

    protected FactoryExecutor getFactoryObject() {
        return (FactoryExecutor)this.getRenderedObject();
    }

    protected <RenderedObjectType> RenderedObjectType getRenderedObject() {
        return (RenderedObjectType)this.getRenderedObjectFromViewState(RenderUtils.getViewState());
    }

    protected <RenderedObjectType> RenderedObjectType getRenderedObject(String id) {
        return (RenderedObjectType)this.getRenderedObjectFromViewState(RenderUtils.getViewState((String)id));
    }

    private Object getRenderedObjectFromViewState(IViewState viewState) {
        MetaObject metaObject;
        if (viewState != null && (metaObject = viewState.getMetaObject()) != null) {
            return metaObject.getObject();
        }
        return null;
    }

    protected ActionMessages getActionMessages(HttpServletRequest request) {
        return (ActionMessages)request.getAttribute(ACTION_MESSAGES_REQUEST_KEY);
    }

    protected boolean hasActionMessage(HttpServletRequest request) {
        return !this.getActionMessages(request).isEmpty();
    }

    protected void addActionMessage(HttpServletRequest request, String key, String ... args) {
        this.addActionMessage("org.apache.struts.action.GLOBAL_MESSAGE", request, key, args);
    }

    protected void addActionMessageLiteral(HttpServletRequest request, String message) {
        this.getActionMessages(request).add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(message, false));
    }

    protected void addActionMessageLiteral(String propertyName, HttpServletRequest request, String message) {
        this.getActionMessages(request).add(propertyName, new ActionMessage(message, false));
    }

    protected void addActionMessage(HttpServletRequest request, String key) {
        this.addActionMessage("org.apache.struts.action.GLOBAL_MESSAGE", request, key);
    }

    protected void addActionMessage(HttpServletRequest request, String key, boolean resource) {
        this.addActionMessage("org.apache.struts.action.GLOBAL_MESSAGE", request, key, resource);
    }

    protected void addActionMessage(String propertyName, HttpServletRequest request, String key, boolean resource) {
        this.getActionMessages(request).add(propertyName, new ActionMessage(key, resource));
    }

    protected void addActionMessage(String propertyName, HttpServletRequest request, String key) {
        this.getActionMessages(request).add(propertyName, new ActionMessage(key));
    }

    protected void addActionMessage(String propertyName, HttpServletRequest request, String key, String ... args) {
        this.getActionMessages(request).add(propertyName, new ActionMessage(key, (Object[])args));
    }

    protected String[] solveLabelFormatterArgs(HttpServletRequest request, LabelFormatter[] labelFormatterArgs) {
        String[] args = new String[labelFormatterArgs.length];
        int i = 0;
        for (LabelFormatter labelFormatter : labelFormatterArgs) {
            args[i++] = labelFormatter.toString();
        }
        return args;
    }

    protected Object getObjectFromViewState(String viewStateId) {
        IViewState viewState = RenderUtils.getViewState((String)viewStateId);
        return viewState == null ? null : viewState.getMetaObject().getObject();
    }

    protected void addRuleResultMessagesToActionMessages(String propertyName, HttpServletRequest request, RuleResult ... ruleResults) {
        for (RuleResult ruleResult : ruleResults) {
            for (RuleResultMessage message : ruleResult.getMessages()) {
                if (message.isToTranslate()) {
                    this.addActionMessage(propertyName, request, message.getMessage(), message.getArgs());
                    continue;
                }
                this.addActionMessageLiteral(propertyName, request, message.getMessage());
            }
        }
    }

    protected void addActionMessages(HttpServletRequest request, Collection<LabelFormatter> messages) {
        this.addActionMessages("org.apache.struts.action.GLOBAL_MESSAGE", request, messages);
    }

    protected void addActionMessages(String propertyName, HttpServletRequest request, Collection<LabelFormatter> messages) {
        for (LabelFormatter each : messages) {
            this.addActionMessageLiteral(propertyName, request, each.toString());
        }
    }

    protected void addErrorMessage(HttpServletRequest request, String property, String key, Object ... args) {
        ActionMessages messages = this.getErrors(request);
        messages.add(property, new ActionMessage(key, args));
        this.saveErrors(request, messages);
    }

    protected <T extends DomainObject> T getDomainObject(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        return (T)FenixFramework.getDomainObject((String)(parameter != null ? parameter : (String)request.getAttribute(name)));
    }

    protected <T extends DomainObject> T getDomainObject(DynaActionForm form, String name) {
        String parameter = (String)form.get(name);
        if (StringUtils.isEmpty((String)parameter) || parameter.startsWith("-")) {
            return null;
        }
        return (T)FenixFramework.getDomainObject((String)parameter);
    }

    public ActionForward redirect(String url, HttpServletRequest request) {
        return new FenixActionForward(request, new ActionForward(url, true));
    }

    public List<IViewState> getViewStatesWithPrefixId(String prefixId) {
        List viewStates = (List)RenderersRequestProcessorImpl.getCurrentRequest().getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        ArrayList<IViewState> result = new ArrayList<IViewState>();
        if (viewStates != null) {
            for (IViewState state : viewStates) {
                if (!state.getId().startsWith(prefixId)) continue;
                result.add(state);
            }
        }
        return result;
    }

    protected void writeFile(HttpServletResponse response, String filename, String contentType, byte[] content) throws IOException {
        response.setContentLength(content.length);
        response.setContentType(contentType);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(content);
            outputStream.flush();
            response.flushBuffer();
        }
    }

    public <T> T keepInRequest(HttpServletRequest request, String name) {
        Object fromRequest = this.getFromRequest(request, name);
        request.setAttribute(name, fromRequest);
        return (T)fromRequest;
    }

    protected void atomic(Runnable runnable) {
        FenixFramework.atomic((Runnable)runnable);
    }
}

