/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.NoCourseGroupEnrolmentBean;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.StudentEnrolmentBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.student.administrativeOfficeServices.CreateExtraEnrolment;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

public abstract class NoCourseGroupCurriculumGroupEnrolmentsDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("actionName", (Object)this.getActionName());
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        NoCourseGroupEnrolmentBean bean = this.createNoCourseGroupEnrolmentBean(this.getStudentCurricularPlan(request), this.getExecutionSemester(request));
        return this.showExtraEnrolments(bean, mapping, actionForm, request, response);
    }

    protected StudentCurricularPlan getStudentCurricularPlan(HttpServletRequest request) {
        return (StudentCurricularPlan)FenixFramework.getDomainObject((String)request.getParameter("scpID"));
    }

    protected ExecutionSemester getExecutionSemester(HttpServletRequest request) {
        return (ExecutionSemester)FenixFramework.getDomainObject((String)request.getParameter("executionPeriodID"));
    }

    protected ActionForward showExtraEnrolments(NoCourseGroupEnrolmentBean bean, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        NoCourseGroupCurriculumGroup noCourseGroupCurriculumGroup = bean.getNoCourseGroupCurriculumGroup();
        if (noCourseGroupCurriculumGroup != null) {
            bean.setCurriculumGroup((CurriculumGroup)((Object)noCourseGroupCurriculumGroup));
            if (noCourseGroupCurriculumGroup.hasAnyEnrolments()) {
                request.setAttribute("enrolments", (Object)noCourseGroupCurriculumGroup);
            }
        }
        request.setAttribute("enrolmentBean", (Object)bean);
        return mapping.findForward("showExtraEnrolments");
    }

    protected abstract NoCourseGroupEnrolmentBean createNoCourseGroupEnrolmentBean(StudentCurricularPlan var1, ExecutionSemester var2);

    public ActionForward postBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("enrolmentBean", (Object)this.getNoCourseGroupEnrolmentBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("chooseExtraEnrolment");
    }

    protected NoCourseGroupEnrolmentBean getNoCourseGroupEnrolmentBean() {
        return (NoCourseGroupEnrolmentBean)this.getRenderedObject("enrolmentBean");
    }

    public ActionForward chooseCurricular(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("enrolmentBean", (Object)this.getNoCourseGroupEnrolmentBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("chooseExtraEnrolment");
    }

    public ActionForward enrol(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        NoCourseGroupEnrolmentBean bean = this.getNoCourseGroupEnrolmentBean();
        request.setAttribute("enrolmentBean", (Object)bean);
        try {
            RuleResult ruleResult = CreateExtraEnrolment.run(bean);
            if (ruleResult.isWarning()) {
                this.addRuleResultMessagesToActionMessages("warning", request, ruleResult);
            }
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
            return mapping.findForward("chooseExtraEnrolment");
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("enrolmentError", request, ex.getFalseResult());
            return mapping.findForward("chooseExtraEnrolment");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            return mapping.findForward("chooseExtraEnrolment");
        }
        return this.showExtraEnrolments(bean, mapping, actionForm, request, response);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Enrolment enrolment = this.getEnrolment(request);
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(request);
        ExecutionSemester executionSemester = this.getExecutionSemester(request);
        try {
            studentCurricularPlan.removeCurriculumModulesFromNoCourseGroupCurriculumGroup(Collections.singletonList(enrolment), executionSemester, this.getGroupType());
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("error", request, ex.getFalseResult());
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        return this.showExtraEnrolments(this.createNoCourseGroupEnrolmentBean(studentCurricularPlan, executionSemester), mapping, actionForm, request, response);
    }

    protected Enrolment getEnrolment(HttpServletRequest request) {
        return (Enrolment)FenixFramework.getDomainObject((String)request.getParameter("enrolment"));
    }

    public ActionForward back(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        NoCourseGroupEnrolmentBean bean = this.getNoCourseGroupEnrolmentBean();
        StudentEnrolmentBean enrolmentBean = new StudentEnrolmentBean();
        enrolmentBean.setStudentCurricularPlan(bean.getStudentCurricularPlan());
        enrolmentBean.setExecutionPeriod(bean.getExecutionPeriod());
        request.setAttribute("studentEnrolmentBean", (Object)enrolmentBean);
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    public ActionForward back2(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.showExtraEnrolments(this.getNoCourseGroupEnrolmentBean(), mapping, actionForm, request, response);
    }

    protected abstract String getActionName();

    protected abstract NoCourseGroupCurriculumGroupType getGroupType();
}

