/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.degreeStructure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.util.Pair;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreeCurricularPlanRendererConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DEGREE_MODULE_ID_ATTRIBUTE_NAME = "degreeModuleOid";
    private DegreeCurricularPlan degreeCurricularPlan;
    private ExecutionYear executionInterval;
    private OrganizeType organizeBy = OrganizeType.GROUPS;
    private boolean showRules = false;
    private boolean showCourses = true;
    private String degreeModuleIdAttributeName = "degreeModuleOid";
    private boolean curricularCourseLinkable = false;
    private String viewCurricularCourseUrl = null;
    private final List<Pair<String, String>> viewCurricularCourseUrlParameters = new ArrayList<Pair<String, String>>();

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = degreeCurricularPlan;
    }

    public ExecutionYear getExecutionInterval() {
        return this.executionInterval;
    }

    public void setExecutionInterval(ExecutionYear executionInterval) {
        this.executionInterval = executionInterval;
    }

    public OrganizeType getOrganizeBy() {
        return this.organizeBy;
    }

    public void setOrganizeBy(OrganizeType organizeBy) {
        this.organizeBy = organizeBy;
    }

    public boolean organizeByGroups() {
        return this.getOrganizeBy() == OrganizeType.GROUPS;
    }

    public boolean organizeByYears() {
        return this.getOrganizeBy() == OrganizeType.YEARS;
    }

    public boolean isShowRules() {
        return this.showRules;
    }

    public void setShowRules(boolean showRules) {
        this.showRules = showRules;
    }

    public boolean isShowCourses() {
        return this.showCourses;
    }

    public void setShowCourses(boolean showCourses) {
        this.showCourses = showCourses;
    }

    private boolean hasAnyExecutionDegree() {
        return !this.getDegreeCurricularPlan().getExecutionDegreesSet().isEmpty();
    }

    private Collection<ExecutionDegree> getExecutionDegrees() {
        return this.getDegreeCurricularPlan().getExecutionDegreesSet();
    }

    private ExecutionYear getDegreeMinimumExecutionYear() {
        return this.getDegreeCurricularPlan().getRoot().getMinimumExecutionPeriod().getExecutionYear();
    }

    public String getDegreeModuleIdAttributeName() {
        return this.degreeModuleIdAttributeName;
    }

    public void setDegreeModuleIdAttributeName(String degreeModuleIdAttributeName) {
        this.degreeModuleIdAttributeName = degreeModuleIdAttributeName;
    }

    public boolean isCurricularCourseLinkable() {
        return this.curricularCourseLinkable;
    }

    private void setCurricularCourseLinkable(boolean value) {
        this.curricularCourseLinkable = value;
    }

    public String getViewCurricularCourseUrl() {
        return this.viewCurricularCourseUrl;
    }

    public void setViewCurricularCourseUrl(String url) {
        this.viewCurricularCourseUrl = url;
        this.setCurricularCourseLinkable(true);
    }

    public List<Pair<String, String>> getViewCurricularCourseUrlParameters() {
        return this.viewCurricularCourseUrlParameters;
    }

    public void addViewCurricularCourseUrlParameter(String key, String value) {
        this.viewCurricularCourseUrlParameters.add(new Pair<String, String>(key, value));
        this.setCurricularCourseLinkable(true);
    }

    private List<ExecutionYear> getSortedExecutionYearsFromExecutionDegrees() {
        ArrayList<ExecutionYear> result = new ArrayList<ExecutionYear>();
        for (ExecutionDegree executionDegree : this.getExecutionDegrees()) {
            result.add(executionDegree.getExecutionYear());
        }
        Collections.sort(result);
        return result;
    }

    public static class ExecutionIntervalProvider
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object source, Object currentValue) {
            DegreeCurricularPlanRendererConfig config = (DegreeCurricularPlanRendererConfig)source;
            return config.hasAnyExecutionDegree() ? config.getSortedExecutionYearsFromExecutionDegrees() : Collections.singletonList(config.getDegreeMinimumExecutionYear());
        }
    }

    public static enum OrganizeType {
        GROUPS,
        YEARS;

    }
}

