/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import javax.servlet.http.HttpServletRequest;

public class UIHtmlEditor
extends UIInput {
    private static final String HTML_EDITOR_HIDDEN_FIELD_PREFIX = "htmlEditor_";
    private static final String INIT_SCRIPT_FLAG_REQUEST_VARIABLE = "___FENIX_HTML_EDITOR_SCRIPT_INIT";

    public UIHtmlEditor() {
        this.setRendererType(null);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map requestMap = context.getExternalContext().getRequestMap();
        String hiddenFieldClientId = HTML_EDITOR_HIDDEN_FIELD_PREFIX + this.getClientId(context);
        String htmlEditorClientId = this.getClientId(context);
        Integer width = (Integer)this.getAttributes().get("width");
        Integer height = (Integer)this.getAttributes().get("height");
        String value = (String)this.getValue();
        Boolean showButtons = (Boolean)this.getAttributes().get("showButtons");
        Boolean required = (Boolean)this.getAttributes().get("required");
        Integer maxLength = (Integer)this.getAttributes().get("maxLength");
        if (showButtons == null) {
            showButtons = Boolean.TRUE;
        }
        this.setRequired(required != null ? required : Boolean.FALSE);
        if (maxLength != null && maxLength > 0) {
            this.addValidator((Validator)new LengthValidator(maxLength.intValue()));
        }
        this.encodeHiddenField(writer, hiddenFieldClientId, value);
        this.initializeEditorScriptIfRequired(writer, requestMap, context);
        this.encodeHtmlEditor(context, writer, hiddenFieldClientId, htmlEditorClientId, width, height, showButtons);
    }

    private void encodeHtmlEditor(FacesContext context, ResponseWriter writer, String hiddenFieldClientId, String htmlEditorClientId, Integer width, Integer height, Boolean showButtons) throws IOException {
        StringBuilder scriptBlock = new StringBuilder();
        scriptBlock.append("writeMultipleTextEditor(\"").append(htmlEditorClientId).append("\",").append(width).append(",").append(height).append(",document.getElementById('").append(hiddenFieldClientId).append("').value,").append(showButtons.toString()).append(")");
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("language", (Object)"JavaScript", null);
        writer.write("<!--\n");
        writer.writeText((Object)scriptBlock.toString(), null);
        writer.write("\n//-->");
        writer.endElement("script");
    }

    private void initializeEditorScriptIfRequired(ResponseWriter writer, Map requestMap, FacesContext context) throws IOException {
        if (!requestMap.containsKey(INIT_SCRIPT_FLAG_REQUEST_VARIABLE)) {
            String contextPath = ((HttpServletRequest)context.getExternalContext().getRequest()).getContextPath();
            writer.startElement("script", (UIComponent)this);
            writer.writeAttribute("language", (Object)"JavaScript", null);
            writer.write("<!--\n");
            String initEditorMethodCall = MessageFormat.format("initEditorWithContextPath(\"{0}\");\n", contextPath);
            writer.writeText((Object)initEditorMethodCall, null);
            writer.write("\n//-->");
            writer.endElement("script");
        }
    }

    private void encodeHiddenField(ResponseWriter writer, String clientId, String value) throws IOException {
        writer.startElement("input", (UIComponent)this);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)(value != null ? value : ""), null);
        writer.endElement("input");
    }

    public void decode(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String clientId = HTML_EDITOR_HIDDEN_FIELD_PREFIX + this.getClientId(context);
        String value = (String)requestMap.get(clientId);
        this.setSubmittedValue(value);
        this.setValid(true);
    }
}

