/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.factoryExecutors;

import java.io.Serializable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.joda.time.YearMonthDay;

public class StudentCurricularPlanFactoryExecutor {

    public static class StudentCurricularPlanCreator
    implements FactoryExecutor,
    Serializable {
        private Registration registration;
        private DegreeCurricularPlan degreeCurricularPlan;
        private CycleType cycleType;

        public StudentCurricularPlanCreator(Registration registration) {
            this.registration = registration;
        }

        @Override
        public Object execute() {
            if (this.getRegistration().getStudentCurricularPlan(this.getDegreeCurricularPlan()) != null) {
                throw new DomainException("error.registrationAlreadyHasSCPWithGivenDCP", new String[0]);
            }
            return StudentCurricularPlan.createBolonhaStudentCurricularPlan(this.getRegistration(), this.getDegreeCurricularPlan(), new YearMonthDay(), ExecutionSemester.readActualExecutionSemester(), this.getCycleType());
        }

        public DegreeCurricularPlan getDegreeCurricularPlan() {
            return this.degreeCurricularPlan;
        }

        public Registration getRegistration() {
            return this.registration;
        }

        public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
            this.degreeCurricularPlan = degreeCurricularPlan;
        }

        public void setRegistration(Registration registration) {
            this.registration = registration;
        }

        public Degree getDegree() {
            return this.getRegistration().getDegree();
        }

        public CycleType getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(CycleType cycleType) {
            this.cycleType = cycleType;
        }
    }
}

